/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.drivers.parameter;

import org.apache.flink.graph.drivers.parameter.Parameter;
import org.apache.flink.graph.drivers.parameter.ParameterizedBase;

public abstract class SimpleParameter<T>
implements Parameter<T> {
    protected final String name;
    protected boolean hasDefaultValue = false;
    protected T defaultValue;
    protected T value;

    protected SimpleParameter(ParameterizedBase owner, String name) {
        this.name = name;
        owner.addParameter(this);
    }

    protected SimpleParameter setDefaultValue(T defaultValue) {
        this.hasDefaultValue = true;
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public String getUsage() {
        String option = "--" + this.name + " " + this.name.toUpperCase();
        return this.hasDefaultValue ? "[" + option + "]" : option;
    }

    @Override
    public boolean isHidden() {
        return this.name.startsWith("__");
    }

    @Override
    public T getValue() {
        return this.value;
    }
}

