/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.examples;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.graph.EdgeJoinFunction;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.GraphAlgorithm;
import org.apache.flink.graph.Vertex;
import org.apache.flink.graph.gsa.ApplyFunction;
import org.apache.flink.graph.gsa.GSAConfiguration;
import org.apache.flink.graph.gsa.GatherFunction;
import org.apache.flink.graph.gsa.Neighbor;
import org.apache.flink.graph.gsa.SumFunction;
import org.apache.flink.types.LongValue;

public class GSAPageRank<K>
implements GraphAlgorithm<K, Double, Double, DataSet<Vertex<K, Double>>> {
    private double beta;
    private int maxIterations;

    public GSAPageRank(double beta, int maxIterations) {
        this.beta = beta;
        this.maxIterations = maxIterations;
    }

    public DataSet<Vertex<K, Double>> run(Graph<K, Double, Double> network) throws Exception {
        DataSet vertexOutDegrees = network.outDegrees();
        Graph networkWithWeights = network.joinWithEdgesOnSource(vertexOutDegrees, (EdgeJoinFunction)new InitWeights());
        GSAConfiguration parameters = new GSAConfiguration();
        parameters.setOptNumVertices(true);
        return networkWithWeights.runGatherSumApplyIteration((GatherFunction)new GatherRanks(), (SumFunction)new SumRanks(), new UpdateRanks(this.beta), this.maxIterations, parameters).getVertices();
    }

    private static final class InitWeights
    implements EdgeJoinFunction<Double, LongValue> {
        private InitWeights() {
        }

        public Double edgeJoin(Double edgeValue, LongValue inputValue) {
            return edgeValue / (double)inputValue.getValue();
        }
    }

    private static final class UpdateRanks<K>
    extends ApplyFunction<K, Double, Double> {
        private final double beta;

        public UpdateRanks(double beta) {
            this.beta = beta;
        }

        public void apply(Double rankSum, Double currentValue) {
            this.setResult((1.0 - this.beta) / (double)this.getNumberOfVertices() + this.beta * rankSum);
        }
    }

    private static final class SumRanks
    extends SumFunction<Double, Double, Double> {
        private SumRanks() {
        }

        public Double sum(Double newValue, Double currentValue) {
            return newValue + currentValue;
        }
    }

    private static final class GatherRanks
    extends GatherFunction<Double, Double, Double> {
        private GatherRanks() {
        }

        public Double gather(Neighbor<Double, Double> neighbor) {
            double neighborRank = (Double)neighbor.getNeighborValue();
            if (this.getSuperstepNumber() == 1) {
                neighborRank = 1.0 / (double)this.getNumberOfVertices();
            }
            return neighborRank * (Double)neighbor.getEdgeValue();
        }
    }
}

