/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.generator;

import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.graph.Graph;
import org.apache.flink.graph.generator.GraphGeneratorBase;
import org.apache.flink.graph.generator.GridGraph;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.util.Preconditions;

public class HypercubeGraph
extends GraphGeneratorBase<LongValue, NullValue, NullValue> {
    public static final int MINIMUM_DIMENSIONS = 1;
    private final ExecutionEnvironment env;
    private final long dimensions;

    public HypercubeGraph(ExecutionEnvironment env, long dimensions) {
        Preconditions.checkArgument((dimensions >= 1L ? 1 : 0) != 0, (Object)"Number of dimensions must be at least 1");
        this.env = env;
        this.dimensions = dimensions;
    }

    @Override
    public Graph<LongValue, NullValue, NullValue> generate() {
        Preconditions.checkState((this.dimensions > 0L ? 1 : 0) != 0);
        GridGraph graph = new GridGraph(this.env);
        int i = 0;
        while ((long)i < this.dimensions) {
            graph.addDimension(2L, false);
            ++i;
        }
        return graph.setParallelism(this.parallelism).generate();
    }
}

