/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.graph.types.valuearray;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.graph.types.valuearray.ValueArray;
import org.apache.flink.graph.utils.MurmurHash;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.Preconditions;

public class StringValueArray
implements ValueArray<StringValue> {
    protected static final int DEFAULT_CAPACITY_IN_BYTES = 4096;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    protected static final int HIGH_BIT = 128;
    private boolean isBounded;
    private int boundedLength;
    private byte[] data;
    private int length;
    private int position;
    private transient int markLength;
    private transient int markPosition;
    private MurmurHash hash = new MurmurHash(421937968);
    private IntValue hashValue = new IntValue();
    private final ReadIterator iterator = new ReadIterator();

    public StringValueArray() {
        this.isBounded = false;
        this.initialize(4096);
    }

    public StringValueArray(int bytes) {
        this.isBounded = true;
        this.boundedLength = bytes;
        this.initialize(bytes);
    }

    private void initialize(int bytes) {
        Preconditions.checkArgument((bytes > 0 ? 1 : 0) != 0, (Object)"Requested array with zero capacity");
        Preconditions.checkArgument((bytes <= 0x7FFFFFF7 ? 1 : 0) != 0, (Object)"Requested capacity exceeds limit of 2147483639");
        this.data = new byte[bytes];
    }

    private void ensureCapacity(int minCapacity) {
        long currentCapacity = this.data.length;
        if ((long)minCapacity <= currentCapacity) {
            return;
        }
        long expandedCapacity = Math.max((long)minCapacity, currentCapacity + (currentCapacity >> 1));
        int newCapacity = (int)Math.min(0x7FFFFFF7L, expandedCapacity);
        if (newCapacity < minCapacity) {
            throw new RuntimeException("Requested array size " + minCapacity + " exceeds limit of " + 0x7FFFFFF7);
        }
        this.data = Arrays.copyOf(this.data, newCapacity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        String separator = "";
        for (StringValue sv : this) {
            sb.append(sv.getValue()).append(separator);
            separator = ",";
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Iterator<StringValue> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.length);
        out.writeInt(this.position);
        out.write(this.data, 0, this.position);
    }

    public void read(DataInputView in) throws IOException {
        this.length = in.readInt();
        this.position = in.readInt();
        this.markLength = 0;
        this.markPosition = 0;
        this.ensureCapacity(this.position);
        in.read(this.data, 0, this.position);
    }

    public int getMaxNormalizedKeyLen() {
        return this.hashValue.getMaxNormalizedKeyLen();
    }

    public void copyNormalizedKey(MemorySegment target, int offset, int len) {
        this.hash.reset();
        this.hash.hash(this.position);
        for (int i = 0; i < this.position; ++i) {
            this.hash.hash(this.data[i]);
        }
        this.hashValue.setValue(this.hash.hash());
        this.hashValue.copyNormalizedKey(target, offset, len);
    }

    public int compareTo(ValueArray<StringValue> o) {
        StringValueArray other = (StringValueArray)o;
        int cmp = Integer.compare(this.position, other.position);
        if (cmp != 0) {
            return cmp;
        }
        for (int i = 0; i < this.position; ++i) {
            cmp = Byte.compare(this.data[i], other.data[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.position; ++i) {
            hash = 31 * hash + this.data[i];
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringValueArray) {
            StringValueArray other = (StringValueArray)obj;
            if (this.length != other.length) {
                return false;
            }
            if (this.position != other.position) {
                return false;
            }
            for (int i = 0; i < this.position; ++i) {
                if (this.data[i] == other.data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void setValue(ValueArray<StringValue> value) {
        value.copyTo(this);
    }

    public int getBinaryLength() {
        return -1;
    }

    public void copyTo(ValueArray<StringValue> target) {
        StringValueArray other = (StringValueArray)target;
        other.length = this.length;
        other.position = this.position;
        other.markLength = this.markLength;
        other.markPosition = this.markPosition;
        other.ensureCapacity(this.position);
        System.arraycopy(this.data, 0, other.data, 0, this.position);
    }

    public ValueArray<StringValue> copy() {
        StringValueArray copy = new StringValueArray();
        this.copyTo(copy);
        return copy;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        StringValueArray.copyInternal(source, target);
    }

    protected static void copyInternal(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        int position = source.readInt();
        target.writeInt(position);
        target.write(source, position);
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isFull() {
        if (this.isBounded) {
            return this.position >= this.boundedLength;
        }
        return this.position == 0x7FFFFFF7;
    }

    @Override
    public boolean add(StringValue value) {
        int len;
        if (this.isBounded && this.position >= this.boundedLength) {
            return false;
        }
        if (this.position + 5 > this.data.length) {
            this.ensureCapacity(this.position + 5);
        }
        int newPosition = this.position;
        for (len = value.length(); len >= 128; len >>>= 7) {
            this.data[newPosition++] = (byte)(len | 0x80);
        }
        this.data[newPosition++] = (byte)len;
        char[] valueData = value.getCharArray();
        int remainingCapacity = this.data.length - newPosition;
        len = value.length();
        for (int i = 0; i < len; ++i) {
            int c;
            if (remainingCapacity < 3) {
                this.ensureCapacity(remainingCapacity + 3);
                remainingCapacity = this.data.length - newPosition;
            }
            for (c = valueData[i]; c >= 128; c >>>= 7) {
                this.data[newPosition++] = (byte)(c | 0x80);
                --remainingCapacity;
            }
            this.data[newPosition++] = (byte)c;
            --remainingCapacity;
        }
        ++this.length;
        this.position = newPosition;
        return true;
    }

    @Override
    public boolean addAll(ValueArray<StringValue> other) {
        StringValueArray source = (StringValueArray)other;
        int sourceSize = source.position;
        int newPosition = this.position + sourceSize;
        if (newPosition > this.data.length) {
            if (this.isBounded) {
                return false;
            }
            this.ensureCapacity(newPosition);
        }
        System.arraycopy(source.data, 0, this.data, this.position, sourceSize);
        this.length += source.length;
        this.position = newPosition;
        return true;
    }

    @Override
    public void clear() {
        this.length = 0;
        this.position = 0;
    }

    @Override
    public void mark() {
        this.markLength = this.length;
        this.markPosition = this.position;
    }

    @Override
    public void reset() {
        this.length = this.markLength;
        this.position = this.markPosition;
    }

    private class ReadIterator
    implements Iterator<StringValue> {
        private static final int DEFAULT_SIZE = 64;
        private StringValue value = new StringValue((CharSequence)CharBuffer.allocate(64));
        private int size = 64;
        private int pos;

        private ReadIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < StringValueArray.this.position;
        }

        @Override
        public StringValue next() {
            int len = StringValueArray.this.data[this.pos++] & 0xFF;
            if (len >= 128) {
                int curr;
                int shift = 7;
                len &= 0x7F;
                while ((curr = StringValueArray.this.data[this.pos++] & 0xFF) >= 128) {
                    len |= (curr & 0x7F) << shift;
                    shift += 7;
                }
                len |= curr << shift;
            }
            if (len > this.size) {
                while (this.size < len) {
                    this.size *= 2;
                }
                this.value = new StringValue((CharSequence)CharBuffer.allocate(this.size));
            }
            char[] valueData = this.value.getCharArray();
            for (int i = 0; i < len; ++i) {
                int c = StringValueArray.this.data[this.pos++] & 0xFF;
                if (c >= 128) {
                    int curr;
                    int shift = 7;
                    c &= 0x7F;
                    while ((curr = StringValueArray.this.data[this.pos++] & 0xFF) >= 128) {
                        c |= (curr & 0x7F) << shift;
                        shift += 7;
                    }
                    c |= curr << shift;
                }
                valueData[i] = (char)c;
            }
            return this.value.substring(0, len);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public void reset() {
            this.pos = 0;
        }
    }
}

