/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.math;

import breeze.linalg.DenseVector;
import breeze.linalg.Vector;
import org.apache.flink.ml.math.BreezeVectorConverter;
import org.apache.flink.ml.math.SparseVector;
import org.apache.flink.ml.math.SparseVector$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Sorting$;

public final class SparseVector$
implements Serializable {
    public static final SparseVector$ MODULE$;
    private final Object sparseVectorConverter;

    static {
        new SparseVector$();
    }

    public SparseVector fromCOO(int size, Seq<Tuple2<Object, Object>> entries) {
        return this.fromCOO(size, (Iterable<Tuple2<Object, Object>>)entries);
    }

    public SparseVector fromCOO(int size, Iterable<Tuple2<Object, Object>> entries) {
        Tuple2[] entryArray = (Tuple2[])entries.toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        Predef$.MODULE$.refArrayOps((Object[])entryArray).foreach((Function1)new Serializable(size){
            public static final long serialVersionUID = 0L;
            public final int size$1;

            public final void apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    int index = tuple2._1$mcI$sp();
                    Predef$.MODULE$.require(0 <= index && index < this.size$1, (Function0)new Serializable(this, index){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.fromCOO.1 $outer;
                        private final int index$2;

                        public final String apply() {
                            return new StringBuilder().append(this.index$2).append((Object)" not in [0, ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.size$1)).append((Object)")").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.index$2 = index$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.size$1 = size$1;
            }
        });
        Ordering<Tuple2<Object, Object>> COOOrdering = new Ordering<Tuple2<Object, Object>>(){

            public Some tryCompare(Object x, Object y) {
                return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lteq(Object x, Object y) {
                return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gteq(Object x, Object y) {
                return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
            }

            public boolean lt(Object x, Object y) {
                return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean gt(Object x, Object y) {
                return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
            }

            public boolean equiv(Object x, Object y) {
                return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
            }

            public Object max(Object x, Object y) {
                return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
            }

            public Object min(Object x, Object y) {
                return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
            }

            public Ordering<Tuple2<Object, Object>> reverse() {
                return Ordering.class.reverse((Ordering)this);
            }

            public <U> Ordering<U> on(Function1<U, Tuple2<Object, Object>> f) {
                return Ordering.class.on((Ordering)this, f);
            }

            public Ordering.Ops mkOrderingOps(Object lhs) {
                return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
            }

            public int compare(Tuple2<Object, Object> x, Tuple2<Object, Object> y) {
                return x._1$mcI$sp() - y._1$mcI$sp();
            }
            {
                PartialOrdering.class.$init$((PartialOrdering)this);
                Ordering.class.$init$((Ordering)this);
            }
        };
        Sorting$.MODULE$.quickSort((Object)entryArray, (Ordering)COOOrdering);
        int arraySize = ((Tuple2)Predef$.MODULE$.refArrayOps((Object[])entryArray).foldLeft((Object)new Tuple2.mcII.sp(-1, 0), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$3, Tuple2<Object, Object> x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$3, x1$1);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        int lastIndex = tuple22._1$mcI$sp();
                        int numRows = tuple22._2$mcI$sp();
                        if (tuple23 != null) {
                            int index = tuple23._1$mcI$sp();
                            Tuple2.mcII.sp sp2 = lastIndex == index ? new Tuple2.mcII.sp(lastIndex, numRows) : new Tuple2.mcII.sp(index, numRows + 1);
                            return sp2;
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        }))._2$mcI$sp();
        int[] indices = new int[arraySize];
        double[] data = new double[arraySize];
        Tuple2 tuple2 = entryArray[0];
        if (tuple2 != null) {
            Tuple2.mcID.sp sp2;
            int index = tuple2._1$mcI$sp();
            double value = tuple2._2$mcD$sp();
            Tuple2.mcID.sp sp3 = sp2 = new Tuple2.mcID.sp(index, value);
            int index2 = sp3._1$mcI$sp();
            double value2 = sp3._2$mcD$sp();
            indices[0] = index2;
            data[0] = value2;
            int lastIndex = indices[0];
            int lastDataIndex = 0;
            for (int i = 1; i < entryArray.length; ++i) {
                Tuple2 tuple22 = entryArray[i];
                if (tuple22 != null) {
                    Tuple2.mcID.sp sp4;
                    int curIndex = tuple22._1$mcI$sp();
                    double curValue = tuple22._2$mcD$sp();
                    Tuple2.mcID.sp sp5 = sp4 = new Tuple2.mcID.sp(curIndex, curValue);
                    int curIndex2 = sp5._1$mcI$sp();
                    double curValue2 = sp5._2$mcD$sp();
                    if (curIndex2 == lastIndex) {
                        int n = lastDataIndex;
                        data[n] = data[n] + curValue2;
                        continue;
                    }
                    data[++lastDataIndex] = curValue2;
                    indices[lastDataIndex] = curIndex2;
                    lastIndex = curIndex2;
                    continue;
                }
                throw new MatchError((Object)tuple22);
            }
            return new SparseVector(size, indices, data);
        }
        throw new MatchError((Object)tuple2);
    }

    public SparseVector fromCOO(int size, Tuple2<Object, Object> entry) {
        return this.fromCOO(size, (Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(entry._1$mcI$sp(), (double)entry._2$mcI$sp())}));
    }

    public Object sparseVectorConverter() {
        return this.sparseVectorConverter;
    }

    public SparseVector apply(int size, int[] indices, double[] data) {
        return new SparseVector(size, indices, data);
    }

    public Option<Tuple3<Object, int[], double[]>> unapply(SparseVector x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)x$0.size()), (Object)x$0.indices(), (Object)x$0.data()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparseVector$() {
        MODULE$ = this;
        this.sparseVectorConverter = new BreezeVectorConverter<SparseVector>(){

            public SparseVector convert(Vector<Object> vector) {
                Vector<Object> vector2;
                block4: {
                    SparseVector sparseVector;
                    block3: {
                        block2: {
                            vector2 = vector;
                            if (!(vector2 instanceof DenseVector)) break block2;
                            DenseVector denseVector = (DenseVector)vector2;
                            sparseVector = SparseVector$.MODULE$.fromCOO(denseVector.length(), (Iterable<Tuple2<Object, Object>>)denseVector.iterator().toIterable());
                            break block3;
                        }
                        if (!(vector2 instanceof breeze.linalg.SparseVector)) break block4;
                        breeze.linalg.SparseVector sparseVector2 = (breeze.linalg.SparseVector)vector2;
                        sparseVector = new SparseVector(sparseVector2.length(), (int[])Predef$.MODULE$.intArrayOps(sparseVector2.index()).take(sparseVector2.used()), (double[])Predef$.MODULE$.doubleArrayOps(sparseVector2.data$mcD$sp()).take(sparseVector2.used()));
                    }
                    return sparseVector;
                }
                throw new MatchError(vector2);
            }
        };
    }
}

