/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.optimization;

import breeze.linalg.Vector$;
import breeze.linalg.norm$;
import org.apache.flink.ml.math.BLAS$;
import org.apache.flink.ml.math.Breeze$;
import org.apache.flink.ml.math.Vector;
import org.apache.flink.ml.optimization.RegularizationPenalty;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class L1Regularization$
implements RegularizationPenalty {
    public static final L1Regularization$ MODULE$;

    static {
        new L1Regularization$();
    }

    @Override
    public Vector takeStep(Vector weightVector, Vector gradient, double regularizationConstant, double learningRate) {
        BLAS$.MODULE$.axpy(-learningRate, gradient, weightVector);
        double shrinkageVal = regularizationConstant * learningRate;
        for (int i = 0; i < weightVector.size(); ++i) {
            double wi = weightVector.apply(i);
            weightVector.update(i, package$.MODULE$.signum(wi) * package$.MODULE$.max(0.0, package$.MODULE$.abs(wi) - shrinkageVal));
        }
        return weightVector;
    }

    @Override
    public double regLoss(double oldLoss, Vector weightVector, double regularizationConstant) {
        double norm = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(Breeze$.MODULE$.Vector2BreezeConverter(weightVector).asBreeze(), (Object)BoxesRunTime.boxToDouble((double)1.0), Vector$.MODULE$.canNorm(norm$.MODULE$.scalarNorm_Double())));
        return oldLoss + norm * regularizationConstant;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private L1Regularization$() {
        MODULE$ = this;
    }
}

