/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointStore;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV2;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavepointLoader {
    private static final Logger LOG = LoggerFactory.getLogger(SavepointLoader.class);

    public static CompletedCheckpoint loadAndValidateSavepoint(JobID jobId, Map<JobVertexID, ExecutionJobVertex> tasks, String savepointPath, ClassLoader classLoader, boolean allowNonRestoredState) throws IOException {
        Tuple2<Savepoint, StreamStateHandle> savepointAndHandle = SavepointStore.loadSavepointWithHandle(savepointPath, classLoader);
        Savepoint savepoint = (Savepoint)savepointAndHandle.f0;
        StreamStateHandle metadataHandle = (StreamStateHandle)savepointAndHandle.f1;
        if (savepoint.getTaskStates() != null) {
            savepoint = SavepointV2.convertToOperatorStateSavepointV2(tasks, savepoint);
        }
        Map<OperatorID, ExecutionJobVertex> operatorToJobVertexMapping = new HashMap<OperatorID, ExecutionJobVertex>();
        for (ExecutionJobVertex task : tasks.values()) {
            for (OperatorID operatorID : task.getOperatorIDs()) {
                operatorToJobVertexMapping.put(operatorID, task);
            }
        }
        boolean expandedToLegacyIds = false;
        HashMap<OperatorID, OperatorState> operatorStates = new HashMap<OperatorID, OperatorState>(savepoint.getOperatorStates().size());
        for (OperatorState operatorState : savepoint.getOperatorStates()) {
            ExecutionJobVertex executionJobVertex = (ExecutionJobVertex)operatorToJobVertexMapping.get((Object)operatorState.getOperatorID());
            if (executionJobVertex == null && !expandedToLegacyIds) {
                operatorToJobVertexMapping = ExecutionJobVertex.includeAlternativeOperatorIDs(operatorToJobVertexMapping);
                executionJobVertex = operatorToJobVertexMapping.get((Object)operatorState.getOperatorID());
                expandedToLegacyIds = true;
                LOG.info("Could not find ExecutionJobVertex. Including user-defined OperatorIDs in search.");
            }
            if (executionJobVertex != null) {
                if (executionJobVertex.getMaxParallelism() == operatorState.getMaxParallelism() || !executionJobVertex.isMaxParallelismConfigured()) {
                    operatorStates.put(operatorState.getOperatorID(), operatorState);
                    continue;
                }
                String msg = String.format("Failed to rollback to savepoint %s. Max parallelism mismatch between savepoint state and new program. Cannot map operator %s with max parallelism %d to new program with max parallelism %d. This indicates that the program has been changed in a non-compatible way after the savepoint.", new Object[]{savepoint, operatorState.getOperatorID(), operatorState.getMaxParallelism(), executionJobVertex.getMaxParallelism()});
                throw new IllegalStateException(msg);
            }
            if (allowNonRestoredState) {
                LOG.info("Skipping savepoint state for operator {}.", (Object)operatorState.getOperatorID());
                continue;
            }
            for (OperatorSubtaskState operatorSubtaskState : operatorState.getStates()) {
                if (!operatorSubtaskState.hasState()) continue;
                String msg = String.format("Failed to rollback to savepoint %s. Cannot map savepoint state for operator %s to the new program, because the operator is not available in the new program. If you want to allow to skip this, you can set the --allowNonRestoredState option on the CLI.", new Object[]{savepointPath, operatorState.getOperatorID()});
                throw new IllegalStateException(msg);
            }
            LOG.info("Skipping empty savepoint state for operator {}.", (Object)operatorState.getOperatorID());
        }
        CheckpointProperties props2 = CheckpointProperties.forStandardSavepoint();
        return new CompletedCheckpoint(jobId, savepoint.getCheckpointId(), 0L, 0L, operatorStates, savepoint.getMasterStates(), props2, metadataHandle, savepointPath);
    }

    private SavepointLoader() {
    }
}

