/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.rest.RestServerEndpoint;
import org.apache.flink.runtime.rest.RestServerEndpointConfiguration;
import org.apache.flink.runtime.rest.handler.LegacyRestHandlerAdapter;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.runtime.rest.handler.job.BlobServerPortHandler;
import org.apache.flink.runtime.rest.handler.job.JobConfigHandler;
import org.apache.flink.runtime.rest.handler.job.JobExceptionsHandler;
import org.apache.flink.runtime.rest.handler.job.JobPlanHandler;
import org.apache.flink.runtime.rest.handler.job.JobSubmitHandler;
import org.apache.flink.runtime.rest.handler.job.JobTerminationHandler;
import org.apache.flink.runtime.rest.handler.job.JobVertexAccumulatorsHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointConfigHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointStatisticDetailsHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointStatsCache;
import org.apache.flink.runtime.rest.handler.job.checkpoints.CheckpointingStatisticsHandler;
import org.apache.flink.runtime.rest.handler.job.checkpoints.TaskCheckpointStatisticDetailsHandler;
import org.apache.flink.runtime.rest.handler.legacy.ClusterConfigHandler;
import org.apache.flink.runtime.rest.handler.legacy.ClusterOverviewHandler;
import org.apache.flink.runtime.rest.handler.legacy.CurrentJobsOverviewHandler;
import org.apache.flink.runtime.rest.handler.legacy.DashboardConfigHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.files.StaticFileServerHandler;
import org.apache.flink.runtime.rest.handler.legacy.files.WebContentHandlerSpecification;
import org.apache.flink.runtime.rest.handler.legacy.messages.ClusterOverviewWithVersion;
import org.apache.flink.runtime.rest.messages.ClusterConfigurationInfo;
import org.apache.flink.runtime.rest.messages.ClusterConfigurationInfoHeaders;
import org.apache.flink.runtime.rest.messages.ClusterOverviewHeaders;
import org.apache.flink.runtime.rest.messages.CurrentJobsOverviewHandlerHeaders;
import org.apache.flink.runtime.rest.messages.DashboardConfiguration;
import org.apache.flink.runtime.rest.messages.DashboardConfigurationHeaders;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.JobConfigHeaders;
import org.apache.flink.runtime.rest.messages.JobExceptionsHeaders;
import org.apache.flink.runtime.rest.messages.JobPlanHeaders;
import org.apache.flink.runtime.rest.messages.JobTerminationHeaders;
import org.apache.flink.runtime.rest.messages.JobVertexAccumulatorsHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointConfigHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointStatisticDetailsHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointingStatisticsHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.TaskCheckpointStatisticsHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;

public class DispatcherRestEndpoint
extends RestServerEndpoint {
    private final GatewayRetriever<DispatcherGateway> leaderRetriever;
    private final Configuration clusterConfiguration;
    private final RestHandlerConfiguration restConfiguration;
    private final Executor executor;
    private final ExecutionGraphCache executionGraphCache;
    private final CheckpointStatsCache checkpointStatsCache;

    public DispatcherRestEndpoint(RestServerEndpointConfiguration endpointConfiguration, GatewayRetriever<DispatcherGateway> leaderRetriever, Configuration clusterConfiguration, RestHandlerConfiguration restConfiguration, Executor executor) {
        super(endpointConfiguration);
        this.leaderRetriever = (GatewayRetriever)Preconditions.checkNotNull(leaderRetriever);
        this.clusterConfiguration = (Configuration)Preconditions.checkNotNull((Object)clusterConfiguration);
        this.restConfiguration = (RestHandlerConfiguration)Preconditions.checkNotNull((Object)restConfiguration);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.executionGraphCache = new ExecutionGraphCache(restConfiguration.getTimeout(), Time.milliseconds((long)restConfiguration.getRefreshInterval()));
        this.checkpointStatsCache = new CheckpointStatsCache(restConfiguration.getMaxCheckpointStatisticCacheEntries());
    }

    @Override
    protected Collection<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> initializeHandlers(CompletableFuture<String> restAddressFuture) {
        Optional<StaticFileServerHandler<DispatcherGateway>> optWebContent;
        ArrayList<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers = new ArrayList<Tuple2<RestHandlerSpecification, ChannelInboundHandler>>(3);
        Time timeout = this.restConfiguration.getTimeout();
        LegacyRestHandlerAdapter<DispatcherGateway, ClusterOverviewWithVersion, EmptyMessageParameters> clusterOverviewHandler = new LegacyRestHandlerAdapter<DispatcherGateway, ClusterOverviewWithVersion, EmptyMessageParameters>(restAddressFuture, this.leaderRetriever, timeout, ClusterOverviewHeaders.getInstance(), new ClusterOverviewHandler(this.executor, timeout));
        LegacyRestHandlerAdapter<DispatcherGateway, DashboardConfiguration, EmptyMessageParameters> dashboardConfigurationHandler = new LegacyRestHandlerAdapter<DispatcherGateway, DashboardConfiguration, EmptyMessageParameters>(restAddressFuture, this.leaderRetriever, timeout, DashboardConfigurationHeaders.getInstance(), new DashboardConfigHandler(this.executor, this.restConfiguration.getRefreshInterval()));
        LegacyRestHandlerAdapter<DispatcherGateway, MultipleJobsDetails, EmptyMessageParameters> currentJobsOverviewHandler = new LegacyRestHandlerAdapter<DispatcherGateway, MultipleJobsDetails, EmptyMessageParameters>(restAddressFuture, this.leaderRetriever, timeout, CurrentJobsOverviewHandlerHeaders.getInstance(), new CurrentJobsOverviewHandler(this.executor, timeout, true, true));
        LegacyRestHandlerAdapter<DispatcherGateway, ClusterConfigurationInfo, EmptyMessageParameters> clusterConfigurationHandler = new LegacyRestHandlerAdapter<DispatcherGateway, ClusterConfigurationInfo, EmptyMessageParameters>(restAddressFuture, this.leaderRetriever, timeout, ClusterConfigurationInfoHeaders.getInstance(), new ClusterConfigHandler(this.executor, this.clusterConfiguration));
        JobTerminationHandler jobTerminationHandler = new JobTerminationHandler(restAddressFuture, this.leaderRetriever, timeout, JobTerminationHeaders.getInstance());
        JobConfigHandler jobConfigHandler = new JobConfigHandler(restAddressFuture, (GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, JobConfigHeaders.getInstance(), this.executionGraphCache, this.executor);
        CheckpointConfigHandler checkpointConfigHandler = new CheckpointConfigHandler(restAddressFuture, (GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, CheckpointConfigHeaders.getInstance(), this.executionGraphCache, this.executor);
        CheckpointingStatisticsHandler checkpointStatisticsHandler = new CheckpointingStatisticsHandler(restAddressFuture, (GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, CheckpointingStatisticsHeaders.getInstance(), this.executionGraphCache, this.executor);
        CheckpointStatisticDetailsHandler checkpointStatisticDetailsHandler = new CheckpointStatisticDetailsHandler(restAddressFuture, (GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, CheckpointStatisticDetailsHeaders.getInstance(), this.executionGraphCache, this.executor, this.checkpointStatsCache);
        JobPlanHandler jobPlanHandler = new JobPlanHandler(restAddressFuture, (GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, JobPlanHeaders.getInstance(), this.executionGraphCache, this.executor);
        TaskCheckpointStatisticDetailsHandler taskCheckpointStatisticDetailsHandler = new TaskCheckpointStatisticDetailsHandler(restAddressFuture, (GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, TaskCheckpointStatisticsHeaders.getInstance(), this.executionGraphCache, this.executor, this.checkpointStatsCache);
        JobExceptionsHandler jobExceptionsHandler = new JobExceptionsHandler(restAddressFuture, (GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, JobExceptionsHeaders.getInstance(), this.executionGraphCache, this.executor);
        JobVertexAccumulatorsHandler jobVertexAccumulatorsHandler = new JobVertexAccumulatorsHandler(restAddressFuture, (GatewayRetriever<? extends RestfulGateway>)this.leaderRetriever, timeout, JobVertexAccumulatorsHeaders.getInstance(), this.executionGraphCache, this.executor);
        File tmpDir = this.restConfiguration.getTmpDir();
        try {
            optWebContent = WebMonitorUtils.tryLoadWebContent(this.leaderRetriever, restAddressFuture, timeout, tmpDir);
        }
        catch (IOException e) {
            this.log.warn("Could not load web content handler.", (Throwable)e);
            optWebContent = Optional.empty();
        }
        handlers.add(Tuple2.of((Object)ClusterOverviewHeaders.getInstance(), clusterOverviewHandler));
        handlers.add(Tuple2.of((Object)ClusterConfigurationInfoHeaders.getInstance(), clusterConfigurationHandler));
        handlers.add(Tuple2.of((Object)DashboardConfigurationHeaders.getInstance(), dashboardConfigurationHandler));
        handlers.add(Tuple2.of((Object)CurrentJobsOverviewHandlerHeaders.getInstance(), currentJobsOverviewHandler));
        handlers.add(Tuple2.of((Object)JobTerminationHeaders.getInstance(), (Object)((Object)jobTerminationHandler)));
        handlers.add(Tuple2.of((Object)JobConfigHeaders.getInstance(), (Object)((Object)jobConfigHandler)));
        handlers.add(Tuple2.of((Object)CheckpointConfigHeaders.getInstance(), (Object)((Object)checkpointConfigHandler)));
        handlers.add(Tuple2.of((Object)CheckpointingStatisticsHeaders.getInstance(), (Object)((Object)checkpointStatisticsHandler)));
        handlers.add(Tuple2.of((Object)CheckpointStatisticDetailsHeaders.getInstance(), (Object)((Object)checkpointStatisticDetailsHandler)));
        handlers.add(Tuple2.of((Object)JobPlanHeaders.getInstance(), (Object)((Object)jobPlanHandler)));
        handlers.add(Tuple2.of((Object)TaskCheckpointStatisticsHeaders.getInstance(), (Object)((Object)taskCheckpointStatisticDetailsHandler)));
        handlers.add(Tuple2.of((Object)JobExceptionsHeaders.getInstance(), (Object)((Object)jobExceptionsHandler)));
        handlers.add(Tuple2.of((Object)JobVertexAccumulatorsHeaders.getInstance(), (Object)((Object)jobVertexAccumulatorsHandler)));
        BlobServerPortHandler blobServerPortHandler = new BlobServerPortHandler(restAddressFuture, this.leaderRetriever, timeout);
        handlers.add(Tuple2.of(blobServerPortHandler.getMessageHeaders(), (Object)((Object)blobServerPortHandler)));
        JobSubmitHandler jobSubmitHandler = new JobSubmitHandler(restAddressFuture, this.leaderRetriever, timeout);
        handlers.add(Tuple2.of(jobSubmitHandler.getMessageHeaders(), (Object)((Object)jobSubmitHandler)));
        optWebContent.ifPresent(webContent -> handlers.add(Tuple2.of((Object)WebContentHandlerSpecification.getInstance(), (Object)webContent)));
        return handlers;
    }

    @Override
    public void shutdown(Time timeout) {
        super.shutdown(timeout);
        this.executionGraphCache.close();
        File tmpDir = this.restConfiguration.getTmpDir();
        try {
            this.log.info("Removing cache directory {}", (Object)tmpDir);
            FileUtils.deleteDirectory((File)tmpDir);
        }
        catch (Throwable t) {
            this.log.warn("Error while deleting cache directory {}", (Object)tmpDir, (Object)t);
        }
    }
}

