/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.deployment.InputChannelDeploymentDescriptor;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionLocation;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputGateListener;
import org.apache.flink.runtime.io.network.partition.consumer.LocalInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.UnknownInputChannel;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleInputGate
implements InputGate {
    private static final Logger LOG = LoggerFactory.getLogger(SingleInputGate.class);
    private final Object requestLock = new Object();
    private final String owningTaskName;
    private final JobID jobId;
    private final IntermediateDataSetID consumedResultId;
    private final ResultPartitionType consumedPartitionType;
    private final int consumedSubpartitionIndex;
    private final int numberOfInputChannels;
    private final Map<IntermediateResultPartitionID, InputChannel> inputChannels;
    private final ArrayDeque<InputChannel> inputChannelsWithData = new ArrayDeque();
    private final BitSet channelsWithEndOfPartitionEvents;
    private final TaskActions taskActions;
    private BufferPool bufferPool;
    private NetworkBufferPool networkBufferPool;
    private boolean hasReceivedAllEndOfPartitionEvents;
    private boolean requestedPartitionsFlag;
    private volatile boolean isReleased;
    private volatile InputGateListener inputGateListener;
    private final List<TaskEvent> pendingEvents = new ArrayList<TaskEvent>();
    private int numberOfUninitializedChannels;
    private int networkBuffersPerChannel;
    private Timer retriggerLocalRequestTimer;

    public SingleInputGate(String owningTaskName, JobID jobId, IntermediateDataSetID consumedResultId, ResultPartitionType consumedPartitionType, int consumedSubpartitionIndex, int numberOfInputChannels, TaskActions taskActions, TaskIOMetricGroup metrics) {
        this.owningTaskName = (String)Preconditions.checkNotNull((Object)owningTaskName);
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.consumedResultId = (IntermediateDataSetID)((Object)Preconditions.checkNotNull((Object)((Object)consumedResultId)));
        this.consumedPartitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)consumedPartitionType)));
        Preconditions.checkArgument((consumedSubpartitionIndex >= 0 ? 1 : 0) != 0);
        this.consumedSubpartitionIndex = consumedSubpartitionIndex;
        Preconditions.checkArgument((numberOfInputChannels > 0 ? 1 : 0) != 0);
        this.numberOfInputChannels = numberOfInputChannels;
        this.inputChannels = new HashMap<IntermediateResultPartitionID, InputChannel>(numberOfInputChannels);
        this.channelsWithEndOfPartitionEvents = new BitSet(numberOfInputChannels);
        this.taskActions = (TaskActions)Preconditions.checkNotNull((Object)taskActions);
    }

    @Override
    public int getNumberOfInputChannels() {
        return this.numberOfInputChannels;
    }

    public IntermediateDataSetID getConsumedResultId() {
        return this.consumedResultId;
    }

    public ResultPartitionType getConsumedPartitionType() {
        return this.consumedPartitionType;
    }

    BufferProvider getBufferProvider() {
        return this.bufferPool;
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public int getPageSize() {
        if (this.bufferPool != null) {
            return this.bufferPool.getMemorySegmentSize();
        }
        throw new IllegalStateException("Input gate has not been initialized with buffers.");
    }

    public int getNumberOfQueuedBuffers() {
        for (int retry2 = 0; retry2 < 3; ++retry2) {
            try {
                int totalBuffers = 0;
                for (InputChannel channel : this.inputChannels.values()) {
                    if (!(channel instanceof RemoteInputChannel)) continue;
                    totalBuffers += ((RemoteInputChannel)channel).getNumberOfQueuedBuffers();
                }
                return totalBuffers;
            }
            catch (Exception exception) {
                continue;
            }
        }
        return 0;
    }

    public void setBufferPool(BufferPool bufferPool) {
        if (!this.getConsumedPartitionType().isCreditBased()) {
            Preconditions.checkArgument((this.numberOfInputChannels == bufferPool.getNumberOfRequiredMemorySegments() ? 1 : 0) != 0, (Object)"Bug in input gate setup logic: buffer pool has not enough guaranteed buffers for this input gate. Input gates require at least as many buffers as there are input channels.");
        }
        Preconditions.checkState((this.bufferPool == null ? 1 : 0) != 0, (Object)"Bug in input gate setup logic: buffer pool hasalready been set for this input gate.");
        this.bufferPool = (BufferPool)Preconditions.checkNotNull((Object)bufferPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignExclusiveSegments(NetworkBufferPool networkBufferPool, int networkBuffersPerChannel) throws IOException {
        Preconditions.checkState((this.networkBufferPool == null ? 1 : 0) != 0, (Object)"Bug in input gate setup logic: global buffer pool hasalready been set for this input gate.");
        this.networkBufferPool = (NetworkBufferPool)Preconditions.checkNotNull((Object)networkBufferPool);
        this.networkBuffersPerChannel = networkBuffersPerChannel;
        Object object = this.requestLock;
        synchronized (object) {
            for (InputChannel inputChannel : this.inputChannels.values()) {
                if (!(inputChannel instanceof RemoteInputChannel)) continue;
                ((RemoteInputChannel)inputChannel).assignExclusiveSegments(networkBufferPool.requestMemorySegments(networkBuffersPerChannel));
            }
        }
    }

    public void returnExclusiveSegments(List<MemorySegment> segments) throws IOException {
        this.networkBufferPool.recycleMemorySegments(segments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputChannel(IntermediateResultPartitionID partitionId, InputChannel inputChannel) {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.inputChannels.put((IntermediateResultPartitionID)((Object)Preconditions.checkNotNull((Object)((Object)partitionId))), (InputChannel)Preconditions.checkNotNull((Object)inputChannel)) == null && inputChannel instanceof UnknownInputChannel) {
                ++this.numberOfUninitializedChannels;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInputChannel(InputChannelDeploymentDescriptor icdd) throws IOException, InterruptedException {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.isReleased) {
                return;
            }
            IntermediateResultPartitionID partitionId = icdd.getConsumedPartitionId().getPartitionId();
            InputChannel current = this.inputChannels.get((Object)partitionId);
            if (current instanceof UnknownInputChannel) {
                InputChannel newChannel;
                UnknownInputChannel unknownChannel = (UnknownInputChannel)current;
                ResultPartitionLocation partitionLocation = icdd.getConsumedPartitionLocation();
                if (partitionLocation.isLocal()) {
                    newChannel = unknownChannel.toLocalInputChannel();
                } else if (partitionLocation.isRemote()) {
                    newChannel = unknownChannel.toRemoteInputChannel(partitionLocation.getConnectionId());
                    if (this.getConsumedPartitionType().isCreditBased()) {
                        ((RemoteInputChannel)newChannel).assignExclusiveSegments(this.networkBufferPool.requestMemorySegments(this.networkBuffersPerChannel));
                    }
                } else {
                    throw new IllegalStateException("Tried to update unknown channel with unknown channel.");
                }
                LOG.debug("Updated unknown input channel to {}.", (Object)newChannel);
                this.inputChannels.put(partitionId, newChannel);
                if (this.requestedPartitionsFlag) {
                    newChannel.requestSubpartition(this.consumedSubpartitionIndex);
                }
                for (TaskEvent event : this.pendingEvents) {
                    newChannel.sendTaskEvent(event);
                }
                if (--this.numberOfUninitializedChannels == 0) {
                    this.pendingEvents.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retriggerPartitionRequest(IntermediateResultPartitionID partitionId) throws IOException, InterruptedException {
        Object object = this.requestLock;
        synchronized (object) {
            if (!this.isReleased) {
                InputChannel ch = this.inputChannels.get((Object)partitionId);
                Preconditions.checkNotNull((Object)ch, (String)("Unknown input channel with ID " + (Object)((Object)partitionId)));
                LOG.debug("Retriggering partition request {}:{}.", (Object)ch.partitionId, (Object)this.consumedSubpartitionIndex);
                if (ch.getClass() == RemoteInputChannel.class) {
                    RemoteInputChannel rch = (RemoteInputChannel)ch;
                    rch.retriggerSubpartitionRequest(this.consumedSubpartitionIndex);
                } else if (ch.getClass() == LocalInputChannel.class) {
                    LocalInputChannel ich = (LocalInputChannel)ch;
                    if (this.retriggerLocalRequestTimer == null) {
                        this.retriggerLocalRequestTimer = new Timer(true);
                    }
                    ich.retriggerSubpartitionRequest(this.retriggerLocalRequestTimer, this.consumedSubpartitionIndex);
                } else {
                    throw new IllegalStateException("Unexpected type of channel to retrigger partition: " + ch.getClass());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllResources() throws IOException {
        boolean released = false;
        ArrayDeque<InputChannel> arrayDeque = this.requestLock;
        synchronized (arrayDeque) {
            if (!this.isReleased) {
                try {
                    LOG.debug("{}: Releasing {}.", (Object)this.owningTaskName, (Object)this);
                    if (this.retriggerLocalRequestTimer != null) {
                        this.retriggerLocalRequestTimer.cancel();
                    }
                    for (InputChannel inputChannel : this.inputChannels.values()) {
                        try {
                            inputChannel.releaseAllResources();
                        }
                        catch (IOException e) {
                            LOG.warn("Error during release of channel resources: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (this.bufferPool != null) {
                        this.bufferPool.lazyDestroy();
                    }
                }
                finally {
                    this.isReleased = true;
                    released = true;
                }
            }
        }
        if (released) {
            arrayDeque = this.inputChannelsWithData;
            synchronized (arrayDeque) {
                this.inputChannelsWithData.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFinished() {
        Object object = this.requestLock;
        synchronized (object) {
            for (InputChannel inputChannel : this.inputChannels.values()) {
                if (inputChannel.isReleased()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestPartitions() throws IOException, InterruptedException {
        Object object = this.requestLock;
        synchronized (object) {
            if (!this.requestedPartitionsFlag) {
                if (this.isReleased) {
                    throw new IllegalStateException("Already released.");
                }
                if (this.numberOfInputChannels != this.inputChannels.size()) {
                    throw new IllegalStateException("Bug in input gate setup logic: mismatch betweennumber of total input channels and the currently set number of input channels.");
                }
                for (InputChannel inputChannel : this.inputChannels.values()) {
                    inputChannel.requestSubpartition(this.consumedSubpartitionIndex);
                }
            }
            this.requestedPartitionsFlag = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferOrEvent getNextBufferOrEvent() throws IOException, InterruptedException {
        Buffer buffer;
        boolean moreAvailable;
        InputChannel currentChannel;
        if (this.hasReceivedAllEndOfPartitionEvents) {
            return null;
        }
        if (this.isReleased) {
            throw new IllegalStateException("Released");
        }
        this.requestPartitions();
        ArrayDeque<InputChannel> arrayDeque = this.inputChannelsWithData;
        synchronized (arrayDeque) {
            while (this.inputChannelsWithData.size() == 0) {
                if (this.isReleased) {
                    throw new IllegalStateException("Released");
                }
                this.inputChannelsWithData.wait();
            }
            currentChannel = this.inputChannelsWithData.remove();
            moreAvailable = this.inputChannelsWithData.size() > 0;
        }
        InputChannel.BufferAndAvailability result = currentChannel.getNextBuffer();
        if (result == null) {
            throw new IllegalStateException("Bug in input gate/channel logic: input gate got notified by channel about available data, but none was available.");
        }
        if (result.moreAvailable()) {
            this.queueChannel(currentChannel);
        }
        if ((buffer = result.buffer()).isBuffer()) {
            return new BufferOrEvent(buffer, currentChannel.getChannelIndex(), moreAvailable);
        }
        AbstractEvent event = EventSerializer.fromBuffer(buffer, this.getClass().getClassLoader());
        if (event.getClass() == EndOfPartitionEvent.class) {
            this.channelsWithEndOfPartitionEvents.set(currentChannel.getChannelIndex());
            if (this.channelsWithEndOfPartitionEvents.cardinality() == this.numberOfInputChannels) {
                this.hasReceivedAllEndOfPartitionEvents = true;
            }
            currentChannel.notifySubpartitionConsumed();
            currentChannel.releaseAllResources();
        }
        return new BufferOrEvent(event, currentChannel.getChannelIndex(), moreAvailable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendTaskEvent(TaskEvent event) throws IOException {
        Object object = this.requestLock;
        synchronized (object) {
            for (InputChannel inputChannel : this.inputChannels.values()) {
                inputChannel.sendTaskEvent(event);
            }
            if (this.numberOfUninitializedChannels > 0) {
                this.pendingEvents.add(event);
            }
        }
    }

    @Override
    public void registerListener(InputGateListener inputGateListener) {
        if (this.inputGateListener != null) {
            throw new IllegalStateException("Multiple listeners");
        }
        this.inputGateListener = inputGateListener;
    }

    void notifyChannelNonEmpty(InputChannel channel) {
        this.queueChannel((InputChannel)Preconditions.checkNotNull((Object)channel));
    }

    void triggerPartitionStateCheck(ResultPartitionID partitionId) {
        this.taskActions.triggerPartitionProducerStateCheck(this.jobId, this.consumedResultId, partitionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueChannel(InputChannel channel) {
        InputGateListener listener;
        int availableChannels;
        ArrayDeque<InputChannel> arrayDeque = this.inputChannelsWithData;
        synchronized (arrayDeque) {
            availableChannels = this.inputChannelsWithData.size();
            this.inputChannelsWithData.add(channel);
            if (availableChannels == 0) {
                this.inputChannelsWithData.notifyAll();
            }
        }
        if (availableChannels == 0 && (listener = this.inputGateListener) != null) {
            listener.notifyInputGateNonEmpty(this);
        }
    }

    Map<IntermediateResultPartitionID, InputChannel> getInputChannels() {
        return this.inputChannels;
    }

    public static SingleInputGate create(String owningTaskName, JobID jobId, ExecutionAttemptID executionId, InputGateDeploymentDescriptor igdd, NetworkEnvironment networkEnvironment, TaskActions taskActions, TaskIOMetricGroup metrics) {
        IntermediateDataSetID consumedResultId = (IntermediateDataSetID)((Object)Preconditions.checkNotNull((Object)((Object)igdd.getConsumedResultId())));
        ResultPartitionType consumedPartitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)igdd.getConsumedPartitionType())));
        int consumedSubpartitionIndex = igdd.getConsumedSubpartitionIndex();
        Preconditions.checkArgument((consumedSubpartitionIndex >= 0 ? 1 : 0) != 0);
        InputChannelDeploymentDescriptor[] icdd = (InputChannelDeploymentDescriptor[])Preconditions.checkNotNull((Object)igdd.getInputChannelDeploymentDescriptors());
        SingleInputGate inputGate = new SingleInputGate(owningTaskName, jobId, consumedResultId, consumedPartitionType, consumedSubpartitionIndex, icdd.length, taskActions, metrics);
        InputChannel[] inputChannels = new InputChannel[icdd.length];
        int numLocalChannels = 0;
        int numRemoteChannels = 0;
        int numUnknownChannels = 0;
        for (int i = 0; i < inputChannels.length; ++i) {
            ResultPartitionID partitionId = icdd[i].getConsumedPartitionId();
            ResultPartitionLocation partitionLocation = icdd[i].getConsumedPartitionLocation();
            if (partitionLocation.isLocal()) {
                inputChannels[i] = new LocalInputChannel(inputGate, i, partitionId, networkEnvironment.getResultPartitionManager(), networkEnvironment.getTaskEventDispatcher(), networkEnvironment.getPartitionRequestInitialBackoff(), networkEnvironment.getPartitionRequestMaxBackoff(), metrics);
                ++numLocalChannels;
            } else if (partitionLocation.isRemote()) {
                inputChannels[i] = new RemoteInputChannel(inputGate, i, partitionId, partitionLocation.getConnectionId(), networkEnvironment.getConnectionManager(), networkEnvironment.getPartitionRequestInitialBackoff(), networkEnvironment.getPartitionRequestMaxBackoff(), metrics);
                ++numRemoteChannels;
            } else if (partitionLocation.isUnknown()) {
                inputChannels[i] = new UnknownInputChannel(inputGate, i, partitionId, networkEnvironment.getResultPartitionManager(), networkEnvironment.getTaskEventDispatcher(), networkEnvironment.getConnectionManager(), networkEnvironment.getPartitionRequestInitialBackoff(), networkEnvironment.getPartitionRequestMaxBackoff(), metrics);
                ++numUnknownChannels;
            } else {
                throw new IllegalStateException("Unexpected partition location.");
            }
            inputGate.setInputChannel(partitionId.getPartitionId(), inputChannels[i]);
        }
        LOG.debug("Created {} input channels (local: {}, remote: {}, unknown: {}).", new Object[]{inputChannels.length, numLocalChannels, numRemoteChannels, numUnknownChannels});
        return inputGate;
    }
}

