/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobClient;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public class JobGraph
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<JobVertexID, JobVertex> taskVertices = new LinkedHashMap<JobVertexID, JobVertex>();
    private final Configuration jobConfiguration = new Configuration();
    private final JobID jobID;
    private final String jobName;
    private long sessionTimeout = 0L;
    private boolean allowQueuedScheduling;
    private ScheduleMode scheduleMode = ScheduleMode.LAZY_FROM_SOURCES;
    private SerializedValue<ExecutionConfig> serializedExecutionConfig;
    private JobCheckpointingSettings snapshotSettings;
    private SavepointRestoreSettings savepointRestoreSettings = SavepointRestoreSettings.none();
    private final List<Path> userJars = new ArrayList<Path>();
    private final List<PermanentBlobKey> userJarBlobKeys = new ArrayList<PermanentBlobKey>();
    private List<URL> classpaths = Collections.emptyList();

    public JobGraph(String jobName) {
        this(null, jobName);
    }

    public JobGraph(JobID jobId, String jobName) {
        this.jobID = jobId == null ? new JobID() : jobId;
        this.jobName = jobName == null ? "(unnamed job)" : jobName;
        try {
            this.setExecutionConfig(new ExecutionConfig());
        }
        catch (IOException e) {
            throw new RuntimeException("bug, empty execution config is not serializable");
        }
    }

    public JobGraph(JobVertex ... vertices) {
        this((String)null, vertices);
    }

    public JobGraph(String jobName, JobVertex ... vertices) {
        this(null, jobName, vertices);
    }

    public JobGraph(JobID jobId, String jobName, JobVertex ... vertices) {
        this(jobId, jobName);
        for (JobVertex vertex : vertices) {
            this.addVertex(vertex);
        }
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public String getName() {
        return this.jobName;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public SerializedValue<ExecutionConfig> getSerializedExecutionConfig() {
        return this.serializedExecutionConfig;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setAllowQueuedScheduling(boolean allowQueuedScheduling) {
        this.allowQueuedScheduling = allowQueuedScheduling;
    }

    public boolean getAllowQueuedScheduling() {
        return this.allowQueuedScheduling;
    }

    public void setScheduleMode(ScheduleMode scheduleMode) {
        this.scheduleMode = scheduleMode;
    }

    public ScheduleMode getScheduleMode() {
        return this.scheduleMode;
    }

    public void setSavepointRestoreSettings(SavepointRestoreSettings settings) {
        this.savepointRestoreSettings = (SavepointRestoreSettings)Preconditions.checkNotNull((Object)settings, (String)"Savepoint restore settings");
    }

    public SavepointRestoreSettings getSavepointRestoreSettings() {
        return this.savepointRestoreSettings;
    }

    public void setExecutionConfig(ExecutionConfig executionConfig) throws IOException {
        Preconditions.checkNotNull((Object)executionConfig, (String)"ExecutionConfig must not be null.");
        this.serializedExecutionConfig = new SerializedValue((Object)executionConfig);
    }

    public void addVertex(JobVertex vertex) {
        JobVertexID id = vertex.getID();
        JobVertex previous = this.taskVertices.put(id, vertex);
        if (previous != null) {
            this.taskVertices.put(id, previous);
            throw new IllegalArgumentException("The JobGraph already contains a vertex with that id.");
        }
    }

    public Iterable<JobVertex> getVertices() {
        return this.taskVertices.values();
    }

    public JobVertex[] getVerticesAsArray() {
        return this.taskVertices.values().toArray(new JobVertex[this.taskVertices.size()]);
    }

    public int getNumberOfVertices() {
        return this.taskVertices.size();
    }

    public void setSnapshotSettings(JobCheckpointingSettings settings) {
        this.snapshotSettings = settings;
    }

    public JobCheckpointingSettings getCheckpointingSettings() {
        return this.snapshotSettings;
    }

    public JobVertex findVertexByID(JobVertexID id) {
        return this.taskVertices.get((Object)id);
    }

    public void setClasspaths(List<URL> paths) {
        this.classpaths = paths;
    }

    public List<URL> getClasspaths() {
        return this.classpaths;
    }

    public int getMaximumParallelism() {
        int maxParallelism = -1;
        for (JobVertex vertex : this.taskVertices.values()) {
            maxParallelism = Math.max(vertex.getParallelism(), maxParallelism);
        }
        return maxParallelism;
    }

    public List<JobVertex> getVerticesSortedTopologicallyFromSources() throws InvalidProgramException {
        if (this.taskVertices.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JobVertex> sorted = new ArrayList<JobVertex>(this.taskVertices.size());
        LinkedHashSet<JobVertex> remaining = new LinkedHashSet<JobVertex>(this.taskVertices.values());
        Iterator iter = remaining.iterator();
        while (iter.hasNext()) {
            JobVertex vertex = (JobVertex)iter.next();
            if (!vertex.hasNoConnectedInputs()) continue;
            sorted.add(vertex);
            iter.remove();
        }
        int startNodePos = 0;
        while (!remaining.isEmpty()) {
            if (startNodePos >= sorted.size()) {
                throw new InvalidProgramException("The job graph is cyclic.");
            }
            JobVertex current = (JobVertex)sorted.get(startNodePos++);
            this.addNodesThatHaveNoNewPredecessors(current, sorted, remaining);
        }
        return sorted;
    }

    private void addNodesThatHaveNoNewPredecessors(JobVertex start2, List<JobVertex> target, Set<JobVertex> remaining) {
        for (IntermediateDataSet dataSet : start2.getProducedDataSets()) {
            for (JobEdge edge : dataSet.getConsumers()) {
                JobVertex v = edge.getTarget();
                if (!remaining.contains(v)) continue;
                boolean hasNewPredecessors = false;
                for (JobEdge e : v.getInputs()) {
                    IntermediateDataSet source;
                    if (e == edge || !remaining.contains((source = e.getSource()).getProducer())) continue;
                    hasNewPredecessors = true;
                    break;
                }
                if (hasNewPredecessors) continue;
                target.add(v);
                remaining.remove(v);
                this.addNodesThatHaveNoNewPredecessors(v, target, remaining);
            }
        }
    }

    public void addJar(Path jar) {
        if (jar == null) {
            throw new IllegalArgumentException();
        }
        if (!this.userJars.contains(jar)) {
            this.userJars.add(jar);
        }
    }

    public List<Path> getUserJars() {
        return this.userJars;
    }

    public void addBlob(PermanentBlobKey key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (!this.userJarBlobKeys.contains(key)) {
            this.userJarBlobKeys.add(key);
        }
    }

    public boolean hasUsercodeJarFiles() {
        return this.userJars.size() > 0;
    }

    public List<PermanentBlobKey> getUserJarBlobKeys() {
        return this.userJarBlobKeys;
    }

    public void uploadUserJars(InetSocketAddress blobServerAddress, Configuration blobClientConfig) throws IOException {
        if (!this.userJars.isEmpty()) {
            List<PermanentBlobKey> blobKeys = BlobClient.uploadJarFiles(blobServerAddress, blobClientConfig, this.jobID, this.userJars);
            for (PermanentBlobKey blobKey : blobKeys) {
                if (this.userJarBlobKeys.contains(blobKey)) continue;
                this.userJarBlobKeys.add(blobKey);
            }
        }
    }

    public String toString() {
        return "JobGraph(jobId: " + this.jobID + ")";
    }
}

