/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;

public class NoResourceAvailableException
extends JobException {
    private static final long serialVersionUID = -2249953165298717803L;
    private static final String BASE_MESSAGE = "Not enough free slots available to run the job. You can decrease the operator parallelism or increase the number of slots per TaskManager in the configuration.";

    public NoResourceAvailableException() {
        super(BASE_MESSAGE);
    }

    public NoResourceAvailableException(ScheduledUnit unit) {
        super("No resource available to schedule unit " + unit + ". You can decrease the operator parallelism or increase the number of slots per TaskManager in the configuration.");
    }

    public NoResourceAvailableException(int numInstances, int numSlotsTotal, int availableSlots) {
        super(String.format("%s Resources available to scheduler: Number of instances=%d, total number of slots=%d, available slots=%d", BASE_MESSAGE, numInstances, numSlotsTotal, availableSlots));
    }

    NoResourceAvailableException(ScheduledUnit task, int numInstances, int numSlotsTotal, int availableSlots) {
        super(String.format("%s Task to schedule: < %s > with groupID < %s > in sharing group < %s >. Resources available to scheduler: Number of instances=%d, total number of slots=%d, available slots=%d", new Object[]{BASE_MESSAGE, task.getTaskToExecute(), task.getLocationConstraint() == null ? task.getTaskToExecute().getVertex().getJobvertexId() : task.getLocationConstraint().getGroupId(), task.getSlotSharingGroup(), numInstances, numSlotsTotal, availableSlots}));
    }

    public NoResourceAvailableException(String message) {
        super(message);
    }

    public NoResourceAvailableException(String message, Throwable cause) {
        super(message, cause);
    }

    public boolean equals(Object obj) {
        return obj instanceof NoResourceAvailableException && this.getMessage().equals(((NoResourceAvailableException)((Object)obj)).getMessage());
    }

    public int hashCode() {
        return this.getMessage().hashCode();
    }
}

