/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.net.SSLUtils;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;

public final class RestServerEndpointConfiguration {
    @Nullable
    private final String restBindAddress;
    private final int restBindPort;
    @Nullable
    private final SSLEngine sslEngine;

    private RestServerEndpointConfiguration(@Nullable String restBindAddress, int restBindPort, @Nullable SSLEngine sslEngine) {
        this.restBindAddress = restBindAddress;
        Preconditions.checkArgument((0 <= restBindPort && restBindPort < 65536 ? 1 : 0) != 0, (Object)("The bing rest port " + restBindPort + " is out of range (0, 65536["));
        this.restBindPort = restBindPort;
        this.sslEngine = sslEngine;
    }

    public String getEndpointBindAddress() {
        return this.restBindAddress;
    }

    public int getEndpointBindPort() {
        return this.restBindPort;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public static RestServerEndpointConfiguration fromConfiguration(Configuration config) throws ConfigurationException {
        Preconditions.checkNotNull((Object)config);
        String address = config.getString(RestOptions.REST_ADDRESS);
        int port = config.getInteger(RestOptions.REST_PORT);
        SSLEngine sslEngine = null;
        boolean enableSSL = config.getBoolean(SecurityOptions.SSL_ENABLED);
        if (enableSSL) {
            try {
                SSLContext sslContext = SSLUtils.createSSLServerContext(config);
                if (sslContext != null) {
                    sslEngine = sslContext.createSSLEngine();
                    SSLUtils.setSSLVerAndCipherSuites(sslEngine, config);
                    sslEngine.setUseClientMode(false);
                }
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to initialize SSLContext for REST server endpoint.", (Throwable)e);
            }
        }
        return new RestServerEndpointConfiguration(address, port, sslEngine);
    }
}

