/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.RedirectHandler;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParseException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufInputStream;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router.Routed;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class AbstractRestHandler<T extends RestfulGateway, R extends RequestBody, P extends ResponseBody, M extends MessageParameters>
extends RedirectHandler<T> {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final ObjectMapper mapper = RestMapperUtils.getStrictObjectMapper();
    private final MessageHeaders<R, P, M> messageHeaders;

    protected AbstractRestHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends T> leaderRetriever, Time timeout, MessageHeaders<R, P, M> messageHeaders) {
        super(localRestAddress, leaderRetriever, timeout);
        this.messageHeaders = messageHeaders;
    }

    public MessageHeaders<R, P, M> getMessageHeaders() {
        return this.messageHeaders;
    }

    @Override
    protected void respondAsLeader(ChannelHandlerContext ctx, Routed routed, T gateway) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received request " + routed.request().getUri() + '.');
        }
        HttpRequest httpRequest = routed.request();
        try {
            CompletableFuture<Object> response;
            HandlerRequest<RequestBody, M> handlerRequest;
            RequestBody request;
            if (!(httpRequest instanceof FullHttpRequest)) {
                this.log.error("Implementation error: Received a request that wasn't a FullHttpRequest.");
                HandlerUtils.sendErrorResponse(ctx, httpRequest, new ErrorResponseBody("Bad request received."), HttpResponseStatus.BAD_REQUEST);
                return;
            }
            ByteBuf msgContent = ((FullHttpRequest)httpRequest).content();
            if (msgContent.capacity() == 0) {
                try {
                    request = (RequestBody)mapper.readValue("{}", this.messageHeaders.getRequestClass());
                }
                catch (JsonParseException | JsonMappingException je) {
                    this.log.error("Request did not conform to expected format.", je);
                    HandlerUtils.sendErrorResponse(ctx, httpRequest, new ErrorResponseBody("Bad request received."), HttpResponseStatus.BAD_REQUEST);
                    return;
                }
            }
            try {
                ByteBufInputStream in = new ByteBufInputStream(msgContent);
                request = (RequestBody)mapper.readValue((InputStream)in, this.messageHeaders.getRequestClass());
            }
            catch (JsonParseException | JsonMappingException je) {
                this.log.error("Failed to read request.", je);
                HandlerUtils.sendErrorResponse(ctx, httpRequest, new ErrorResponseBody(String.format("Request did not match expected format %s.", this.messageHeaders.getRequestClass().getSimpleName())), HttpResponseStatus.BAD_REQUEST);
                return;
            }
            try {
                handlerRequest = new HandlerRequest<RequestBody, M>(request, this.messageHeaders.getUnresolvedMessageParameters(), routed.pathParams(), routed.queryParams());
            }
            catch (HandlerRequestException hre) {
                this.log.error("Could not create the handler request.", (Throwable)((Object)hre));
                HandlerUtils.sendErrorResponse(ctx, httpRequest, new ErrorResponseBody(String.format("Bad request, could not parse parameters: %s", hre.getMessage())), HttpResponseStatus.BAD_REQUEST);
                return;
            }
            try {
                response = this.handleRequest(handlerRequest, gateway);
            }
            catch (RestHandlerException e) {
                response = FutureUtils.completedExceptionally((Throwable)((Object)e));
            }
            response.whenComplete((resp, throwable) -> {
                if (throwable != null) {
                    Throwable error = ExceptionUtils.stripCompletionException((Throwable)throwable);
                    if (error instanceof RestHandlerException) {
                        RestHandlerException rhe = (RestHandlerException)((Object)((Object)error));
                        this.log.error("Exception occurred in REST handler.", error);
                        HandlerUtils.sendErrorResponse(ctx, httpRequest, new ErrorResponseBody(rhe.getMessage()), rhe.getHttpResponseStatus());
                    } else {
                        this.log.error("Implementation error: Unhandled exception.", error);
                        HandlerUtils.sendErrorResponse(ctx, httpRequest, new ErrorResponseBody("Internal server error."), HttpResponseStatus.INTERNAL_SERVER_ERROR);
                    }
                } else {
                    HandlerUtils.sendResponse(ctx, httpRequest, resp, this.messageHeaders.getResponseStatusCode());
                }
            });
        }
        catch (Throwable e) {
            this.log.error("Request processing failed.", e);
            HandlerUtils.sendErrorResponse(ctx, httpRequest, new ErrorResponseBody("Internal server error."), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    protected abstract CompletableFuture<P> handleRequest(@Nonnull HandlerRequest<R, M> var1, @Nonnull T var2) throws RestHandlerException;
}

