/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.checkpoints;

import java.util.Objects;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class CheckpointConfigInfo
implements ResponseBody {
    public static final String FIELD_NAME_PROCESSING_MODE = "mode";
    public static final String FIELD_NAME_CHECKPOINT_INTERVAL = "interval";
    public static final String FIELD_NAME_CHECKPOINT_TIMEOUT = "timeout";
    public static final String FIELD_NAME_CHECKPOINT_MIN_PAUSE = "min_pause";
    public static final String FIELD_NAME_CHECKPOINT_MAX_CONCURRENT = "max_concurrent";
    public static final String FIELD_NAME_EXTERNALIZED_CHECKPOINT_CONFIG = "externalization";
    @JsonProperty(value="mode")
    private final ProcessingMode processingMode;
    @JsonProperty(value="interval")
    private final long checkpointInterval;
    @JsonProperty(value="timeout")
    private final long checkpointTimeout;
    @JsonProperty(value="min_pause")
    private final long minPauseBetweenCheckpoints;
    @JsonProperty(value="max_concurrent")
    private final long maxConcurrentCheckpoints;
    @JsonProperty(value="externalization")
    private final ExternalizedCheckpointInfo externalizedCheckpointInfo;

    @JsonCreator
    public CheckpointConfigInfo(@JsonProperty(value="mode") ProcessingMode processingMode, @JsonProperty(value="interval") long checkpointInterval, @JsonProperty(value="timeout") long checkpointTimeout, @JsonProperty(value="min_pause") long minPauseBetweenCheckpoints, @JsonProperty(value="max_concurrent") int maxConcurrentCheckpoints, @JsonProperty(value="externalization") ExternalizedCheckpointInfo externalizedCheckpointInfo) {
        this.processingMode = (ProcessingMode)((Object)Preconditions.checkNotNull((Object)((Object)processingMode)));
        this.checkpointInterval = checkpointInterval;
        this.checkpointTimeout = checkpointTimeout;
        this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
        this.maxConcurrentCheckpoints = maxConcurrentCheckpoints;
        this.externalizedCheckpointInfo = (ExternalizedCheckpointInfo)Preconditions.checkNotNull((Object)externalizedCheckpointInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointConfigInfo that = (CheckpointConfigInfo)o;
        return this.checkpointInterval == that.checkpointInterval && this.checkpointTimeout == that.checkpointTimeout && this.minPauseBetweenCheckpoints == that.minPauseBetweenCheckpoints && this.maxConcurrentCheckpoints == that.maxConcurrentCheckpoints && this.processingMode == that.processingMode && Objects.equals(this.externalizedCheckpointInfo, that.externalizedCheckpointInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.processingMode, this.checkpointInterval, this.checkpointTimeout, this.minPauseBetweenCheckpoints, this.maxConcurrentCheckpoints, this.externalizedCheckpointInfo});
    }

    public static enum ProcessingMode {
        AT_LEAST_ONCE,
        EXACTLY_ONCE;

    }

    public static final class ExternalizedCheckpointInfo {
        public static final String FIELD_NAME_ENABLED = "enabled";
        public static final String FIELD_NAME_DELETE_ON_CANCELLATION = "delete_on_cancellation";
        @JsonProperty(value="enabled")
        private final boolean enabled;
        @JsonProperty(value="delete_on_cancellation")
        private final boolean deleteOnCancellation;

        @JsonCreator
        public ExternalizedCheckpointInfo(@JsonProperty(value="enabled") boolean enabled, @JsonProperty(value="delete_on_cancellation") boolean deleteOnCancellation) {
            this.enabled = enabled;
            this.deleteOnCancellation = deleteOnCancellation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExternalizedCheckpointInfo that = (ExternalizedCheckpointInfo)o;
            return this.enabled == that.enabled && this.deleteOnCancellation == that.deleteOnCancellation;
        }

        public int hashCode() {
            return Objects.hash(this.enabled, this.deleteOnCancellation);
        }
    }
}

