/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rpc.FencedMainThreadExecutable;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcServer;
import org.apache.flink.runtime.rpc.RpcService;

public class FencedRpcEndpoint<F extends Serializable>
extends RpcEndpoint {
    private volatile F fencingToken = null;
    private volatile RpcEndpoint.MainThreadExecutor fencedMainThreadExecutor = new RpcEndpoint.MainThreadExecutor(this.getRpcService().fenceRpcServer(this.rpcServer, null));

    protected FencedRpcEndpoint(RpcService rpcService, String endpointId) {
        super(rpcService, endpointId);
    }

    protected FencedRpcEndpoint(RpcService rpcService) {
        this(rpcService, UUID.randomUUID().toString());
    }

    public F getFencingToken() {
        return this.fencingToken;
    }

    protected void setFencingToken(@Nullable F newFencingToken) {
        this.validateRunsInMainThread();
        this.fencingToken = newFencingToken;
        RpcServer mainThreadExecutable = this.getRpcService().fenceRpcServer(this.rpcServer, newFencingToken);
        this.fencedMainThreadExecutor = new RpcEndpoint.MainThreadExecutor(mainThreadExecutable);
    }

    @Override
    protected RpcEndpoint.MainThreadExecutor getMainThreadExecutor() {
        return this.fencedMainThreadExecutor;
    }

    protected void runAsyncWithoutFencing(Runnable runnable) {
        if (!(this.rpcServer instanceof FencedMainThreadExecutable)) {
            throw new RuntimeException("FencedRpcEndpoint has not been started with a FencedMainThreadExecutable RpcServer.");
        }
        ((FencedMainThreadExecutable)((Object)this.rpcServer)).runAsyncWithoutFencing(runnable);
    }

    protected <V> CompletableFuture<V> callAsyncWithoutFencing(Callable<V> callable, Time timeout) {
        if (this.rpcServer instanceof FencedMainThreadExecutable) {
            return ((FencedMainThreadExecutable)((Object)this.rpcServer)).callAsyncWithoutFencing(callable, timeout);
        }
        throw new RuntimeException("FencedRpcEndpoint has not been started with a FencedMainThreadExecutable RpcServer.");
    }
}

