/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.DefaultOperatorStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStreamFactory;
import org.apache.flink.runtime.state.filesystem.FsSavepointStreamFactory;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackend;
import org.apache.flink.util.Preconditions;

public class FsStateBackend
extends AbstractStateBackend {
    private static final long serialVersionUID = -8191916350224044011L;
    public static final int DEFAULT_FILE_STATE_THRESHOLD = 1024;
    private static final int MAX_FILE_STATE_THRESHOLD = 0x100000;
    private final Path basePath;
    private final int fileStateThreshold;
    private final boolean asynchronousSnapshots;

    public FsStateBackend(String checkpointDataUri) throws IOException {
        this(new Path(checkpointDataUri));
    }

    public FsStateBackend(String checkpointDataUri, boolean asynchronousSnapshots) throws IOException {
        this(new Path(checkpointDataUri), asynchronousSnapshots);
    }

    public FsStateBackend(Path checkpointDataUri) throws IOException {
        this(checkpointDataUri.toUri());
    }

    public FsStateBackend(Path checkpointDataUri, boolean asynchronousSnapshots) throws IOException {
        this(checkpointDataUri.toUri(), asynchronousSnapshots);
    }

    public FsStateBackend(URI checkpointDataUri) throws IOException {
        this(checkpointDataUri, 1024, true);
    }

    public FsStateBackend(URI checkpointDataUri, boolean asynchronousSnapshots) throws IOException {
        this(checkpointDataUri, 1024, asynchronousSnapshots);
    }

    public FsStateBackend(URI checkpointDataUri, int fileStateSizeThreshold) throws IOException {
        this(checkpointDataUri, fileStateSizeThreshold, true);
    }

    public FsStateBackend(URI checkpointDataUri, int fileStateSizeThreshold, boolean asynchronousSnapshots) throws IOException {
        Preconditions.checkArgument((fileStateSizeThreshold >= 0 ? 1 : 0) != 0, (Object)"The threshold for file state size must be zero or larger.");
        Preconditions.checkArgument((fileStateSizeThreshold <= 0x100000 ? 1 : 0) != 0, (String)"The threshold for file state size cannot be larger than %s", (Object[])new Object[]{0x100000});
        this.fileStateThreshold = fileStateSizeThreshold;
        this.basePath = FsStateBackend.validateAndNormalizeUri(checkpointDataUri);
        this.asynchronousSnapshots = asynchronousSnapshots;
    }

    public Path getBasePath() {
        return this.basePath;
    }

    public int getMinFileSizeThreshold() {
        return this.fileStateThreshold;
    }

    @Override
    public CheckpointStreamFactory createStreamFactory(JobID jobId, String operatorIdentifier) throws IOException {
        return new FsCheckpointStreamFactory(this.basePath, jobId, this.fileStateThreshold);
    }

    @Override
    public CheckpointStreamFactory createSavepointStreamFactory(JobID jobId, String operatorIdentifier, String targetLocation) throws IOException {
        return new FsSavepointStreamFactory(new Path(targetLocation), jobId, this.fileStateThreshold);
    }

    @Override
    public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(Environment env, JobID jobID, String operatorIdentifier, TypeSerializer<K> keySerializer, int numberOfKeyGroups, KeyGroupRange keyGroupRange, TaskKvStateRegistry kvStateRegistry) throws IOException {
        return new HeapKeyedStateBackend<K>(kvStateRegistry, keySerializer, env.getUserClassLoader(), numberOfKeyGroups, keyGroupRange, this.asynchronousSnapshots, env.getExecutionConfig());
    }

    @Override
    public OperatorStateBackend createOperatorStateBackend(Environment env, String operatorIdentifier) throws Exception {
        return new DefaultOperatorStateBackend(env.getUserClassLoader(), env.getExecutionConfig(), this.asynchronousSnapshots);
    }

    public String toString() {
        return "File State Backend @ " + this.basePath;
    }

    private static Path validateAndNormalizeUri(URI checkpointDataUri) throws IOException {
        String scheme = checkpointDataUri.getScheme();
        String path = checkpointDataUri.getPath();
        if (scheme == null) {
            throw new IllegalArgumentException("The scheme (hdfs://, file://, etc) is null. Please specify the file system scheme explicitly in the URI.");
        }
        if (path == null) {
            throw new IllegalArgumentException("The path to store the checkpoint data in is null. Please specify a directory path for the checkpoint data.");
        }
        if (path.length() == 0 || path.equals("/")) {
            throw new IllegalArgumentException("Cannot use the root directory for checkpoints.");
        }
        return new Path(checkpointDataUri);
    }
}

