/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.queryablestate.network.stats.DisabledKvStateRequestStats;
import org.apache.flink.queryablestate.network.stats.KvStateRequestStats;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.filecache.FileCache;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.LocalConnectionManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.netty.NettyConnectionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.query.KvStateClientProxy;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.query.KvStateServer;
import org.apache.flink.runtime.query.QueryableStateUtils;
import org.apache.flink.runtime.taskexecutor.JobLeaderService;
import org.apache.flink.runtime.taskexecutor.JobManagerTable;
import org.apache.flink.runtime.taskexecutor.QueryableStateConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskexecutor.slot.TimerService;
import org.apache.flink.runtime.taskmanager.NetworkEnvironmentConfiguration;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerServices {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerServices.class);
    private final TaskManagerLocation taskManagerLocation;
    private final MemoryManager memoryManager;
    private final IOManager ioManager;
    private final NetworkEnvironment networkEnvironment;
    private final BroadcastVariableManager broadcastVariableManager;
    private final FileCache fileCache;
    private final TaskSlotTable taskSlotTable;
    private final JobManagerTable jobManagerTable;
    private final JobLeaderService jobLeaderService;

    private TaskManagerServices(TaskManagerLocation taskManagerLocation, MemoryManager memoryManager, IOManager ioManager, NetworkEnvironment networkEnvironment, BroadcastVariableManager broadcastVariableManager, FileCache fileCache, TaskSlotTable taskSlotTable, JobManagerTable jobManagerTable, JobLeaderService jobLeaderService) {
        this.taskManagerLocation = (TaskManagerLocation)Preconditions.checkNotNull((Object)taskManagerLocation);
        this.memoryManager = (MemoryManager)Preconditions.checkNotNull((Object)memoryManager);
        this.ioManager = (IOManager)Preconditions.checkNotNull((Object)ioManager);
        this.networkEnvironment = (NetworkEnvironment)Preconditions.checkNotNull((Object)networkEnvironment);
        this.broadcastVariableManager = (BroadcastVariableManager)Preconditions.checkNotNull((Object)broadcastVariableManager);
        this.fileCache = (FileCache)Preconditions.checkNotNull((Object)fileCache);
        this.taskSlotTable = (TaskSlotTable)Preconditions.checkNotNull((Object)taskSlotTable);
        this.jobManagerTable = (JobManagerTable)Preconditions.checkNotNull((Object)jobManagerTable);
        this.jobLeaderService = (JobLeaderService)Preconditions.checkNotNull((Object)jobLeaderService);
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    public NetworkEnvironment getNetworkEnvironment() {
        return this.networkEnvironment;
    }

    public TaskManagerLocation getTaskManagerLocation() {
        return this.taskManagerLocation;
    }

    public BroadcastVariableManager getBroadcastVariableManager() {
        return this.broadcastVariableManager;
    }

    public FileCache getFileCache() {
        return this.fileCache;
    }

    public TaskSlotTable getTaskSlotTable() {
        return this.taskSlotTable;
    }

    public JobManagerTable getJobManagerTable() {
        return this.jobManagerTable;
    }

    public JobLeaderService getJobLeaderService() {
        return this.jobLeaderService;
    }

    public static TaskManagerServices fromConfiguration(TaskManagerServicesConfiguration taskManagerServicesConfiguration, ResourceID resourceID) throws Exception {
        TaskManagerServices.checkTempDirs(taskManagerServicesConfiguration.getTmpDirPaths());
        NetworkEnvironment network = TaskManagerServices.createNetworkEnvironment(taskManagerServicesConfiguration);
        network.start();
        TaskManagerLocation taskManagerLocation = new TaskManagerLocation(resourceID, taskManagerServicesConfiguration.getTaskManagerAddress(), network.getConnectionManager().getDataPort());
        MemoryManager memoryManager = TaskManagerServices.createMemoryManager(taskManagerServicesConfiguration);
        IOManagerAsync ioManager = new IOManagerAsync(taskManagerServicesConfiguration.getTmpDirPaths());
        BroadcastVariableManager broadcastVariableManager = new BroadcastVariableManager();
        FileCache fileCache = new FileCache(taskManagerServicesConfiguration.getTmpDirPaths());
        ArrayList<ResourceProfile> resourceProfiles = new ArrayList<ResourceProfile>(taskManagerServicesConfiguration.getNumberOfSlots());
        for (int i = 0; i < taskManagerServicesConfiguration.getNumberOfSlots(); ++i) {
            resourceProfiles.add(new ResourceProfile(1.0, 42));
        }
        TimerService<AllocationID> timerService = new TimerService<AllocationID>(new ScheduledThreadPoolExecutor(1), taskManagerServicesConfiguration.getTimerServiceShutdownTimeout());
        TaskSlotTable taskSlotTable = new TaskSlotTable(resourceProfiles, timerService);
        JobManagerTable jobManagerTable = new JobManagerTable();
        JobLeaderService jobLeaderService = new JobLeaderService(taskManagerLocation);
        return new TaskManagerServices(taskManagerLocation, memoryManager, ioManager, network, broadcastVariableManager, fileCache, taskSlotTable, jobManagerTable, jobLeaderService);
    }

    private static MemoryManager createMemoryManager(TaskManagerServicesConfiguration taskManagerServicesConfiguration) throws Exception {
        MemoryManager memoryManager;
        long memorySize;
        MemoryType memType = taskManagerServicesConfiguration.getNetworkConfig().memoryType();
        long configuredMemory = taskManagerServicesConfiguration.getConfiguredMemory();
        boolean preAllocateMemory = taskManagerServicesConfiguration.isPreAllocateMemory();
        if (configuredMemory > 0L) {
            if (preAllocateMemory) {
                LOG.info("Using {} MB for managed memory.", (Object)configuredMemory);
            } else {
                LOG.info("Limiting managed memory to {} MB, memory will be allocated lazily.", (Object)configuredMemory);
            }
            memorySize = configuredMemory << 20;
        } else {
            float memoryFraction = taskManagerServicesConfiguration.getMemoryFraction();
            if (memType == MemoryType.HEAP) {
                long relativeMemSize = (long)((float)EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag() * memoryFraction);
                if (preAllocateMemory) {
                    LOG.info("Using {} of the currently free heap space for managed heap memory ({} MB).", (Object)Float.valueOf(memoryFraction), (Object)(relativeMemSize >> 20));
                } else {
                    LOG.info("Limiting managed memory to {} of the currently free heap space ({} MB), memory will be allocated lazily.", (Object)Float.valueOf(memoryFraction), (Object)(relativeMemSize >> 20));
                }
                memorySize = relativeMemSize;
            } else if (memType == MemoryType.OFF_HEAP) {
                long maxMemory = EnvironmentInformation.getMaxJvmHeapMemory();
                long directMemorySize = (long)((double)maxMemory / (1.0 - (double)memoryFraction) * (double)memoryFraction);
                if (preAllocateMemory) {
                    LOG.info("Using {} of the maximum memory size for managed off-heap memory ({} MB).", (Object)Float.valueOf(memoryFraction), (Object)(directMemorySize >> 20));
                } else {
                    LOG.info("Limiting managed memory to {} of the maximum memory size ({} MB), memory will be allocated lazily.", (Object)Float.valueOf(memoryFraction), (Object)(directMemorySize >> 20));
                }
                memorySize = directMemorySize;
            } else {
                throw new RuntimeException("No supported memory type detected.");
            }
        }
        try {
            memoryManager = new MemoryManager(memorySize, taskManagerServicesConfiguration.getNumberOfSlots(), taskManagerServicesConfiguration.getNetworkConfig().networkBufferSize(), memType, preAllocateMemory);
        }
        catch (OutOfMemoryError e) {
            if (memType == MemoryType.HEAP) {
                throw new Exception("OutOfMemory error (" + e.getMessage() + ") while allocating the TaskManager heap memory (" + memorySize + " bytes).", e);
            }
            if (memType == MemoryType.OFF_HEAP) {
                throw new Exception("OutOfMemory error (" + e.getMessage() + ") while allocating the TaskManager off-heap memory (" + memorySize + " bytes).Try increasing the maximum direct memory (-XX:MaxDirectMemorySize)", e);
            }
            throw e;
        }
        return memoryManager;
    }

    private static NetworkEnvironment createNetworkEnvironment(TaskManagerServicesConfiguration taskManagerServicesConfiguration) throws IOException {
        int segmentSize;
        NetworkEnvironmentConfiguration networkEnvironmentConfiguration = taskManagerServicesConfiguration.getNetworkConfig();
        long networkBuf = TaskManagerServices.calculateNetworkBufferMemory(taskManagerServicesConfiguration);
        long numNetBuffersLong = networkBuf / (long)(segmentSize = networkEnvironmentConfiguration.networkBufferSize());
        if (numNetBuffersLong > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("The given number of memory bytes (" + networkBuf + ") corresponds to more than MAX_INT pages.");
        }
        NetworkBufferPool networkBufferPool = new NetworkBufferPool((int)numNetBuffersLong, segmentSize, networkEnvironmentConfiguration.memoryType());
        ConnectionManager connectionManager = networkEnvironmentConfiguration.nettyConfig() != null ? new NettyConnectionManager(networkEnvironmentConfiguration.nettyConfig()) : new LocalConnectionManager();
        ResultPartitionManager resultPartitionManager = new ResultPartitionManager();
        TaskEventDispatcher taskEventDispatcher = new TaskEventDispatcher();
        KvStateRegistry kvStateRegistry = new KvStateRegistry();
        QueryableStateConfiguration qsConfig = taskManagerServicesConfiguration.getQueryableStateConfig();
        int numProxyServerNetworkThreads = qsConfig.numProxyServerThreads() == 0 ? taskManagerServicesConfiguration.getNumberOfSlots() : qsConfig.numProxyServerThreads();
        int numProxyServerQueryThreads = qsConfig.numProxyQueryThreads() == 0 ? taskManagerServicesConfiguration.getNumberOfSlots() : qsConfig.numProxyQueryThreads();
        KvStateClientProxy kvClientProxy = QueryableStateUtils.createKvStateClientProxy(taskManagerServicesConfiguration.getTaskManagerAddress(), qsConfig.getProxyPortRange(), numProxyServerNetworkThreads, numProxyServerQueryThreads, (KvStateRequestStats)new DisabledKvStateRequestStats());
        int numStateServerNetworkThreads = qsConfig.numStateServerThreads() == 0 ? taskManagerServicesConfiguration.getNumberOfSlots() : qsConfig.numStateServerThreads();
        int numStateServerQueryThreads = qsConfig.numStateQueryThreads() == 0 ? taskManagerServicesConfiguration.getNumberOfSlots() : qsConfig.numStateQueryThreads();
        KvStateServer kvStateServer = QueryableStateUtils.createKvStateServer(taskManagerServicesConfiguration.getTaskManagerAddress(), qsConfig.getStateServerPortRange(), numStateServerNetworkThreads, numStateServerQueryThreads, kvStateRegistry, (KvStateRequestStats)new DisabledKvStateRequestStats());
        return new NetworkEnvironment(networkBufferPool, connectionManager, resultPartitionManager, taskEventDispatcher, kvStateRegistry, kvStateServer, kvClientProxy, networkEnvironmentConfiguration.ioMode(), networkEnvironmentConfiguration.partitionRequestInitialBackoff(), networkEnvironmentConfiguration.partitionRequestMaxBackoff(), networkEnvironmentConfiguration.networkBuffersPerChannel(), networkEnvironmentConfiguration.floatingNetworkBuffersPerGate());
    }

    public static long calculateNetworkBufferMemory(long totalJavaMemorySize, Configuration config) {
        long networkBufBytes;
        Preconditions.checkArgument((totalJavaMemorySize > 0L ? 1 : 0) != 0);
        int segmentSize = config.getInteger(TaskManagerOptions.MEMORY_SEGMENT_SIZE);
        if (TaskManagerServicesConfiguration.hasNewNetworkBufConf(config)) {
            float networkBufFraction = config.getFloat(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION);
            long networkBufMin = config.getLong(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN);
            long networkBufMax = config.getLong(TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX);
            TaskManagerServicesConfiguration.checkNetworkBufferConfig(segmentSize, networkBufFraction, networkBufMin, networkBufMax);
            networkBufBytes = Math.min(networkBufMax, Math.max(networkBufMin, (long)(networkBufFraction * (float)totalJavaMemorySize)));
            TaskManagerServicesConfiguration.checkConfigParameter(networkBufBytes < totalJavaMemorySize, "(" + networkBufFraction + ", " + networkBufMin + ", " + networkBufMax + ")", "(" + TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION.key() + ", " + TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN.key() + ", " + TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX.key() + ")", "Network buffer memory size too large: " + networkBufBytes + " >= " + totalJavaMemorySize + " (total JVM memory size)");
        } else {
            int numNetworkBuffers = config.getInteger(TaskManagerOptions.NETWORK_NUM_BUFFERS);
            networkBufBytes = (long)numNetworkBuffers * (long)segmentSize;
            TaskManagerServicesConfiguration.checkNetworkConfigOld(numNetworkBuffers);
            TaskManagerServicesConfiguration.checkConfigParameter(networkBufBytes < totalJavaMemorySize, networkBufBytes, TaskManagerOptions.NETWORK_NUM_BUFFERS.key(), "Network buffer memory size too large: " + networkBufBytes + " >= " + totalJavaMemorySize + " (total JVM memory size)");
        }
        return networkBufBytes;
    }

    public static long calculateNetworkBufferMemory(TaskManagerServicesConfiguration tmConfig) {
        long networkBufBytes;
        long networkBufMax;
        NetworkEnvironmentConfiguration networkConfig = tmConfig.getNetworkConfig();
        float networkBufFraction = networkConfig.networkBufFraction();
        long networkBufMin = networkConfig.networkBufMin();
        if (networkBufMin == (networkBufMax = networkConfig.networkBufMax())) {
            return networkBufMin;
        }
        MemoryType memType = networkConfig.memoryType();
        if (memType == MemoryType.HEAP) {
            long relativeMemSize = EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag();
            networkBufBytes = Math.min(networkBufMax, Math.max(networkBufMin, (long)(networkBufFraction * (float)relativeMemSize)));
            TaskManagerServicesConfiguration.checkConfigParameter(networkBufBytes < relativeMemSize, "(" + networkBufFraction + ", " + networkBufMin + ", " + networkBufMax + ")", "(" + TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION.key() + ", " + TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN.key() + ", " + TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX.key() + ")", "Network buffer memory size too large: " + networkBufBytes + " >= " + relativeMemSize + "(free JVM heap size)");
        } else if (memType == MemoryType.OFF_HEAP) {
            long jvmHeapNoNet;
            long maxMemory = EnvironmentInformation.getMaxJvmHeapMemory();
            long configuredMemory = tmConfig.getConfiguredMemory() << 20;
            if (configuredMemory > 0L) {
                jvmHeapNoNet = maxMemory + configuredMemory;
            } else {
                float managedFraction = tmConfig.getMemoryFraction();
                jvmHeapNoNet = (long)((double)maxMemory / (1.0 - (double)managedFraction));
            }
            networkBufBytes = Math.min(networkBufMax, Math.max(networkBufMin, (long)((double)jvmHeapNoNet / (1.0 - (double)networkBufFraction) * (double)networkBufFraction)));
            TaskManagerServicesConfiguration.checkConfigParameter(networkBufBytes < maxMemory, "(" + networkBufFraction + ", " + networkBufMin + ", " + networkBufMax + ")", "(" + TaskManagerOptions.NETWORK_BUFFERS_MEMORY_FRACTION.key() + ", " + TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MIN.key() + ", " + TaskManagerOptions.NETWORK_BUFFERS_MEMORY_MAX.key() + ")", "Network buffer memory size too large: " + networkBufBytes + " >= " + maxMemory + "(maximum JVM heap size)");
        } else {
            throw new RuntimeException("No supported memory type detected.");
        }
        return networkBufBytes;
    }

    public static long calculateHeapSizeMB(long totalJavaMemorySizeMB, Configuration config) {
        long heapSizeMB;
        Preconditions.checkArgument((totalJavaMemorySizeMB > 0L ? 1 : 0) != 0);
        long totalJavaMemorySize = totalJavaMemorySizeMB << 20;
        boolean useOffHeap = config.getBoolean(TaskManagerOptions.MEMORY_OFF_HEAP);
        if (useOffHeap) {
            long networkBufMB = TaskManagerServices.calculateNetworkBufferMemory(totalJavaMemorySize, config) >> 20;
            long remainingJavaMemorySizeMB = totalJavaMemorySizeMB - networkBufMB;
            long offHeapSize = config.getLong(TaskManagerOptions.MANAGED_MEMORY_SIZE);
            if (offHeapSize <= 0L) {
                double fraction = config.getFloat(TaskManagerOptions.MANAGED_MEMORY_FRACTION);
                offHeapSize = (long)(fraction * (double)remainingJavaMemorySizeMB);
            }
            TaskManagerServicesConfiguration.checkConfigParameter(offHeapSize < remainingJavaMemorySizeMB, offHeapSize, TaskManagerOptions.MANAGED_MEMORY_SIZE.key(), "Managed memory size too large for " + networkBufMB + " MB network buffer memory and a total of " + totalJavaMemorySizeMB + " MB JVM memory");
            heapSizeMB = remainingJavaMemorySizeMB - offHeapSize;
        } else {
            heapSizeMB = totalJavaMemorySizeMB;
        }
        return heapSizeMB;
    }

    private static void checkTempDirs(String[] tmpDirs) throws IOException {
        for (String dir : tmpDirs) {
            if (dir != null && !dir.equals("")) {
                File file = new File(dir);
                if (!file.exists() && !file.mkdirs()) {
                    throw new IOException("Temporary file directory " + file.getAbsolutePath() + " does not exist and could not be created.");
                }
                if (!file.isDirectory()) {
                    throw new IOException("Temporary file directory " + file.getAbsolutePath() + " is not a directory.");
                }
                if (!file.canWrite()) {
                    throw new IOException("Temporary file directory " + file.getAbsolutePath() + " is not writable.");
                }
                if (!LOG.isInfoEnabled()) continue;
                long totalSpaceGb = file.getTotalSpace() >> 30;
                long usableSpaceGb = file.getUsableSpace() >> 30;
                double usablePercentage = (double)usableSpaceGb / (double)totalSpaceGb * 100.0;
                String path = file.getAbsolutePath();
                LOG.info(String.format("Temporary file directory '%s': total %d GB, usable %d GB (%.2f%% usable)", path, totalSpaceGb, usableSpaceGb, usablePercentage));
                continue;
            }
            throw new IllegalArgumentException("Temporary file directory #$id is null.");
        }
    }
}

