/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import akka.actor.ActorNotFound;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.Props$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.akka.DefaultQuarantineHandler;
import org.apache.flink.runtime.akka.QuarantineMonitor;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.runtime.process.ProcessReaper;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerConfiguration;
import org.apache.flink.runtime.taskexecutor.TaskManagerServices;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.taskmanager.MemoryLogger;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManagerCliOptions;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.util.NetUtils;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Try;
import scopt.OptionParser;
import scopt.Read$;

public final class TaskManager$ {
    public static final TaskManager$ MODULE$;
    private final Logger LOG;
    private final int STARTUP_FAILURE_RETURN_CODE;
    private final int RUNTIME_FAILURE_RETURN_CODE;
    private final long MAX_STARTUP_CONNECT_TIME;
    private final long STARTUP_CONNECT_LOG_SUPPRESS;
    private final FiniteDuration HEARTBEAT_INTERVAL;

    static {
        new TaskManager$();
    }

    public Logger LOG() {
        return this.LOG;
    }

    public int STARTUP_FAILURE_RETURN_CODE() {
        return this.STARTUP_FAILURE_RETURN_CODE;
    }

    public int RUNTIME_FAILURE_RETURN_CODE() {
        return this.RUNTIME_FAILURE_RETURN_CODE;
    }

    public long MAX_STARTUP_CONNECT_TIME() {
        return this.MAX_STARTUP_CONNECT_TIME;
    }

    public long STARTUP_CONNECT_LOG_SUPPRESS() {
        return this.STARTUP_CONNECT_LOG_SUPPRESS;
    }

    public FiniteDuration HEARTBEAT_INTERVAL() {
        return this.HEARTBEAT_INTERVAL;
    }

    public void main(String[] args) {
        Configuration configuration;
        EnvironmentInformation.logEnvironmentInfo(this.LOG().logger(), "TaskManager", args);
        SignalHandler.register(this.LOG().logger());
        JvmShutdownSafeguard.installAsShutdownHook(this.LOG().logger());
        long maxOpenFileHandles = EnvironmentInformation.getOpenFileHandlesLimit();
        if (maxOpenFileHandles != -1L) {
            this.LOG().info((Function0)new Serializable(maxOpenFileHandles){
                public static final long serialVersionUID = 0L;
                private final long maxOpenFileHandles$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum number of open file descriptors is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.maxOpenFileHandles$1)}));
                }
                {
                    this.maxOpenFileHandles$1 = maxOpenFileHandles$1;
                }
            });
        } else {
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot determine the maximum number of open file descriptors";
                }
            });
        }
        try {
            configuration = this.parseArgsAndLoadConfig(args);
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$10;

                public final String apply() {
                    return this.t$10.getMessage();
                }
                {
                    this.t$10 = t$10;
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$10;

                public final Throwable apply() {
                    return this.t$10;
                }
                {
                    this.t$10 = t$10;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
            configuration = null;
        }
        Configuration configuration2 = configuration;
        ResourceID resourceId = ResourceID.generate();
        SecurityUtils.install(new SecurityConfiguration(configuration2));
        try {
            SecurityUtils.getInstalledContext().runSecured(new Callable<BoxedUnit>(configuration2, resourceId){
                private final Configuration configuration$1;
                private final ResourceID resourceId$1;

                public void call() {
                    TaskManager$.MODULE$.selectNetworkInterfaceAndRunTaskManager(this.configuration$1, this.resourceId$1, TaskManager.class);
                }
                {
                    this.configuration$1 = configuration$1;
                    this.resourceId$1 = resourceId$1;
                }
            });
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Failed to run TaskManager.";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$11;

                public final Throwable apply() {
                    return this.t$11;
                }
                {
                    this.t$11 = t$11;
                }
            });
            System.exit(this.STARTUP_FAILURE_RETURN_CODE());
        }
    }

    public Configuration parseArgsAndLoadConfig(String[] args) throws Exception {
        Configuration conf;
        OptionParser<TaskManagerCliOptions> parser = new OptionParser<TaskManagerCliOptions>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Flink TaskManager"}));
                this.opt("configDir", Read$.MODULE$.stringRead()).action((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TaskManagerCliOptions apply(String param, TaskManagerCliOptions conf) {
                        conf.setConfigDir(param);
                        return conf;
                    }
                }).text("Specify configuration directory.");
            }
        };
        TaskManagerCliOptions cliConfig = (TaskManagerCliOptions)parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new TaskManagerCliOptions()).getOrElse((Function0)new Serializable(args, (OptionParser)parser){
            public static final long serialVersionUID = 0L;
            private final String[] args$1;
            private final OptionParser parser$1;

            public final Nothing$ apply() {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid command line arguments: ", ". Usage: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.args$1).mkString(" "), this.parser$1.usage()})));
            }
            {
                this.args$1 = args$1;
                this.parser$1 = parser$1;
            }
        });
        try {
            this.LOG().info((Function0)new Serializable(cliConfig){
                public static final long serialVersionUID = 0L;
                private final TaskManagerCliOptions cliConfig$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Loading configuration from ").append((Object)this.cliConfig$1.getConfigDir()).toString();
                }
                {
                    this.cliConfig$1 = cliConfig$1;
                }
            });
            conf = GlobalConfiguration.loadConfiguration((String)cliConfig.getConfigDir());
        }
        catch (Exception exception) {
            throw new Exception("Could not load configuration", exception);
        }
        try {
            FileSystem.initialize((Configuration)conf);
            return conf;
        }
        catch (IOException iOException) {
            throw new Exception("Error while setting the default filesystem scheme from configuration.", iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void selectNetworkInterfaceAndRunTaskManager(Configuration configuration, ResourceID resourceID, Class<? extends TaskManager> taskManagerClass) throws Exception {
        Tuple2 tuple22;
        HighAvailabilityServices highAvailabilityServices = HighAvailabilityServicesUtils.createHighAvailabilityServices(configuration, Executors.directExecutor(), HighAvailabilityServicesUtils.AddressResolution.TRY_ADDRESS_RESOLUTION);
        Tuple2<String, Iterator<Integer>> tuple2 = this.selectNetworkInterfaceAndPortRange(configuration, highAvailabilityServices);
        if (tuple2 == null) throw new MatchError(tuple2);
        String taskManagerHostname = (String)tuple2._1();
        Iterator actorSystemPortRange = (Iterator)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)taskManagerHostname, (Object)actorSystemPortRange);
        String taskManagerHostname2 = (String)tuple23._1();
        Iterator actorSystemPortRange2 = (Iterator)tuple23._2();
        try {
            this.runTaskManager(taskManagerHostname2, resourceID, actorSystemPortRange2, configuration, highAvailabilityServices, taskManagerClass);
        }
        catch (Throwable throwable) {
            try {
                highAvailabilityServices.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                this.LOG().warn((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Could not properly stop the high availability services.";
                    }
                }, (Function0)new Serializable(throwable2){
                    public static final long serialVersionUID = 0L;
                    private final Throwable t$12;

                    public final Throwable apply() {
                        return this.t$12;
                    }
                    {
                        this.t$12 = t$12;
                    }
                });
            }
            throw throwable;
        }
        try {
            highAvailabilityServices.close();
            return;
        }
        catch (Throwable throwable) {
            this.LOG().warn((Function0)new /* invalid duplicate definition of identical inner class */, (Function0)new /* invalid duplicate definition of identical inner class */);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<String, Iterator<Integer>> selectNetworkInterfaceAndPortRange(Configuration configuration, HighAvailabilityServices highAvailabilityServices) throws IOException, IllegalConfigurationException {
        Iterator portRangeIterator;
        ObjectRef taskManagerHostname = ObjectRef.create((Object)configuration.getString("taskmanager.hostname", null));
        if ((String)taskManagerHostname.elem == null) {
            FiniteDuration lookupTimeout = AkkaUtils$.MODULE$.getLookupTimeout(configuration);
            InetAddress taskManagerAddress = LeaderRetrievalUtils.findConnectingAddress(highAvailabilityServices.getJobManagerLeaderRetriever(HighAvailabilityServices.DEFAULT_JOB_ID), lookupTimeout);
            taskManagerHostname.elem = taskManagerAddress.getHostName();
            this.LOG().info((Function0)new Serializable(taskManagerHostname, taskManagerAddress){
                public static final long serialVersionUID = 0L;
                private final ObjectRef taskManagerHostname$3;
                private final InetAddress taskManagerAddress$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaskManager will use hostname/address '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{(String)this.taskManagerHostname$3.elem}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") for communication."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskManagerAddress$1.getHostAddress()}))).toString();
                }
                {
                    this.taskManagerHostname$3 = taskManagerHostname$3;
                    this.taskManagerAddress$1 = taskManagerAddress$1;
                }
            });
        } else {
            this.LOG().info((Function0)new Serializable(taskManagerHostname){
                public static final long serialVersionUID = 0L;
                private final ObjectRef taskManagerHostname$3;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using configured hostname/address for TaskManager: ").append((Object)((String)this.taskManagerHostname$3.elem)).toString();
                }
                {
                    this.taskManagerHostname$3 = taskManagerHostname$3;
                }
            });
        }
        String portRange = configuration.getString(TaskManagerOptions.RPC_PORT);
        try {
            portRangeIterator = NetUtils.getPortRangeFromString((String)portRange);
        }
        catch (NumberFormatException numberFormatException) {
            void var6_6;
            throw new IllegalConfigurationException(new StringBuilder().append((Object)"Invalid value for '").append((Object)TaskManagerOptions.RPC_PORT.key()).append((Object)"' (port for the TaskManager actor system) : ").append((Object)var6_6).append((Object)" - Leave config parameter empty or use 0 to let the system choose a port automatically.").toString());
        }
        return new Tuple2((Object)((String)taskManagerHostname.elem), (Object)portRangeIterator);
    }

    public void runTaskManager(String taskManagerHostname, ResourceID resourceID, int actorSystemPort, Configuration configuration, HighAvailabilityServices highAvailabilityServices) throws Exception {
        this.runTaskManager(taskManagerHostname, resourceID, actorSystemPort, configuration, highAvailabilityServices, TaskManager.class);
    }

    public void runTaskManager(String taskManagerHostname, ResourceID resourceID, int actorSystemPort, Configuration configuration, HighAvailabilityServices highAvailabilityServices, Class<? extends TaskManager> taskManagerClass) throws Exception {
        this.LOG().info((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting TaskManager";
            }
        });
        this.LOG().info((Function0)new Serializable(taskManagerHostname, actorSystemPort){
            public static final long serialVersionUID = 0L;
            private final String taskManagerHostname$2;
            private final int actorSystemPort$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting TaskManager actor system at ", ":", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.taskManagerHostname$2, BoxesRunTime.boxToInteger((int)this.actorSystemPort$1)}));
            }
            {
                this.taskManagerHostname$2 = taskManagerHostname$2;
                this.actorSystemPort$1 = actorSystemPort$1;
            }
        });
        ActorSystem taskManagerSystem = BootstrapTools.startActorSystem(configuration, taskManagerHostname, actorSystemPort, this.LOG().logger());
        MetricRegistryImpl metricRegistry = new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration(configuration));
        metricRegistry.startQueryService(taskManagerSystem, resourceID);
        try {
            BoxedUnit boxedUnit;
            this.LOG().info((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting TaskManager actor";
                }
            });
            ActorRef taskManager = this.startTaskManagerComponentsAndActor(configuration, resourceID, taskManagerSystem, highAvailabilityServices, metricRegistry, taskManagerHostname, (Option<String>)new Some((Object)"taskmanager"), false, taskManagerClass);
            this.LOG().debug((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Starting TaskManager process reaper";
                }
            });
            taskManagerSystem.actorOf(Props$.MODULE$.apply(ProcessReaper.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManager, this.LOG().logger(), BoxesRunTime.boxToInteger((int)this.RUNTIME_FAILURE_RETURN_CODE())})), "TaskManager_Process_Reaper");
            if (configuration.getBoolean(TaskManagerOptions.EXIT_ON_FATAL_AKKA_ERROR)) {
                DefaultQuarantineHandler quarantineHandler = new DefaultQuarantineHandler(Time.milliseconds((long)AkkaUtils$.MODULE$.getTimeout(configuration).toMillis()), this.RUNTIME_FAILURE_RETURN_CODE(), this.LOG().logger());
                this.LOG().debug((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Starting TaskManager quarantine monitor";
                    }
                });
                boxedUnit = taskManagerSystem.actorOf(Props$.MODULE$.apply(QuarantineMonitor.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quarantineHandler, this.LOG().logger()})));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (this.LOG().isInfoEnabled() && configuration.getBoolean("taskmanager.debug.memory.startLogThread", false)) {
                this.LOG().info((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Starting periodic memory usage logger";
                    }
                });
                long interval = configuration.getLong("taskmanager.debug.memory.logIntervalMs", 5000L);
                MemoryLogger logger = new MemoryLogger(this.LOG().logger(), interval, taskManagerSystem);
                logger.start();
            }
            taskManagerSystem.awaitTermination();
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while starting up taskManager";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$13;

                public final Throwable apply() {
                    return this.t$13;
                }
                {
                    this.t$13 = t$13;
                }
            });
            try {
                taskManagerSystem.shutdown();
            }
            catch (Throwable throwable2) {
                this.LOG().warn((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Could not cleanly shut down actor system";
                    }
                }, (Function0)new Serializable(throwable2){
                    public static final long serialVersionUID = 0L;
                    private final Throwable tt$1;

                    public final Throwable apply() {
                        return this.tt$1;
                    }
                    {
                        this.tt$1 = tt$1;
                    }
                });
            }
            throw throwable;
        }
        try {
            metricRegistry.shutdown();
        }
        catch (Throwable throwable) {
            this.LOG().error((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Could not properly shut down the metric registry.";
                }
            }, (Function0)new Serializable(throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$14;

                public final Throwable apply() {
                    return this.t$14;
                }
                {
                    this.t$14 = t$14;
                }
            });
        }
    }

    public void runTaskManager(String taskManagerHostname, ResourceID resourceID, Iterator<Integer> actorSystemPortRange, Configuration configuration, HighAvailabilityServices highAvailabilityServices, Class<? extends TaskManager> taskManagerClass) throws Exception {
        Try result = AkkaUtils$.MODULE$.retryOnBindException(new Serializable(taskManagerHostname, resourceID, actorSystemPortRange, configuration, highAvailabilityServices, taskManagerClass){
            public static final long serialVersionUID = 0L;
            private final String taskManagerHostname$1;
            private final ResourceID resourceID$1;
            private final Iterator actorSystemPortRange$1;
            private final Configuration configuration$2;
            private final HighAvailabilityServices highAvailabilityServices$1;
            private final Class taskManagerClass$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * WARNING - void declaration
             */
            public void apply$mcV$sp() {
                int n;
                ServerSocket socket = NetUtils.createSocketFromPorts((Iterator)this.actorSystemPortRange$1, (NetUtils.SocketFactory)new NetUtils.SocketFactory(this){

                    public ServerSocket createSocket(int port) {
                        return new ServerSocket(port, 0, InetAddress.getByName(NetUtils.getWildcardIPAddress()));
                    }
                });
                if (socket == null) {
                    throw new BindException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to allocate port for TaskManager."})).s((Seq)Nil$.MODULE$));
                }
                try {
                    n = socket.getLocalPort();
                }
                catch (Throwable throwable) {
                    void var1_1;
                    var1_1.close();
                    throw throwable;
                }
                socket.close();
                int port = n;
                TaskManager$.MODULE$.runTaskManager(this.taskManagerHostname$1, this.resourceID$1, port, this.configuration$2, this.highAvailabilityServices$1, (Class<? extends TaskManager>)this.taskManagerClass$1);
            }
            {
                this.taskManagerHostname$1 = taskManagerHostname$1;
                this.resourceID$1 = resourceID$1;
                this.actorSystemPortRange$1 = actorSystemPortRange$1;
                this.configuration$2 = configuration$2;
                this.highAvailabilityServices$1 = highAvailabilityServices$1;
                this.taskManagerClass$1 = taskManagerClass$1;
            }
        }, (Function0<Object>)new Serializable(actorSystemPortRange){
            public static final long serialVersionUID = 0L;
            private final Iterator actorSystemPortRange$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.actorSystemPortRange$1.hasNext();
            }
            {
                this.actorSystemPortRange$1 = actorSystemPortRange$1;
            }
        }, 5000L);
        Try try_ = result;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable f = failure.exception();
            throw f;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ActorRef startTaskManagerComponentsAndActor(Configuration configuration, ResourceID resourceID, ActorSystem actorSystem, HighAvailabilityServices highAvailabilityServices, MetricRegistry metricRegistry, String taskManagerHostname, Option<String> taskManagerActorName, boolean localTaskManagerCommunication, Class<? extends TaskManager> taskManagerClass) throws IllegalConfigurationException, IOException, Exception {
        Option<String> option;
        block4: {
            ActorRef actorRef;
            block3: {
                Props tmProps;
                block2: {
                    InetAddress taskManagerAddress = InetAddress.getByName(taskManagerHostname);
                    TaskManagerServicesConfiguration taskManagerServicesConfiguration = TaskManagerServicesConfiguration.fromConfiguration(configuration, taskManagerAddress, false);
                    TaskManagerConfiguration taskManagerConfiguration = TaskManagerConfiguration.fromConfiguration(configuration);
                    TaskManagerServices taskManagerServices = TaskManagerServices.fromConfiguration(taskManagerServicesConfiguration, resourceID);
                    TaskManagerMetricGroup taskManagerMetricGroup = MetricUtils.instantiateTaskManagerMetricGroup(metricRegistry, taskManagerServices.getTaskManagerLocation(), taskManagerServices.getNetworkEnvironment());
                    tmProps = this.getTaskManagerProps(taskManagerClass, taskManagerConfiguration, resourceID, taskManagerServices.getTaskManagerLocation(), taskManagerServices.getMemoryManager(), taskManagerServices.getIOManager(), taskManagerServices.getNetworkEnvironment(), highAvailabilityServices, taskManagerMetricGroup);
                    option = taskManagerActorName;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String actorName = (String)some.x();
                    actorRef = actorSystem.actorOf(tmProps, actorName);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                actorRef = actorSystem.actorOf(tmProps);
            }
            return actorRef;
        }
        throw new MatchError(option);
    }

    public Props getTaskManagerProps(Class<? extends TaskManager> taskManagerClass, TaskManagerConfiguration taskManagerConfig, ResourceID resourceID, TaskManagerLocation taskManagerLocation, MemoryManager memoryManager, IOManager ioManager, NetworkEnvironment networkEnvironment, HighAvailabilityServices highAvailabilityServices, TaskManagerMetricGroup taskManagerMetricGroup) {
        return Props$.MODULE$.apply(taskManagerClass, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManagerConfig, resourceID, taskManagerLocation, memoryManager, ioManager, networkEnvironment, BoxesRunTime.boxToInteger((int)taskManagerConfig.getNumberSlots()), highAvailabilityServices, taskManagerMetricGroup}));
    }

    public ActorRef getTaskManagerRemoteReference(String taskManagerUrl, ActorSystem system, FiniteDuration timeout) throws IOException {
        try {
            Future<ActorRef> future = AkkaUtils$.MODULE$.getActorRefFuture(taskManagerUrl, system, timeout);
            return (ActorRef)Await$.MODULE$.result(future, (Duration)timeout);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ActorNotFound ? true : throwable2 instanceof TimeoutException;
            if (bl) {
                throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TaskManager at ", " not reachable. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{taskManagerUrl}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please make sure that the TaskManager is running and its port is reachable."})).s((Seq)Nil$.MODULE$)).toString(), throwable2);
            }
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                throw new IOException(new StringBuilder().append((Object)"Could not connect to TaskManager at ").append((Object)taskManagerUrl).toString(), iOException);
            }
            throw throwable;
        }
    }

    private TaskManager$() {
        MODULE$ = this;
        this.LOG = Logger$.MODULE$.apply(TaskManager.class);
        this.STARTUP_FAILURE_RETURN_CODE = 1;
        this.RUNTIME_FAILURE_RETURN_CODE = 2;
        this.MAX_STARTUP_CONNECT_TIME = 120000L;
        this.STARTUP_CONNECT_LOG_SUPPRESS = 10000L;
        this.HEARTBEAT_INTERVAL = new package.DurationInt(package$.MODULE$.DurationInt(5000)).milliseconds();
    }
}

