/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerGetTest;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class BlobCacheCorruptionTest
extends TestLogger {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testGetFailsFromCorruptFile1() throws IOException {
        this.testGetFailsFromCorruptFile(null, BlobKey.BlobType.TRANSIENT_BLOB, false);
    }

    @Test
    public void testGetFailsFromCorruptFile2() throws IOException {
        this.testGetFailsFromCorruptFile(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB, false);
    }

    @Test
    public void testGetFailsFromCorruptFile3() throws IOException {
        this.testGetFailsFromCorruptFile(new JobID(), BlobKey.BlobType.PERMANENT_BLOB, false);
    }

    @Test
    public void testGetFailsFromCorruptFile4() throws IOException {
        this.testGetFailsFromCorruptFile(new JobID(), BlobKey.BlobType.PERMANENT_BLOB, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGetFailsFromCorruptFile(JobID jobId, BlobKey.BlobType blobType, boolean corruptOnHAStore) throws IOException {
        Configuration config = new Configuration();
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, this.temporaryFolder.newFolder().getPath());
        BlobStoreService blobStoreService = null;
        try {
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            BlobCacheCorruptionTest.testGetFailsFromCorruptFile(jobId, blobType, corruptOnHAStore, config, (BlobStore)blobStoreService, this.exception);
        }
        finally {
            if (blobStoreService != null) {
                blobStoreService.closeAndCleanupAllData();
            }
        }
    }

    public static void testGetFailsFromCorruptFile(JobID jobId, Configuration config, BlobStore blobStore, ExpectedException expectedException) throws IOException {
        BlobCacheCorruptionTest.testGetFailsFromCorruptFile(jobId, BlobKey.BlobType.PERMANENT_BLOB, true, config, blobStore, expectedException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testGetFailsFromCorruptFile(@Nullable JobID jobId, BlobKey.BlobType blobType, boolean corruptOnHAStore, Configuration config, BlobStore blobStore, ExpectedException expectedException) throws IOException {
        Assert.assertTrue((String)"corrupt HA file requires a HA setup", (!corruptOnHAStore || blobType == BlobKey.BlobType.PERMANENT_BLOB ? 1 : 0) != 0);
        Random rnd = new Random();
        try (BlobServer server = new BlobServer(config, blobStore);
             BlobCacheService cache = new BlobCacheService(new InetSocketAddress("localhost", server.getPort()), config, (BlobView)(corruptOnHAStore ? blobStore : new VoidBlobStore()));){
            server.start();
            byte[] data = new byte[2000000];
            rnd.nextBytes(data);
            BlobKey key = BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
            Assert.assertNotNull((Object)key);
            byte[] data2 = Arrays.copyOf(data, data.length);
            data2[0] = (byte)(data2[0] ^ 1);
            if (corruptOnHAStore) {
                File tmpFile = Files.createTempFile("blob", ".jar", new FileAttribute[0]).toFile();
                try {
                    FileUtils.writeByteArrayToFile((File)tmpFile, (byte[])data2);
                    blobStore.put(tmpFile, jobId, key);
                }
                finally {
                    tmpFile.delete();
                }
                File blobFile = server.getStorageLocation(jobId, key);
                Assert.assertTrue((boolean)blobFile.delete());
            } else {
                File blobFile = server.getStorageLocation(jobId, key);
                Assert.assertTrue((boolean)blobFile.exists());
                FileUtils.writeByteArrayToFile((File)blobFile, (byte[])data2);
            }
            expectedException.expect(IOException.class);
            expectedException.expectCause(CoreMatchers.allOf((Matcher)CoreMatchers.instanceOf(IOException.class), (Matcher)Matchers.hasProperty((String)"message", (Matcher)CoreMatchers.containsString((String)"data corruption"))));
            BlobServerGetTest.get((BlobService)cache, jobId, key);
        }
    }
}

