/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.TestingFailingBlobServer;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobCacheRetriesTest
extends TestLogger {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testBlobFetchRetries() throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        BlobCacheRetriesTest.testBlobFetchRetries(config, (BlobStore)new VoidBlobStore(), null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testBlobForJobFetchRetries() throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        BlobCacheRetriesTest.testBlobFetchRetries(config, (BlobStore)new VoidBlobStore(), new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testBlobFetchRetriesHa() throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, this.temporaryFolder.newFolder().getPath());
        BlobStoreService blobStoreService = null;
        try {
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            BlobCacheRetriesTest.testBlobFetchRetries(config, (BlobStore)blobStoreService, new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
        }
        finally {
            if (blobStoreService != null) {
                blobStoreService.closeAndCleanupAllData();
            }
        }
    }

    private static void testBlobFetchRetries(Configuration config, BlobStore blobStore, @Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        try (TestingFailingBlobServer server = new TestingFailingBlobServer(config, blobStore, 2);
             BlobCacheService cache = new BlobCacheService(new InetSocketAddress("localhost", server.getPort()), config, (BlobView)new VoidBlobStore());){
            server.start();
            BlobKey key = BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
            BlobServerPutTest.verifyContents((BlobService)cache, jobId, key, data);
        }
    }

    @Test
    public void testBlobNoJobFetchWithTooManyFailures() throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        BlobCacheRetriesTest.testBlobFetchWithTooManyFailures(config, (BlobStore)new VoidBlobStore(), null, BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testBlobForJobFetchWithTooManyFailures() throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        BlobCacheRetriesTest.testBlobFetchWithTooManyFailures(config, (BlobStore)new VoidBlobStore(), new JobID(), BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    public void testBlobForJobFetchWithTooManyFailuresHa() throws IOException {
        Configuration config = new Configuration();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, this.temporaryFolder.getRoot().getPath());
        BlobStoreService blobStoreService = null;
        try {
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            BlobCacheRetriesTest.testBlobFetchWithTooManyFailures(config, (BlobStore)blobStoreService, new JobID(), BlobKey.BlobType.PERMANENT_BLOB);
        }
        finally {
            if (blobStoreService != null) {
                blobStoreService.closeAndCleanupAllData();
            }
        }
    }

    private static void testBlobFetchWithTooManyFailures(Configuration config, BlobStore blobStore, @Nullable JobID jobId, BlobKey.BlobType blobType) throws IOException {
        byte[] data = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
        try (TestingFailingBlobServer server = new TestingFailingBlobServer(config, blobStore, 0, 10);
             BlobCacheService cache = new BlobCacheService(new InetSocketAddress("localhost", server.getPort()), config, (BlobView)new VoidBlobStore());){
            server.start();
            BlobKey key = BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
            try {
                BlobServerPutTest.verifyContents((BlobService)cache, jobId, key, data);
                Assert.fail((String)"This should fail");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

