/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.net.ServerSocket;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobServerRangeTest
extends TestLogger {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testOnEphemeralPort() throws IOException {
        Configuration conf = new Configuration();
        conf.setString(BlobServerOptions.PORT, "0");
        conf.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        BlobServer server = new BlobServer(conf, (BlobStore)new VoidBlobStore());
        server.start();
        server.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void testPortUnavailable() throws IOException {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("An exception was thrown while preparing the test " + e.getMessage()));
        }
        Configuration conf = new Configuration();
        conf.setString(BlobServerOptions.PORT, String.valueOf(socket.getLocalPort()));
        conf.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try {
            BlobServer server = new BlobServer(conf, (BlobStore)new VoidBlobStore());
            server.start();
        }
        finally {
            socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnePortAvailable() throws IOException {
        int numAllocated = 2;
        ServerSocket[] sockets = new ServerSocket[numAllocated];
        for (int i = 0; i < numAllocated; ++i) {
            try {
                sockets[i] = new ServerSocket(0);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                Assert.fail((String)("An exception was thrown while preparing the test " + e.getMessage()));
            }
        }
        int availablePort = NetUtils.getAvailablePort();
        Configuration conf = new Configuration();
        conf.setString(BlobServerOptions.PORT, sockets[0].getLocalPort() + "," + sockets[1].getLocalPort() + "," + availablePort);
        conf.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
        try {
            BlobServer server = new BlobServer(conf, (BlobStore)new VoidBlobStore());
            server.start();
            Assert.assertEquals((long)availablePort, (long)server.getPort());
            server.close();
        }
        finally {
            for (int i = 0; i < numAllocated; ++i) {
                sockets[i].close();
            }
        }
    }
}

