/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobUtilsTest
extends TestLogger {
    private static final String CANNOT_CREATE_THIS = "cannot-create-this";
    private File blobUtilsTestDirectory;
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Before
    public void before() throws IOException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        this.blobUtilsTestDirectory = this.temporaryFolder.newFolder();
        Assert.assertTrue((boolean)this.blobUtilsTestDirectory.setExecutable(true, false));
        Assert.assertTrue((boolean)this.blobUtilsTestDirectory.setReadable(true, false));
        Assert.assertTrue((boolean)this.blobUtilsTestDirectory.setWritable(false, false));
    }

    @After
    public void after() {
        Assert.assertTrue((boolean)this.blobUtilsTestDirectory.delete());
    }

    @Test(expected=IOException.class)
    public void testExceptionOnCreateStorageDirectoryFailure() throws IOException {
        BlobUtils.initLocalStorageDirectory((String)new File(this.blobUtilsTestDirectory, CANNOT_CREATE_THIS).getAbsolutePath());
    }

    @Test(expected=IOException.class)
    public void testExceptionOnCreateCacheDirectoryFailureNoJob() throws IOException {
        BlobUtils.getStorageLocation((File)new File(this.blobUtilsTestDirectory, CANNOT_CREATE_THIS), null, (BlobKey)new TransientBlobKey());
    }

    @Test(expected=IOException.class)
    public void testExceptionOnCreateCacheDirectoryFailureForJobTransient() throws IOException {
        BlobUtils.getStorageLocation((File)new File(this.blobUtilsTestDirectory, CANNOT_CREATE_THIS), (JobID)new JobID(), (BlobKey)new TransientBlobKey());
    }

    @Test(expected=IOException.class)
    public void testExceptionOnCreateCacheDirectoryFailureForJobPermanent() throws IOException {
        BlobUtils.getStorageLocation((File)new File(this.blobUtilsTestDirectory, CANNOT_CREATE_THIS), (JobID)new JobID(), (BlobKey)new PermanentBlobKey());
    }
}

