/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinatorTest;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.PendingCheckpoint;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.ExternalizedCheckpointSettings;
import org.apache.flink.runtime.messages.checkpoint.AcknowledgeCheckpoint;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={PendingCheckpoint.class})
public class CheckpointCoordinatorFailureTest
extends TestLogger {
    @Test
    public void testFailingCompletedCheckpointStoreAdd() throws Exception {
        JobID jid = new JobID();
        ExecutionAttemptID executionAttemptId = new ExecutionAttemptID();
        ExecutionVertex vertex = CheckpointCoordinatorTest.mockExecutionVertex(executionAttemptId);
        long triggerTimestamp = 1L;
        CheckpointCoordinator coord = new CheckpointCoordinator(jid, 600000L, 600000L, 0L, Integer.MAX_VALUE, ExternalizedCheckpointSettings.none(), new ExecutionVertex[]{vertex}, new ExecutionVertex[]{vertex}, new ExecutionVertex[]{vertex}, (CheckpointIDCounter)new StandaloneCheckpointIDCounter(), (CompletedCheckpointStore)new FailingCompletedCheckpointStore(), null, Executors.directExecutor(), SharedStateRegistry.DEFAULT_FACTORY);
        coord.triggerCheckpoint(1L, false);
        Assert.assertEquals((long)1L, (long)coord.getNumberOfPendingCheckpoints());
        PendingCheckpoint pendingCheckpoint = (PendingCheckpoint)coord.getPendingCheckpoints().values().iterator().next();
        Assert.assertFalse((boolean)pendingCheckpoint.isDiscarded());
        long checkpointId = (Long)coord.getPendingCheckpoints().keySet().iterator().next();
        KeyedStateHandle managedKeyedHandle = (KeyedStateHandle)Mockito.mock(KeyedStateHandle.class);
        KeyedStateHandle rawKeyedHandle = (KeyedStateHandle)Mockito.mock(KeyedStateHandle.class);
        OperatorStateHandle managedOpHandle = (OperatorStateHandle)Mockito.mock(OperatorStateHandle.class);
        OperatorStateHandle rawOpHandle = (OperatorStateHandle)Mockito.mock(OperatorStateHandle.class);
        OperatorSubtaskState operatorSubtaskState = (OperatorSubtaskState)Mockito.spy((Object)new OperatorSubtaskState(managedOpHandle, rawOpHandle, managedKeyedHandle, rawKeyedHandle));
        TaskStateSnapshot subtaskState = (TaskStateSnapshot)Mockito.spy((Object)new TaskStateSnapshot());
        subtaskState.putSubtaskStateByOperatorID(new OperatorID(), operatorSubtaskState);
        Mockito.when((Object)subtaskState.getSubtaskStateByOperatorID(OperatorID.fromJobVertexID((JobVertexID)vertex.getJobvertexId()))).thenReturn((Object)operatorSubtaskState);
        AcknowledgeCheckpoint acknowledgeMessage = new AcknowledgeCheckpoint(jid, executionAttemptId, checkpointId, new CheckpointMetrics(), subtaskState);
        try {
            coord.receiveAcknowledgeMessage(acknowledgeMessage);
            Assert.fail((String)"Expected a checkpoint exception because the completed checkpoint store could not store the completed checkpoint.");
        }
        catch (CheckpointException checkpointException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)pendingCheckpoint.isDiscarded());
        ((OperatorSubtaskState)Mockito.verify((Object)operatorSubtaskState)).discardState();
        ((OperatorStateHandle)Mockito.verify(operatorSubtaskState.getManagedOperatorState().iterator().next())).discardState();
        ((OperatorStateHandle)Mockito.verify(operatorSubtaskState.getRawOperatorState().iterator().next())).discardState();
        ((KeyedStateHandle)Mockito.verify(operatorSubtaskState.getManagedKeyedState().iterator().next())).discardState();
        ((KeyedStateHandle)Mockito.verify(operatorSubtaskState.getRawKeyedState().iterator().next())).discardState();
    }

    private static final class FailingCompletedCheckpointStore
    implements CompletedCheckpointStore {
        private FailingCompletedCheckpointStore() {
        }

        public void recover() throws Exception {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void addCheckpoint(CompletedCheckpoint checkpoint) throws Exception {
            throw new Exception("The failing completed checkpoint store failed again... :-(");
        }

        public CompletedCheckpoint getLatestCheckpoint() throws Exception {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void shutdown(JobStatus jobStatus) throws Exception {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public List<CompletedCheckpoint> getAllCheckpoints() throws Exception {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public int getNumberOfRetainedCheckpoints() {
            return -1;
        }

        public int getMaxNumberOfRetainedCheckpoints() {
            return 1;
        }

        public boolean requiresExternalizedCheckpoints() {
            return false;
        }
    }
}

