/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.util.InstantiationUtil;
import org.junit.Assert;
import org.junit.Test;

public class CheckpointPropertiesTest {
    @Test
    public void testCheckpointProperties() {
        CheckpointProperties props = CheckpointProperties.forStandardCheckpoint();
        Assert.assertFalse((boolean)props.forceCheckpoint());
        Assert.assertFalse((boolean)props.externalizeCheckpoint());
        Assert.assertTrue((boolean)props.discardOnSubsumed());
        Assert.assertTrue((boolean)props.discardOnJobFinished());
        Assert.assertTrue((boolean)props.discardOnJobCancelled());
        Assert.assertTrue((boolean)props.discardOnJobFailed());
        Assert.assertTrue((boolean)props.discardOnJobSuspended());
    }

    @Test
    public void testExternalizedCheckpointProperties() {
        CheckpointProperties props = CheckpointProperties.forExternalizedCheckpoint((boolean)true);
        Assert.assertFalse((boolean)props.forceCheckpoint());
        Assert.assertTrue((boolean)props.externalizeCheckpoint());
        Assert.assertTrue((boolean)props.discardOnSubsumed());
        Assert.assertTrue((boolean)props.discardOnJobFinished());
        Assert.assertTrue((boolean)props.discardOnJobCancelled());
        Assert.assertFalse((boolean)props.discardOnJobFailed());
        Assert.assertTrue((boolean)props.discardOnJobSuspended());
        props = CheckpointProperties.forExternalizedCheckpoint((boolean)false);
        Assert.assertFalse((boolean)props.forceCheckpoint());
        Assert.assertTrue((boolean)props.externalizeCheckpoint());
        Assert.assertTrue((boolean)props.discardOnSubsumed());
        Assert.assertTrue((boolean)props.discardOnJobFinished());
        Assert.assertFalse((boolean)props.discardOnJobCancelled());
        Assert.assertFalse((boolean)props.discardOnJobFailed());
        Assert.assertFalse((boolean)props.discardOnJobSuspended());
    }

    @Test
    public void testSavepointProperties() {
        CheckpointProperties props = CheckpointProperties.forStandardSavepoint();
        Assert.assertTrue((boolean)props.forceCheckpoint());
        Assert.assertTrue((boolean)props.externalizeCheckpoint());
        Assert.assertFalse((boolean)props.discardOnSubsumed());
        Assert.assertFalse((boolean)props.discardOnJobFinished());
        Assert.assertFalse((boolean)props.discardOnJobCancelled());
        Assert.assertFalse((boolean)props.discardOnJobFailed());
        Assert.assertFalse((boolean)props.discardOnJobSuspended());
    }

    @Test
    public void testIsSavepoint() throws Exception {
        CheckpointProperties props = CheckpointProperties.forStandardCheckpoint();
        Assert.assertFalse((boolean)props.isSavepoint());
        props = CheckpointProperties.forExternalizedCheckpoint((boolean)true);
        Assert.assertFalse((boolean)props.isSavepoint());
        props = CheckpointProperties.forExternalizedCheckpoint((boolean)false);
        Assert.assertFalse((boolean)props.isSavepoint());
        props = CheckpointProperties.forStandardSavepoint();
        Assert.assertTrue((boolean)props.isSavepoint());
        CheckpointProperties deserializedCheckpointProperties = (CheckpointProperties)InstantiationUtil.deserializeObject((byte[])InstantiationUtil.serializeObject((Object)props), (ClassLoader)this.getClass().getClassLoader());
        Assert.assertTrue((boolean)deserializedCheckpointProperties.isSavepoint());
    }
}

