/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CompletedCheckpointTest {
    @Rule
    public final TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testDiscard() throws Exception {
        File file = this.tmpFolder.newFile();
        Assert.assertEquals((Object)true, (Object)file.exists());
        OperatorState state = (OperatorState)Mockito.mock(OperatorState.class);
        HashMap<OperatorID, OperatorState> taskStates = new HashMap<OperatorID, OperatorState>();
        taskStates.put(new OperatorID(), state);
        CompletedCheckpoint checkpoint = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, taskStates, Collections.emptyList(), CheckpointProperties.forStandardCheckpoint(), (StreamStateHandle)new FileStateHandle(new Path(file.toURI()), file.length()), file.getAbsolutePath());
        checkpoint.discardOnShutdown(JobStatus.FAILED);
        Assert.assertEquals((Object)false, (Object)file.exists());
    }

    @Test
    public void testCleanUpOnSubsume() throws Exception {
        OperatorState state = (OperatorState)Mockito.mock(OperatorState.class);
        HashMap<OperatorID, OperatorState> operatorStates = new HashMap<OperatorID, OperatorState>();
        operatorStates.put(new OperatorID(), state);
        boolean discardSubsumed = true;
        CheckpointProperties props = new CheckpointProperties(false, false, false, discardSubsumed, true, true, true, true);
        CompletedCheckpoint checkpoint = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, operatorStates, Collections.emptyList(), props, null, null);
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        checkpoint.registerSharedStatesAfterRestored(sharedStateRegistry);
        ((OperatorState)Mockito.verify((Object)state, (VerificationMode)Mockito.times((int)1))).registerSharedStates(sharedStateRegistry);
        checkpoint.discardOnSubsume();
        ((OperatorState)Mockito.verify((Object)state, (VerificationMode)Mockito.times((int)1))).discardState();
    }

    @Test
    public void testCleanUpOnShutdown() throws Exception {
        File file = this.tmpFolder.newFile();
        String externalPath = file.getAbsolutePath();
        JobStatus[] terminalStates = new JobStatus[]{JobStatus.FINISHED, JobStatus.CANCELED, JobStatus.FAILED, JobStatus.SUSPENDED};
        OperatorState state = (OperatorState)Mockito.mock(OperatorState.class);
        HashMap<OperatorID, OperatorState> operatorStates = new HashMap<OperatorID, OperatorState>();
        operatorStates.put(new OperatorID(), state);
        for (JobStatus status : terminalStates) {
            Mockito.reset((Object[])new OperatorState[]{state});
            CheckpointProperties props = new CheckpointProperties(false, true, false, false, false, false, false, false);
            CompletedCheckpoint checkpoint = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, new HashMap(operatorStates), Collections.emptyList(), props, (StreamStateHandle)new FileStateHandle(new Path(file.toURI()), file.length()), externalPath);
            SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
            checkpoint.registerSharedStatesAfterRestored(sharedStateRegistry);
            checkpoint.discardOnShutdown(status);
            ((OperatorState)Mockito.verify((Object)state, (VerificationMode)Mockito.times((int)0))).discardState();
            Assert.assertEquals((Object)true, (Object)file.exists());
            props = new CheckpointProperties(false, false, false, true, true, true, true, true);
            checkpoint = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, new HashMap(operatorStates), Collections.emptyList(), props, null, null);
            checkpoint.discardOnShutdown(status);
            ((OperatorState)Mockito.verify((Object)state, (VerificationMode)Mockito.times((int)1))).discardState();
        }
    }

    @Test
    public void testCompletedCheckpointStatsCallbacks() throws Exception {
        OperatorState state = (OperatorState)Mockito.mock(OperatorState.class);
        HashMap<OperatorID, OperatorState> operatorStates = new HashMap<OperatorID, OperatorState>();
        operatorStates.put(new OperatorID(), state);
        CompletedCheckpoint completed = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, new HashMap(operatorStates), Collections.emptyList(), CheckpointProperties.forStandardCheckpoint(), null, null);
        CompletedCheckpointStats.DiscardCallback callback = (CompletedCheckpointStats.DiscardCallback)Mockito.mock(CompletedCheckpointStats.DiscardCallback.class);
        completed.setDiscardCallback(callback);
        completed.discardOnShutdown(JobStatus.FINISHED);
        ((CompletedCheckpointStats.DiscardCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).notifyDiscardedCheckpoint();
    }

    @Test
    public void testIsJavaSerializable() throws Exception {
        TaskStateStats task1 = new TaskStateStats(new JobVertexID(), 3);
        TaskStateStats task2 = new TaskStateStats(new JobVertexID(), 4);
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        taskStats.put(task1.getJobVertexId(), task1);
        taskStats.put(task2.getJobVertexId(), task2);
        CompletedCheckpointStats completed = new CompletedCheckpointStats(123123123L, 10123L, CheckpointProperties.forStandardCheckpoint(), 1337, taskStats, 1337, 123129837912L, 123819239812L, new SubtaskStateStats(123, 213123L, 123123L, 0L, 0L, 0L, 0L), null);
        CompletedCheckpointStats copy = (CompletedCheckpointStats)CommonTestUtils.createCopySerializable((Serializable)completed);
        Assert.assertEquals((long)completed.getCheckpointId(), (long)copy.getCheckpointId());
        Assert.assertEquals((long)completed.getTriggerTimestamp(), (long)copy.getTriggerTimestamp());
        Assert.assertEquals((Object)completed.getProperties(), (Object)copy.getProperties());
        Assert.assertEquals((long)completed.getNumberOfSubtasks(), (long)copy.getNumberOfSubtasks());
        Assert.assertEquals((long)completed.getNumberOfAcknowledgedSubtasks(), (long)copy.getNumberOfAcknowledgedSubtasks());
        Assert.assertEquals((long)completed.getEndToEndDuration(), (long)copy.getEndToEndDuration());
        Assert.assertEquals((long)completed.getStateSize(), (long)copy.getStateSize());
        Assert.assertEquals((long)completed.getLatestAcknowledgedSubtaskStats().getSubtaskIndex(), (long)copy.getLatestAcknowledgedSubtaskStats().getSubtaskIndex());
        Assert.assertEquals((Object)completed.getStatus(), (Object)copy.getStatus());
    }
}

