/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStoreTest;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.StandaloneCompletedCheckpointStore;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.junit.Assert;
import org.junit.Test;
import org.powermock.api.mockito.PowerMockito;

public class StandaloneCompletedCheckpointStoreTest
extends CompletedCheckpointStoreTest {
    @Override
    protected CompletedCheckpointStore createCompletedCheckpoints(int maxNumberOfCheckpointsToRetain) throws Exception {
        return new StandaloneCompletedCheckpointStore(maxNumberOfCheckpointsToRetain);
    }

    @Test
    public void testShutdownDiscardsCheckpoints() throws Exception {
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        CompletedCheckpointStore store = this.createCompletedCheckpoints(1);
        CompletedCheckpointStoreTest.TestCompletedCheckpoint checkpoint = this.createCheckpoint(0, sharedStateRegistry);
        Collection<OperatorState> operatorStates = checkpoint.getOperatorStates().values();
        store.addCheckpoint((CompletedCheckpoint)checkpoint);
        Assert.assertEquals((long)1L, (long)store.getNumberOfRetainedCheckpoints());
        this.verifyCheckpointRegistered(operatorStates, sharedStateRegistry);
        store.shutdown(JobStatus.FINISHED);
        Assert.assertEquals((long)0L, (long)store.getNumberOfRetainedCheckpoints());
        Assert.assertTrue((boolean)checkpoint.isDiscarded());
        this.verifyCheckpointDiscarded(operatorStates);
    }

    @Test
    public void testSuspendDiscardsCheckpoints() throws Exception {
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        CompletedCheckpointStore store = this.createCompletedCheckpoints(1);
        CompletedCheckpointStoreTest.TestCompletedCheckpoint checkpoint = this.createCheckpoint(0, sharedStateRegistry);
        Collection<OperatorState> taskStates = checkpoint.getOperatorStates().values();
        store.addCheckpoint((CompletedCheckpoint)checkpoint);
        Assert.assertEquals((long)1L, (long)store.getNumberOfRetainedCheckpoints());
        this.verifyCheckpointRegistered(taskStates, sharedStateRegistry);
        store.shutdown(JobStatus.SUSPENDED);
        Assert.assertEquals((long)0L, (long)store.getNumberOfRetainedCheckpoints());
        Assert.assertTrue((boolean)checkpoint.isDiscarded());
        this.verifyCheckpointDiscarded(taskStates);
    }

    @Test
    public void testAddCheckpointWithFailedRemove() throws Exception {
        boolean numCheckpointsToRetain = true;
        CompletedCheckpointStore store = this.createCompletedCheckpoints(1);
        for (long i = 0L; i <= 1L; ++i) {
            CompletedCheckpoint checkpointToAdd = (CompletedCheckpoint)PowerMockito.mock(CompletedCheckpoint.class);
            ((CompletedCheckpoint)PowerMockito.doReturn((Object)i).when((Object)checkpointToAdd)).getCheckpointID();
            ((CompletedCheckpoint)PowerMockito.doReturn(Collections.emptyMap()).when((Object)checkpointToAdd)).getOperatorStates();
            ((CompletedCheckpoint)PowerMockito.doThrow((Throwable)new IOException()).when((Object)checkpointToAdd)).discardOnSubsume();
            try {
                store.addCheckpoint(checkpointToAdd);
                List addedCheckpoints = store.getAllCheckpoints();
                Assert.assertTrue((boolean)addedCheckpoints.contains(checkpointToAdd));
                continue;
            }
            catch (Exception e) {
                List addedCheckpoints = store.getAllCheckpoints();
                Assert.assertFalse((boolean)addedCheckpoints.contains(checkpointToAdd));
            }
        }
    }
}

