/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.SubtaskState;
import org.apache.flink.runtime.checkpoint.TaskState;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.ChainedStateHandle;
import org.apache.flink.runtime.state.IncrementalKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeOffsets;
import org.apache.flink.runtime.state.KeyGroupsStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.util.TestByteStreamStateHandleDeepCompare;
import org.apache.flink.util.StringUtils;
import org.junit.Assert;

public class CheckpointTestUtils {
    public static Collection<OperatorState> createOperatorStates(int numTaskStates, int numSubtasksPerTask) {
        return CheckpointTestUtils.createOperatorStates(new Random(), numTaskStates, numSubtasksPerTask);
    }

    public static Collection<OperatorState> createOperatorStates(Random random, int numTaskStates, int numSubtasksPerTask) {
        ArrayList<OperatorState> taskStates = new ArrayList<OperatorState>(numTaskStates);
        for (int stateIdx = 0; stateIdx < numTaskStates; ++stateIdx) {
            OperatorState taskState = new OperatorState(new OperatorID(), numSubtasksPerTask, 128);
            boolean hasOperatorStateBackend = random.nextBoolean();
            boolean hasOperatorStateStream = random.nextBoolean();
            boolean hasKeyedBackend = random.nextInt(4) != 0;
            boolean hasKeyedStream = random.nextInt(4) != 0;
            boolean isIncremental = random.nextInt(3) == 0;
            for (int subtaskIdx = 0; subtaskIdx < numSubtasksPerTask; ++subtaskIdx) {
                TestByteStreamStateHandleDeepCompare operatorStateBackend = new TestByteStreamStateHandleDeepCompare("b", "Beautiful".getBytes(ConfigConstants.DEFAULT_CHARSET));
                TestByteStreamStateHandleDeepCompare operatorStateStream = new TestByteStreamStateHandleDeepCompare("b", "Beautiful".getBytes(ConfigConstants.DEFAULT_CHARSET));
                OperatorStateHandle operatorStateHandleBackend = null;
                OperatorStateHandle operatorStateHandleStream = null;
                HashMap<String, OperatorStateHandle.StateMetaInfo> offsetsMap = new HashMap<String, OperatorStateHandle.StateMetaInfo>();
                offsetsMap.put("A", new OperatorStateHandle.StateMetaInfo(new long[]{0L, 10L, 20L}, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE));
                offsetsMap.put("B", new OperatorStateHandle.StateMetaInfo(new long[]{30L, 40L, 50L}, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE));
                offsetsMap.put("C", new OperatorStateHandle.StateMetaInfo(new long[]{60L, 70L, 80L}, OperatorStateHandle.Mode.BROADCAST));
                if (hasOperatorStateBackend) {
                    operatorStateHandleBackend = new OperatorStateHandle(offsetsMap, (StreamStateHandle)operatorStateBackend);
                }
                if (hasOperatorStateStream) {
                    operatorStateHandleStream = new OperatorStateHandle(offsetsMap, (StreamStateHandle)operatorStateStream);
                }
                Object keyedStateBackend = null;
                KeyGroupsStateHandle keyedStateStream = null;
                if (hasKeyedBackend) {
                    keyedStateBackend = isIncremental ? CheckpointTestUtils.createDummyIncrementalKeyedStateHandle(random) : CheckpointTestUtils.createDummyKeyGroupStateHandle(random);
                }
                if (hasKeyedStream) {
                    keyedStateStream = CheckpointTestUtils.createDummyKeyGroupStateHandle(random);
                }
                taskState.putState(subtaskIdx, new OperatorSubtaskState(operatorStateHandleBackend, operatorStateHandleStream, (KeyedStateHandle)keyedStateStream, (KeyedStateHandle)keyedStateBackend));
            }
            taskStates.add(taskState);
        }
        return taskStates;
    }

    public static Collection<TaskState> createTaskStates(int numTaskStates, int numSubtasksPerTask) {
        return CheckpointTestUtils.createTaskStates(new Random(), numTaskStates, numSubtasksPerTask);
    }

    public static Collection<TaskState> createTaskStates(Random random, int numTaskStates, int numSubtasksPerTask) {
        ArrayList<TaskState> taskStates = new ArrayList<TaskState>(numTaskStates);
        for (int stateIdx = 0; stateIdx < numTaskStates; ++stateIdx) {
            int chainLength = 1 + random.nextInt(8);
            TaskState taskState = new TaskState(new JobVertexID(), numSubtasksPerTask, 128, chainLength);
            int noNonPartitionableStateAtIndex = random.nextInt(chainLength);
            int noOperatorStateBackendAtIndex = random.nextInt(chainLength);
            int noOperatorStateStreamAtIndex = random.nextInt(chainLength);
            boolean hasKeyedBackend = random.nextInt(4) != 0;
            boolean hasKeyedStream = random.nextInt(4) != 0;
            for (int subtaskIdx = 0; subtaskIdx < numSubtasksPerTask; ++subtaskIdx) {
                ArrayList<OperatorStateHandle> operatorStatesBackend = new ArrayList<OperatorStateHandle>(chainLength);
                ArrayList<OperatorStateHandle> operatorStatesStream = new ArrayList<OperatorStateHandle>(chainLength);
                for (int chainIdx = 0; chainIdx < chainLength; ++chainIdx) {
                    TestByteStreamStateHandleDeepCompare operatorStateBackend = new TestByteStreamStateHandleDeepCompare("b-" + chainIdx, ("Beautiful-" + chainIdx).getBytes(ConfigConstants.DEFAULT_CHARSET));
                    TestByteStreamStateHandleDeepCompare operatorStateStream = new TestByteStreamStateHandleDeepCompare("b-" + chainIdx, ("Beautiful-" + chainIdx).getBytes(ConfigConstants.DEFAULT_CHARSET));
                    HashMap<String, OperatorStateHandle.StateMetaInfo> offsetsMap = new HashMap<String, OperatorStateHandle.StateMetaInfo>();
                    offsetsMap.put("A", new OperatorStateHandle.StateMetaInfo(new long[]{0L, 10L, 20L}, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE));
                    offsetsMap.put("B", new OperatorStateHandle.StateMetaInfo(new long[]{30L, 40L, 50L}, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE));
                    offsetsMap.put("C", new OperatorStateHandle.StateMetaInfo(new long[]{60L, 70L, 80L}, OperatorStateHandle.Mode.BROADCAST));
                    if (chainIdx != noOperatorStateBackendAtIndex) {
                        OperatorStateHandle operatorStateHandleBackend = new OperatorStateHandle(offsetsMap, (StreamStateHandle)operatorStateBackend);
                        operatorStatesBackend.add(operatorStateHandleBackend);
                    }
                    if (chainIdx == noOperatorStateStreamAtIndex) continue;
                    OperatorStateHandle operatorStateHandleStream = new OperatorStateHandle(offsetsMap, (StreamStateHandle)operatorStateStream);
                    operatorStatesStream.add(operatorStateHandleStream);
                }
                KeyGroupsStateHandle keyedStateBackend = null;
                KeyGroupsStateHandle keyedStateStream = null;
                if (hasKeyedBackend) {
                    keyedStateBackend = CheckpointTestUtils.createDummyKeyGroupStateHandle(random);
                }
                if (hasKeyedStream) {
                    keyedStateStream = CheckpointTestUtils.createDummyKeyGroupStateHandle(random);
                }
                taskState.putState(subtaskIdx, new SubtaskState(new ChainedStateHandle(operatorStatesBackend), new ChainedStateHandle(operatorStatesStream), (KeyedStateHandle)keyedStateStream, (KeyedStateHandle)keyedStateBackend));
            }
            taskStates.add(taskState);
        }
        return taskStates;
    }

    public static Collection<MasterState> createRandomMasterStates(Random random, int num) {
        ArrayList<MasterState> states = new ArrayList<MasterState>(num);
        for (int i = 0; i < num; ++i) {
            int version = random.nextInt(10);
            String name = StringUtils.getRandomString((Random)random, (int)5, (int)500);
            byte[] bytes = new byte[random.nextInt(5000) + 1];
            random.nextBytes(bytes);
            states.add(new MasterState(name, bytes, version));
        }
        return states;
    }

    public static void assertMasterStateEquality(MasterState a, MasterState b) {
        Assert.assertEquals((long)a.version(), (long)b.version());
        Assert.assertEquals((Object)a.name(), (Object)b.name());
        Assert.assertArrayEquals((byte[])a.bytes(), (byte[])b.bytes());
    }

    private CheckpointTestUtils() {
    }

    public static IncrementalKeyedStateHandle createDummyIncrementalKeyedStateHandle(Random rnd) {
        return new IncrementalKeyedStateHandle(CheckpointTestUtils.createRandomUUID(rnd), new KeyGroupRange(1, 1), 42L, CheckpointTestUtils.createRandomStateHandleMap(rnd), CheckpointTestUtils.createRandomStateHandleMap(rnd), CheckpointTestUtils.createDummyStreamStateHandle(rnd));
    }

    public static Map<StateHandleID, StreamStateHandle> createRandomStateHandleMap(Random rnd) {
        int size = rnd.nextInt(4);
        HashMap<StateHandleID, StreamStateHandle> result = new HashMap<StateHandleID, StreamStateHandle>(size);
        for (int i = 0; i < size; ++i) {
            StateHandleID randomId = new StateHandleID(CheckpointTestUtils.createRandomUUID(rnd).toString());
            StreamStateHandle stateHandle = CheckpointTestUtils.createDummyStreamStateHandle(rnd);
            result.put(randomId, stateHandle);
        }
        return result;
    }

    public static KeyGroupsStateHandle createDummyKeyGroupStateHandle(Random rnd) {
        return new KeyGroupsStateHandle(new KeyGroupRangeOffsets(1, 1, new long[]{rnd.nextInt(1024)}), CheckpointTestUtils.createDummyStreamStateHandle(rnd));
    }

    public static StreamStateHandle createDummyStreamStateHandle(Random rnd) {
        return new TestByteStreamStateHandleDeepCompare(String.valueOf(CheckpointTestUtils.createRandomUUID(rnd)), String.valueOf(CheckpointTestUtils.createRandomUUID(rnd)).getBytes(ConfigConstants.DEFAULT_CHARSET));
    }

    private static UUID createRandomUUID(Random rnd) {
        return new UUID(rnd.nextLong(), rnd.nextLong());
    }
}

