/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.TaskState;
import org.apache.flink.runtime.checkpoint.savepoint.CheckpointTestUtils;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointSerializer;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointSerializers;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointStore;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV2;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class SavepointStoreTest {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    @Test
    public void testStoreLoadDispose() throws Exception {
        String root = this.tmp.getRoot().getAbsolutePath();
        File rootFile = new File(root);
        File[] list = rootFile.listFiles();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)0L, (long)list.length);
        String savepointDirectory = SavepointStore.createSavepointDirectory((String)root, (JobID)new JobID());
        SavepointV2 stored = new SavepointV2(1929292L, CheckpointTestUtils.createOperatorStates(4, 24), Collections.emptyList());
        String path = SavepointStore.storeSavepoint((String)savepointDirectory, (Savepoint)stored);
        list = rootFile.listFiles();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.length);
        Savepoint loaded = SavepointStore.loadSavepoint((String)path, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Assert.assertEquals((long)stored.getCheckpointId(), (long)loaded.getCheckpointId());
        Assert.assertEquals((Object)stored.getOperatorStates(), (Object)loaded.getOperatorStates());
        Assert.assertEquals((Object)stored.getMasterStates(), (Object)loaded.getMasterStates());
        loaded.dispose();
        SavepointStore.deleteSavepointDirectory((String)path);
        list = rootFile.listFiles();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)0L, (long)list.length);
    }

    @Test
    public void testUnexpectedSavepoint() throws Exception {
        Path filePath = new Path(this.tmp.getRoot().getPath(), UUID.randomUUID().toString());
        FSDataOutputStream fdos = FileSystem.get((URI)filePath.toUri()).create(filePath, FileSystem.WriteMode.NO_OVERWRITE);
        DataOutputStream dos = new DataOutputStream((OutputStream)fdos);
        for (int i = 0; i < 10; ++i) {
            dos.writeLong(ThreadLocalRandom.current().nextLong());
        }
        try {
            SavepointStore.loadSavepoint((String)filePath.toString(), (ClassLoader)Thread.currentThread().getContextClassLoader());
            Assert.fail((String)"Did not throw expected Exception");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((e.getMessage().contains("Flink 1.0") && e.getMessage().contains("Unexpected magic number") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultipleSavepointVersions() throws Exception {
        Field field = SavepointSerializers.class.getDeclaredField("SERIALIZERS");
        field.setAccessible(true);
        Map serializers = (Map)field.get(null);
        Assert.assertTrue((serializers.size() >= 1 ? 1 : 0) != 0);
        String root = this.tmp.getRoot().getAbsolutePath();
        File rootFile = new File(root);
        int version = ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
        long checkpointId = ThreadLocalRandom.current().nextLong(Long.MAX_VALUE);
        serializers.put(version, NewSavepointSerializer.INSTANCE);
        String savepointDirectory1 = SavepointStore.createSavepointDirectory((String)root, (JobID)new JobID());
        TestSavepoint newSavepoint = new TestSavepoint(version, checkpointId);
        String pathNewSavepoint = SavepointStore.storeSavepoint((String)savepointDirectory1, (Savepoint)newSavepoint);
        File[] list = rootFile.listFiles();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.length);
        String savepointDirectory2 = SavepointStore.createSavepointDirectory((String)root, (JobID)new JobID());
        SavepointV2 savepoint = new SavepointV2(checkpointId, CheckpointTestUtils.createOperatorStates(4, 32), Collections.emptyList());
        String pathSavepoint = SavepointStore.storeSavepoint((String)savepointDirectory2, (Savepoint)savepoint);
        list = rootFile.listFiles();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)2L, (long)list.length);
        Savepoint loaded = SavepointStore.loadSavepoint((String)pathNewSavepoint, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Assert.assertEquals((Object)newSavepoint, (Object)loaded);
        loaded = SavepointStore.loadSavepoint((String)pathSavepoint, (ClassLoader)Thread.currentThread().getContextClassLoader());
        Assert.assertEquals((long)savepoint.getCheckpointId(), (long)loaded.getCheckpointId());
        Assert.assertEquals((Object)savepoint.getTaskStates(), (Object)loaded.getTaskStates());
        Assert.assertEquals((Object)savepoint.getMasterStates(), (Object)loaded.getMasterStates());
    }

    @Test
    public void testCleanupOnStoreFailure() throws Exception {
        Field field = SavepointSerializers.class.getDeclaredField("SERIALIZERS");
        field.setAccessible(true);
        Map serializers = (Map)field.get(null);
        String target = this.tmp.getRoot().getAbsolutePath();
        int version = 123123;
        SavepointSerializer serializer = (SavepointSerializer)Mockito.mock(SavepointSerializer.class);
        ((SavepointSerializer)Mockito.doThrow((Throwable)new RuntimeException("Test Exception")).when((Object)serializer)).serialize((Savepoint)Matchers.any(TestSavepoint.class), (DataOutputStream)Matchers.any(DataOutputStream.class));
        serializers.put(123123, serializer);
        TestSavepoint savepoint = new TestSavepoint(123123, 12123123L);
        Assert.assertEquals((long)0L, (long)this.tmp.getRoot().listFiles().length);
        try {
            SavepointStore.storeSavepoint((String)target, (Savepoint)savepoint);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertEquals((String)"Savepoint file not cleaned up on failure", (long)0L, (long)this.tmp.getRoot().listFiles().length);
    }

    @Test
    public void testStoreExternalizedCheckpointsToSameDirectory() throws Exception {
        String root = this.tmp.newFolder().getAbsolutePath();
        FileSystem fs = FileSystem.get((URI)new Path(root).toUri());
        SavepointV2 savepoint = new SavepointV2(1929292L, CheckpointTestUtils.createOperatorStates(4, 24), Collections.emptyList());
        FileStateHandle store1 = SavepointStore.storeExternalizedCheckpointToHandle((String)root, (Savepoint)savepoint);
        fs.exists(store1.getFilePath());
        Assert.assertTrue((boolean)store1.getFilePath().getPath().contains("checkpoint_metadata-"));
        FileStateHandle store2 = SavepointStore.storeExternalizedCheckpointToHandle((String)root, (Savepoint)savepoint);
        fs.exists(store2.getFilePath());
        Assert.assertTrue((boolean)store2.getFilePath().getPath().contains("checkpoint_metadata-"));
    }

    private static class TestSavepoint
    implements Savepoint {
        private final int version;
        private final long checkpointId;

        public TestSavepoint(int version, long checkpointId) {
            this.version = version;
            this.checkpointId = checkpointId;
        }

        public int getVersion() {
            return this.version;
        }

        public long getCheckpointId() {
            return this.checkpointId;
        }

        public Collection<TaskState> getTaskStates() {
            return Collections.emptyList();
        }

        public Collection<MasterState> getMasterStates() {
            return Collections.emptyList();
        }

        public Collection<OperatorState> getOperatorStates() {
            return null;
        }

        public void dispose() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestSavepoint that = (TestSavepoint)o;
            return this.version == that.version && this.checkpointId == that.checkpointId;
        }

        public int hashCode() {
            int result = this.version;
            result = 31 * result + (int)(this.checkpointId ^ this.checkpointId >>> 32);
            return result;
        }
    }

    private static class NewSavepointSerializer
    implements SavepointSerializer<TestSavepoint> {
        private static final NewSavepointSerializer INSTANCE = new NewSavepointSerializer();

        private NewSavepointSerializer() {
        }

        public void serialize(TestSavepoint savepoint, DataOutputStream dos) throws IOException {
            dos.writeInt(savepoint.version);
            dos.writeLong(savepoint.checkpointId);
        }

        public TestSavepoint deserialize(DataInputStream dis, ClassLoader userCL) throws IOException {
            int version = dis.readInt();
            long checkpointId = dis.readLong();
            return new TestSavepoint(version, checkpointId);
        }
    }
}

