/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.File;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.ContainerOverlayTestBase;
import org.apache.flink.runtime.clusterframework.overlays.KeytabOverlay;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class KeytabOverlayTest
extends ContainerOverlayTestBase {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testConfigure() throws Exception {
        File keytab = this.tempFolder.newFile();
        KeytabOverlay overlay = new KeytabOverlay(keytab);
        ContainerSpecification spec = new ContainerSpecification();
        overlay.configure(spec);
        Assert.assertEquals((Object)KeytabOverlay.TARGET_PATH.getPath(), (Object)spec.getDynamicConfiguration().getString(SecurityOptions.KERBEROS_LOGIN_KEYTAB));
        KeytabOverlayTest.checkArtifact(spec, KeytabOverlay.TARGET_PATH);
    }

    @Test
    public void testNoConf() throws Exception {
        KeytabOverlay overlay = new KeytabOverlay((Path)null);
        ContainerSpecification containerSpecification = new ContainerSpecification();
        overlay.configure(containerSpecification);
    }

    @Test
    public void testBuilderFromEnvironment() throws Exception {
        Configuration conf = new Configuration();
        File keytab = this.tempFolder.newFile();
        conf.setString(SecurityOptions.KERBEROS_LOGIN_KEYTAB, keytab.getAbsolutePath());
        KeytabOverlay.Builder builder = KeytabOverlay.newBuilder().fromEnvironment(conf);
        Assert.assertEquals((Object)builder.keytabPath, (Object)keytab);
    }
}

