/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ConjunctFutureTest
extends TestLogger {
    @Parameterized.Parameter
    public FutureFactory futureFactory;

    @Parameterized.Parameters
    public static Collection<FutureFactory> parameters() {
        return Arrays.asList(new ConjunctFutureFactory(), new WaitingFutureFactory());
    }

    @Test
    public void testConjunctFutureFailsOnEmptyAndNull() throws Exception {
        try {
            this.futureFactory.createFuture(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.futureFactory.createFuture(Arrays.asList(new CompletableFuture(), null, new CompletableFuture()));
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testConjunctFutureCompletion() throws Exception {
        CompletableFuture<Object> future1 = new CompletableFuture<Object>();
        CompletableFuture<Object> future2 = new CompletableFuture<Object>();
        CompletableFuture<Object> future3 = new CompletableFuture<Object>();
        CompletableFuture<Object> future4 = new CompletableFuture<Object>();
        future2.complete(new Object());
        FutureUtils.ConjunctFuture<?> result = this.futureFactory.createFuture(Arrays.asList(future1, future2, future3, future4));
        CompletableFuture resultMapped = result.thenAccept(value -> {});
        Assert.assertEquals((long)4L, (long)result.getNumFuturesTotal());
        Assert.assertEquals((long)1L, (long)result.getNumFuturesCompleted());
        Assert.assertFalse((boolean)result.isDone());
        Assert.assertFalse((boolean)resultMapped.isDone());
        future4.complete(new Object());
        Assert.assertEquals((long)2L, (long)result.getNumFuturesCompleted());
        Assert.assertFalse((boolean)result.isDone());
        Assert.assertFalse((boolean)resultMapped.isDone());
        future1.complete(new Object());
        Assert.assertEquals((long)3L, (long)result.getNumFuturesCompleted());
        Assert.assertFalse((boolean)result.isDone());
        Assert.assertFalse((boolean)resultMapped.isDone());
        future1.complete(new Object());
        Assert.assertEquals((long)3L, (long)result.getNumFuturesCompleted());
        Assert.assertFalse((boolean)result.isDone());
        Assert.assertFalse((boolean)resultMapped.isDone());
        future3.complete(new Object());
        Assert.assertEquals((long)4L, (long)result.getNumFuturesCompleted());
        Assert.assertTrue((boolean)result.isDone());
        Assert.assertTrue((boolean)resultMapped.isDone());
    }

    @Test
    public void testConjunctFutureFailureOnFirst() throws Exception {
        CompletableFuture future1 = new CompletableFuture();
        CompletableFuture future2 = new CompletableFuture();
        CompletableFuture future3 = new CompletableFuture();
        CompletableFuture future4 = new CompletableFuture();
        FutureUtils.ConjunctFuture<?> result = this.futureFactory.createFuture(Arrays.asList(future1, future2, future3, future4));
        CompletableFuture resultMapped = result.thenAccept(value -> {});
        Assert.assertEquals((long)4L, (long)result.getNumFuturesTotal());
        Assert.assertEquals((long)0L, (long)result.getNumFuturesCompleted());
        Assert.assertFalse((boolean)result.isDone());
        Assert.assertFalse((boolean)resultMapped.isDone());
        future2.completeExceptionally(new IOException());
        Assert.assertEquals((long)0L, (long)result.getNumFuturesCompleted());
        Assert.assertTrue((boolean)result.isDone());
        Assert.assertTrue((boolean)resultMapped.isDone());
        try {
            result.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
        try {
            resultMapped.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
    }

    @Test
    public void testConjunctFutureFailureOnSuccessive() throws Exception {
        CompletableFuture<Object> future1 = new CompletableFuture<Object>();
        CompletableFuture future2 = new CompletableFuture();
        CompletableFuture<Object> future3 = new CompletableFuture<Object>();
        CompletableFuture<Object> future4 = new CompletableFuture<Object>();
        FutureUtils.ConjunctFuture<?> result = this.futureFactory.createFuture(Arrays.asList(future1, future2, future3, future4));
        Assert.assertEquals((long)4L, (long)result.getNumFuturesTotal());
        CompletableFuture resultMapped = result.thenAccept(value -> {});
        future1.complete(new Object());
        future3.complete(new Object());
        future4.complete(new Object());
        future2.completeExceptionally(new IOException());
        Assert.assertEquals((long)3L, (long)result.getNumFuturesCompleted());
        Assert.assertTrue((boolean)result.isDone());
        Assert.assertTrue((boolean)resultMapped.isDone());
        try {
            result.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
        try {
            resultMapped.get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
    }

    @Test
    public void testConjunctFutureValue() throws ExecutionException, InterruptedException {
        CompletableFuture<Integer> future1 = CompletableFuture.completedFuture(1);
        CompletableFuture<Long> future2 = CompletableFuture.completedFuture(2L);
        CompletableFuture<Double> future3 = new CompletableFuture<Double>();
        FutureUtils.ConjunctFuture result = FutureUtils.combineAll(Arrays.asList(future1, future2, future3));
        Assert.assertFalse((boolean)result.isDone());
        future3.complete(0.1);
        Assert.assertTrue((boolean)result.isDone());
        Assert.assertThat((Object)result.get(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Number[]{1, 2L, 0.1}));
    }

    @Test
    public void testConjunctOfNone() throws Exception {
        FutureUtils.ConjunctFuture<?> result = this.futureFactory.createFuture(Collections.emptyList());
        Assert.assertEquals((long)0L, (long)result.getNumFuturesTotal());
        Assert.assertEquals((long)0L, (long)result.getNumFuturesCompleted());
        Assert.assertTrue((boolean)result.isDone());
    }

    private static class WaitingFutureFactory
    implements FutureFactory {
        private WaitingFutureFactory() {
        }

        @Override
        public FutureUtils.ConjunctFuture<?> createFuture(Collection<? extends CompletableFuture<?>> futures) {
            return FutureUtils.waitForAll(futures);
        }
    }

    private static class ConjunctFutureFactory
    implements FutureFactory {
        private ConjunctFutureFactory() {
        }

        @Override
        public FutureUtils.ConjunctFuture<?> createFuture(Collection<? extends CompletableFuture<?>> futures) {
            return FutureUtils.combineAll(futures);
        }
    }

    private static interface FutureFactory {
        public FutureUtils.ConjunctFuture<?> createFuture(Collection<? extends CompletableFuture<?>> var1);
    }
}

