/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.PermanentBlobCache;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.executiongraph.ExecutionGraphDeploymentWithBlobServerTest;
import org.junit.After;
import org.junit.Before;

public class ExecutionGraphDeploymentWithBlobCacheTest
extends ExecutionGraphDeploymentWithBlobServerTest {
    @Override
    @Before
    public void setupBlobServer() throws IOException {
        Configuration config = new Configuration();
        config.setInteger(BlobServerOptions.OFFLOAD_MINSIZE, 0);
        this.blobServer = new BlobServer(config, (BlobStore)new VoidBlobStore());
        this.blobServer.start();
        this.blobWriter = this.blobServer;
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", this.blobServer.getPort());
        this.blobCache = new PermanentBlobCache(serverAddress, config, (BlobView)new VoidBlobStore());
    }

    @Override
    @After
    public void shutdownBlobServer() throws IOException {
        if (this.blobServer != null) {
            this.blobServer.close();
        }
    }
}

