/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@PrepareForTest(value={ResultPartitionWriter.class})
@RunWith(value=PowerMockRunner.class)
public class ResultPartitionWriterTest {
    @Test
    public void testWriteBufferToAllChannelsReferenceCounting() throws Exception {
        Buffer buffer = EventSerializer.toBuffer((AbstractEvent)EndOfPartitionEvent.INSTANCE);
        ResultPartition partition = new ResultPartition("TestTask", (TaskActions)Mockito.mock(TaskActions.class), new JobID(), new ResultPartitionID(), ResultPartitionType.PIPELINED, 2, 2, (ResultPartitionManager)Mockito.mock(ResultPartitionManager.class), (ResultPartitionConsumableNotifier)Mockito.mock(ResultPartitionConsumableNotifier.class), (IOManager)Mockito.mock(IOManager.class), false);
        ResultPartitionWriter partitionWriter = new ResultPartitionWriter(partition);
        partitionWriter.writeBufferToAllChannels(buffer);
        Assert.assertEquals((long)2L, (long)partition.getTotalNumberOfBuffers());
        partition.release();
        Assert.assertTrue((boolean)buffer.isRecycled());
    }
}

