/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class NetworkBufferPoolTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testCreatePoolAfterDestroy() {
        try {
            int bufferSize = 128;
            int numBuffers = 10;
            NetworkBufferPool globalPool = new NetworkBufferPool(10, 128, MemoryType.HEAP);
            Assert.assertEquals((long)128L, (long)globalPool.getMemorySegmentSize());
            Assert.assertEquals((long)10L, (long)globalPool.getTotalNumberOfMemorySegments());
            Assert.assertEquals((long)10L, (long)globalPool.getNumberOfAvailableMemorySegments());
            Assert.assertEquals((long)0L, (long)globalPool.getNumberOfRegisteredBufferPools());
            globalPool.destroy();
            Assert.assertTrue((boolean)globalPool.isDestroyed());
            try {
                globalPool.createBufferPool(2, 2);
                Assert.fail((String)"Should throw an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                globalPool.createBufferPool(2, 10);
                Assert.fail((String)"Should throw an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                globalPool.createBufferPool(2, Integer.MAX_VALUE);
                Assert.fail((String)"Should throw an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDestroyAll() {
        try {
            NetworkBufferPool globalPool = new NetworkBufferPool(10, 128, MemoryType.HEAP);
            BufferPool fixedPool = globalPool.createBufferPool(2, 2);
            BufferPool boundedPool = globalPool.createBufferPool(0, 1);
            BufferPool nonFixedPool = globalPool.createBufferPool(5, Integer.MAX_VALUE);
            Assert.assertEquals((long)2L, (long)fixedPool.getNumberOfRequiredMemorySegments());
            Assert.assertEquals((long)0L, (long)boundedPool.getNumberOfRequiredMemorySegments());
            Assert.assertEquals((long)5L, (long)nonFixedPool.getNumberOfRequiredMemorySegments());
            ArrayList<Buffer> buffers = new ArrayList<Buffer>(globalPool.getTotalNumberOfMemorySegments());
            block8: for (int i = 0; i < 10; ++i) {
                for (BufferPool bp : new BufferPool[]{fixedPool, boundedPool, nonFixedPool}) {
                    Buffer buffer = bp.requestBuffer();
                    if (buffer == null) continue;
                    Assert.assertNotNull((Object)buffer.getMemorySegment());
                    buffers.add(buffer);
                    continue block8;
                }
            }
            Assert.assertEquals((long)globalPool.getTotalNumberOfMemorySegments(), (long)buffers.size());
            Assert.assertNull((Object)fixedPool.requestBuffer());
            Assert.assertNull((Object)boundedPool.requestBuffer());
            Assert.assertNull((Object)nonFixedPool.requestBuffer());
            globalPool.destroyAllBufferPools();
            Assert.assertFalse((boolean)globalPool.isDestroyed());
            Assert.assertTrue((boolean)fixedPool.isDestroyed());
            Assert.assertTrue((boolean)boundedPool.isDestroyed());
            Assert.assertTrue((boolean)nonFixedPool.isDestroyed());
            Assert.assertEquals((long)0L, (long)globalPool.getNumberOfRegisteredBufferPools());
            Assert.assertEquals((long)0L, (long)globalPool.getNumberOfAvailableMemorySegments());
            for (Buffer b : buffers) {
                b.recycle();
            }
            Assert.assertEquals((long)globalPool.getTotalNumberOfMemorySegments(), (long)globalPool.getNumberOfAvailableMemorySegments());
            try {
                fixedPool.requestBuffer();
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                boundedPool.requestBuffer();
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                nonFixedPool.requestBuffer();
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertNotNull((Object)globalPool.createBufferPool(10, Integer.MAX_VALUE));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestMemorySegmentsLessThanTotalBuffers() throws Exception {
        int numBuffers = 10;
        NetworkBufferPool globalPool = new NetworkBufferPool(10, 128, MemoryType.HEAP);
        List memorySegments = Collections.emptyList();
        try {
            memorySegments = globalPool.requestMemorySegments(5);
            Assert.assertEquals((long)memorySegments.size(), (long)5L);
            globalPool.recycleMemorySegments(memorySegments);
            memorySegments.clear();
            Assert.assertEquals((long)globalPool.getNumberOfAvailableMemorySegments(), (long)10L);
        }
        finally {
            globalPool.recycleMemorySegments(memorySegments);
            globalPool.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestMemorySegmentsMoreThanTotalBuffers() throws Exception {
        int numBuffers = 10;
        NetworkBufferPool globalPool = new NetworkBufferPool(10, 128, MemoryType.HEAP);
        try {
            globalPool.requestMemorySegments(11);
            Assert.fail((String)"Should throw an IOException");
        }
        catch (IOException e) {
            Assert.assertEquals((long)globalPool.getNumberOfAvailableMemorySegments(), (long)10L);
        }
        finally {
            globalPool.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestMemorySegmentsWithInvalidArgument() throws Exception {
        int numBuffers = 10;
        NetworkBufferPool globalPool = new NetworkBufferPool(10, 128, MemoryType.HEAP);
        try {
            globalPool.requestMemorySegments(0);
            Assert.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((long)globalPool.getNumberOfAvailableMemorySegments(), (long)10L);
        }
        finally {
            globalPool.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestMemorySegmentsWithBuffersTaken() throws IOException, InterruptedException {
        BufferPool lbp1;
        List memorySegments;
        NetworkBufferPool networkBufferPool;
        block6: {
            int numBuffers = 10;
            networkBufferPool = new NetworkBufferPool(10, 128, MemoryType.HEAP);
            ArrayList<Buffer> buffers = new ArrayList<Buffer>(10);
            memorySegments = Collections.emptyList();
            Thread bufferRecycler = null;
            lbp1 = null;
            try {
                lbp1 = networkBufferPool.createBufferPool(5, 10);
                for (int i = 0; i < 10; ++i) {
                    Buffer buffer = lbp1.requestBuffer();
                    buffers.add(buffer);
                    Assert.assertNotNull((Object)buffer);
                }
                OneShotLatch isRunning = new OneShotLatch();
                bufferRecycler = new Thread(() -> {
                    try {
                        isRunning.trigger();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    for (Buffer buffer : buffers) {
                        buffer.recycle();
                    }
                });
                bufferRecycler.start();
                isRunning.await();
                memorySegments = networkBufferPool.requestMemorySegments(5);
                Assert.assertThat((Object)memorySegments, (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Matcher)CoreMatchers.nullValue())));
                if (bufferRecycler == null) break block6;
            }
            catch (Throwable throwable) {
                if (bufferRecycler != null) {
                    bufferRecycler.join();
                }
                if (lbp1 != null) {
                    lbp1.lazyDestroy();
                }
                networkBufferPool.recycleMemorySegments(memorySegments);
                networkBufferPool.destroy();
                throw throwable;
            }
            bufferRecycler.join();
        }
        if (lbp1 != null) {
            lbp1.lazyDestroy();
        }
        networkBufferPool.recycleMemorySegments(memorySegments);
        networkBufferPool.destroy();
    }

    @Test
    public void testRequestMemorySegmentsInterruptable() throws Exception {
        int numBuffers = 10;
        final NetworkBufferPool globalPool = new NetworkBufferPool(10, 128, MemoryType.HEAP);
        MemorySegment segment = globalPool.requestMemorySegment();
        Assert.assertNotNull((Object)segment);
        final OneShotLatch isRunning = new OneShotLatch();
        CheckedThread asyncRequest = new CheckedThread(){

            public void go() throws Exception {
                isRunning.trigger();
                globalPool.requestMemorySegments(10);
            }
        };
        asyncRequest.start();
        isRunning.await();
        Thread.sleep(10L);
        globalPool.destroy();
        segment.free();
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("destroyed");
        asyncRequest.sync();
    }
}

