/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.net.InetAddress;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyProtocol;
import org.apache.flink.runtime.io.network.netty.NettyTestUtil;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.string.StringDecoder;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.string.StringEncoder;
import org.apache.flink.util.NetUtils;
import org.junit.Assert;
import org.junit.Test;

public class NettyClientServerSslTest {
    @Test
    public void testValidSslConnection() throws Exception {
        NettyProtocol protocol = new NettyProtocol(){

            public ChannelHandler[] getServerChannelHandlers() {
                return new ChannelHandler[0];
            }

            public ChannelHandler[] getClientChannelHandlers() {
                return new ChannelHandler[0];
            }
        };
        NettyConfig nettyConfig = new NettyConfig(InetAddress.getLoopbackAddress(), NetUtils.getAvailablePort(), NettyTestUtil.DEFAULT_SEGMENT_SIZE, 1, this.createSslConfig());
        NettyTestUtil.NettyServerAndClient serverAndClient = NettyTestUtil.initServerAndClient(protocol, nettyConfig);
        Channel ch = NettyTestUtil.connect(serverAndClient);
        ch.pipeline().addLast(new ChannelHandler[]{new StringDecoder()}).addLast(new ChannelHandler[]{new StringEncoder()});
        Assert.assertTrue((boolean)ch.writeAndFlush((Object)"test").await().isSuccess());
        NettyTestUtil.shutdown(serverAndClient);
    }

    @Test
    public void testInvalidSslConfiguration() throws Exception {
        NettyProtocol protocol = new NettyProtocol(){

            public ChannelHandler[] getServerChannelHandlers() {
                return new ChannelHandler[0];
            }

            public ChannelHandler[] getClientChannelHandlers() {
                return new ChannelHandler[0];
            }
        };
        Configuration config = this.createSslConfig();
        config.setString(SecurityOptions.SSL_KEYSTORE_PASSWORD, "invalidpassword");
        NettyConfig nettyConfig = new NettyConfig(InetAddress.getLoopbackAddress(), NetUtils.getAvailablePort(), NettyTestUtil.DEFAULT_SEGMENT_SIZE, 1, config);
        NettyTestUtil.NettyServerAndClient serverAndClient = null;
        try {
            serverAndClient = NettyTestUtil.initServerAndClient(protocol, nettyConfig);
            Assert.fail((String)"Created server and client from invalid configuration");
        }
        catch (Exception exception) {
            // empty catch block
        }
        NettyTestUtil.shutdown(serverAndClient);
    }

    @Test
    public void testSslHandshakeError() throws Exception {
        NettyProtocol protocol = new NettyProtocol(){

            public ChannelHandler[] getServerChannelHandlers() {
                return new ChannelHandler[0];
            }

            public ChannelHandler[] getClientChannelHandlers() {
                return new ChannelHandler[0];
            }
        };
        Configuration config = this.createSslConfig();
        config.setString(SecurityOptions.SSL_KEYSTORE, "src/test/resources/untrusted.keystore");
        NettyConfig nettyConfig = new NettyConfig(InetAddress.getLoopbackAddress(), NetUtils.getAvailablePort(), NettyTestUtil.DEFAULT_SEGMENT_SIZE, 1, config);
        NettyTestUtil.NettyServerAndClient serverAndClient = NettyTestUtil.initServerAndClient(protocol, nettyConfig);
        Channel ch = NettyTestUtil.connect(serverAndClient);
        ch.pipeline().addLast(new ChannelHandler[]{new StringDecoder()}).addLast(new ChannelHandler[]{new StringEncoder()});
        Assert.assertFalse((boolean)ch.writeAndFlush((Object)"test").await().isSuccess());
        NettyTestUtil.shutdown(serverAndClient);
    }

    private Configuration createSslConfig() throws Exception {
        Configuration flinkConfig = new Configuration();
        flinkConfig.setBoolean(SecurityOptions.SSL_ENABLED, true);
        flinkConfig.setString(SecurityOptions.SSL_KEYSTORE, "src/test/resources/local127.keystore");
        flinkConfig.setString(SecurityOptions.SSL_KEYSTORE_PASSWORD, "password");
        flinkConfig.setString(SecurityOptions.SSL_KEY_PASSWORD, "password");
        flinkConfig.setString(SecurityOptions.SSL_TRUSTSTORE, "src/test/resources/local127.truststore");
        flinkConfig.setString(SecurityOptions.SSL_TRUSTSTORE_PASSWORD, "password");
        return flinkConfig;
    }
}

