/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.net.InetAddress;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.heartbeat.TestingHeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.OnCompletionActions;
import org.apache.flink.runtime.jobmaster.JobMaster;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.JobMasterRegistrationSuccess;
import org.apache.flink.runtime.leaderelection.TestingLeaderRetrievalService;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.TestLogger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={BlobLibraryCacheManager.class})
public class JobMasterTest
extends TestLogger {
    private final Time testingTimeout = Time.seconds((long)10L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartbeatTimeoutWithTaskManager() throws Exception {
        TestingHighAvailabilityServices haServices = new TestingHighAvailabilityServices();
        TestingLeaderRetrievalService rmLeaderRetrievalService = new TestingLeaderRetrievalService(null, null);
        haServices.setResourceManagerLeaderRetriever(rmLeaderRetrievalService);
        haServices.setCheckpointRecoveryFactory((CheckpointRecoveryFactory)Mockito.mock(CheckpointRecoveryFactory.class));
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        String jobManagerAddress = "jm";
        JobMasterId jobMasterId = JobMasterId.generate();
        ResourceID jmResourceId = new ResourceID("jm");
        String taskManagerAddress = "tm";
        ResourceID tmResourceId = new ResourceID("tm");
        TaskManagerLocation taskManagerLocation = new TaskManagerLocation(tmResourceId, InetAddress.getLoopbackAddress(), 1234);
        TaskExecutorGateway taskExecutorGateway = (TaskExecutorGateway)Mockito.mock(TaskExecutorGateway.class);
        TestingRpcService rpc = new TestingRpcService();
        rpc.registerGateway("tm", (RpcGateway)taskExecutorGateway);
        long heartbeatInterval = 1L;
        long heartbeatTimeout = 5L;
        ScheduledExecutor scheduledExecutor = (ScheduledExecutor)Mockito.mock(ScheduledExecutor.class);
        TestingHeartbeatServices heartbeatServices = new TestingHeartbeatServices(1L, 5L, scheduledExecutor);
        JobGraph jobGraph = new JobGraph(new JobVertex[0]);
        Configuration configuration = new Configuration();
        try (BlobServer blobServer = new BlobServer(configuration, (BlobStore)new VoidBlobStore());){
            blobServer.start();
            JobMaster jobMaster = new JobMaster((RpcService)rpc, jmResourceId, jobGraph, configuration, (HighAvailabilityServices)haServices, (HeartbeatServices)heartbeatServices, Executors.newScheduledThreadPool(1), blobServer, new BlobLibraryCacheManager((PermanentBlobService)blobServer, FlinkUserCodeClassLoaders.ResolveOrder.CHILD_FIRST, new String[0]), (RestartStrategyFactory)Mockito.mock(RestartStrategyFactory.class), this.testingTimeout, null, (OnCompletionActions)Mockito.mock(OnCompletionActions.class), (FatalErrorHandler)testingFatalErrorHandler, (ClassLoader)FlinkUserCodeClassLoaders.parentFirst((URL[])new URL[0], (ClassLoader)JobMasterTest.class.getClassLoader()));
            CompletableFuture startFuture = jobMaster.start(jobMasterId, this.testingTimeout);
            startFuture.get(this.testingTimeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            JobMasterGateway jobMasterGateway = (JobMasterGateway)jobMaster.getSelfGateway(JobMasterGateway.class);
            CompletableFuture registrationResponse = jobMasterGateway.registerTaskManager("tm", taskManagerLocation, this.testingTimeout);
            registrationResponse.get();
            ArgumentCaptor heartbeatRunnableCaptor = ArgumentCaptor.forClass(Runnable.class);
            ((ScheduledExecutor)Mockito.verify((Object)scheduledExecutor, (VerificationMode)Mockito.times((int)1))).scheduleAtFixedRate((Runnable)heartbeatRunnableCaptor.capture(), Mockito.eq((long)0L), Mockito.eq((long)1L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
            Runnable heartbeatRunnable = (Runnable)heartbeatRunnableCaptor.getValue();
            ArgumentCaptor timeoutRunnableCaptor = ArgumentCaptor.forClass(Runnable.class);
            ((ScheduledExecutor)Mockito.verify((Object)scheduledExecutor, (VerificationMode)Mockito.timeout((long)this.testingTimeout.toMilliseconds()))).schedule((Runnable)timeoutRunnableCaptor.capture(), Mockito.eq((long)5L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
            Runnable timeoutRunnable = (Runnable)timeoutRunnableCaptor.getValue();
            heartbeatRunnable.run();
            ((TaskExecutorGateway)Mockito.verify((Object)taskExecutorGateway, (VerificationMode)Mockito.times((int)1))).heartbeatFromJobManager((ResourceID)Mockito.eq((Object)jmResourceId));
            timeoutRunnable.run();
            ((TaskExecutorGateway)Mockito.verify((Object)taskExecutorGateway, (VerificationMode)Mockito.timeout((long)this.testingTimeout.toMilliseconds()))).disconnectJobManager((JobID)Mockito.eq((Object)jobGraph.getJobID()), (Exception)Mockito.any(TimeoutException.class));
            testingFatalErrorHandler.rethrowError();
        }
        finally {
            rpc.stopService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartbeatTimeoutWithResourceManager() throws Exception {
        String resourceManagerAddress = "rm";
        String jobManagerAddress = "jm";
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        JobMasterId jobMasterId = JobMasterId.generate();
        ResourceID rmResourceId = new ResourceID("rm");
        ResourceID jmResourceId = new ResourceID("jm");
        JobGraph jobGraph = new JobGraph(new JobVertex[0]);
        TestingHighAvailabilityServices haServices = new TestingHighAvailabilityServices();
        TestingLeaderRetrievalService rmLeaderRetrievalService = new TestingLeaderRetrievalService(null, null);
        haServices.setResourceManagerLeaderRetriever(rmLeaderRetrievalService);
        haServices.setCheckpointRecoveryFactory((CheckpointRecoveryFactory)Mockito.mock(CheckpointRecoveryFactory.class));
        long heartbeatInterval = 1L;
        long heartbeatTimeout = 5L;
        ScheduledExecutor scheduledExecutor = (ScheduledExecutor)Mockito.mock(ScheduledExecutor.class);
        TestingHeartbeatServices heartbeatServices = new TestingHeartbeatServices(1L, 5L, scheduledExecutor);
        ResourceManagerGateway resourceManagerGateway = (ResourceManagerGateway)Mockito.mock(ResourceManagerGateway.class);
        Mockito.when((Object)resourceManagerGateway.registerJobManager((JobMasterId)Mockito.any(JobMasterId.class), (ResourceID)Mockito.any(ResourceID.class), Mockito.anyString(), (JobID)Mockito.any(JobID.class), (Time)Mockito.any(Time.class))).thenReturn(CompletableFuture.completedFuture(new JobMasterRegistrationSuccess(1L, resourceManagerId, rmResourceId)));
        TestingRpcService rpc = new TestingRpcService();
        rpc.registerGateway("rm", (RpcGateway)resourceManagerGateway);
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        Configuration configuration = new Configuration();
        try (BlobServer blobServer = new BlobServer(configuration, (BlobStore)new VoidBlobStore());){
            blobServer.start();
            JobMaster jobMaster = new JobMaster((RpcService)rpc, jmResourceId, jobGraph, configuration, (HighAvailabilityServices)haServices, (HeartbeatServices)heartbeatServices, Executors.newScheduledThreadPool(1), blobServer, new BlobLibraryCacheManager((PermanentBlobService)blobServer, FlinkUserCodeClassLoaders.ResolveOrder.CHILD_FIRST, new String[0]), (RestartStrategyFactory)Mockito.mock(RestartStrategyFactory.class), this.testingTimeout, null, (OnCompletionActions)Mockito.mock(OnCompletionActions.class), (FatalErrorHandler)testingFatalErrorHandler, (ClassLoader)FlinkUserCodeClassLoaders.parentFirst((URL[])new URL[0], (ClassLoader)JobMasterTest.class.getClassLoader()));
            CompletableFuture startFuture = jobMaster.start(jobMasterId, this.testingTimeout);
            startFuture.get(this.testingTimeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            rmLeaderRetrievalService.notifyListener("rm", resourceManagerId.toUUID());
            ((ResourceManagerGateway)Mockito.verify((Object)resourceManagerGateway, (VerificationMode)Mockito.timeout((long)this.testingTimeout.toMilliseconds()))).registerJobManager((JobMasterId)Mockito.eq((Object)jobMasterId), (ResourceID)Mockito.eq((Object)jmResourceId), Mockito.anyString(), (JobID)Mockito.eq((Object)jobGraph.getJobID()), (Time)Mockito.any(Time.class));
            ((ResourceManagerGateway)Mockito.verify((Object)resourceManagerGateway, (VerificationMode)Mockito.timeout((long)250L))).disconnectJobManager((JobID)Mockito.eq((Object)jobGraph.getJobID()), (Exception)Mockito.any(TimeoutException.class));
            testingFatalErrorHandler.rethrowError();
        }
        finally {
            rpc.stopService();
        }
    }
}

