/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.GenericMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetricGroupTest
extends TestLogger {
    private static final MetricRegistryConfiguration defaultMetricRegistryConfiguration = MetricRegistryConfiguration.defaultMetricRegistryConfiguration();
    private MetricRegistryImpl registry;
    private final MetricRegistryImpl exceptionOnRegister = new ExceptionOnRegisterRegistry();

    @Before
    public void createRegistry() {
        this.registry = new MetricRegistryImpl(defaultMetricRegistryConfiguration);
    }

    @After
    public void shutdownRegistry() {
        this.registry.shutdown();
        this.registry = null;
    }

    @Test
    public void sameGroupOnNameCollision() {
        GenericMetricGroup group = new GenericMetricGroup((MetricRegistry)this.registry, (AbstractMetricGroup)new DummyAbstractMetricGroup((MetricRegistry)this.registry), "somegroup");
        String groupName = "sometestname";
        MetricGroup subgroup1 = group.addGroup(groupName);
        MetricGroup subgroup2 = group.addGroup(groupName);
        Assert.assertNotNull((Object)subgroup1);
        Assert.assertNotNull((Object)subgroup2);
        Assert.assertTrue((subgroup1 == subgroup2 ? 1 : 0) != 0);
    }

    @Test
    public void closedGroupDoesNotRegisterMetrics() {
        GenericMetricGroup group = new GenericMetricGroup((MetricRegistry)this.exceptionOnRegister, (AbstractMetricGroup)new DummyAbstractMetricGroup((MetricRegistry)this.exceptionOnRegister), "testgroup");
        Assert.assertFalse((boolean)group.isClosed());
        group.close();
        Assert.assertTrue((boolean)group.isClosed());
        group.counter("testcounter");
        group.gauge("testgauge", (Gauge)new Gauge<Object>(){

            public Object getValue() {
                return null;
            }
        });
    }

    @Test
    public void closedGroupCreatesClosedGroups() {
        GenericMetricGroup group = new GenericMetricGroup((MetricRegistry)this.exceptionOnRegister, (AbstractMetricGroup)new DummyAbstractMetricGroup((MetricRegistry)this.exceptionOnRegister), "testgroup");
        Assert.assertFalse((boolean)group.isClosed());
        group.close();
        Assert.assertTrue((boolean)group.isClosed());
        AbstractMetricGroup subgroup = (AbstractMetricGroup)group.addGroup("test subgroup");
        Assert.assertTrue((boolean)subgroup.isClosed());
    }

    @Test
    public void tolerateMetricNameCollisions() {
        String name = "abctestname";
        GenericMetricGroup group = new GenericMetricGroup((MetricRegistry)this.registry, (AbstractMetricGroup)new DummyAbstractMetricGroup((MetricRegistry)this.registry), "testgroup");
        Assert.assertNotNull((Object)group.counter("abctestname"));
        Assert.assertNotNull((Object)group.counter("abctestname"));
    }

    @Test
    public void tolerateMetricAndGroupNameCollisions() {
        String name = "abctestname";
        GenericMetricGroup group = new GenericMetricGroup((MetricRegistry)this.registry, (AbstractMetricGroup)new DummyAbstractMetricGroup((MetricRegistry)this.registry), "testgroup");
        Assert.assertNotNull((Object)group.addGroup("abctestname"));
        Assert.assertNotNull((Object)group.counter("abctestname"));
    }

    @Test
    public void testCreateQueryServiceMetricInfo() {
        JobID jid = new JobID();
        JobVertexID vid = new JobVertexID();
        AbstractID eid = new AbstractID();
        MetricRegistryImpl registry = new MetricRegistryImpl(defaultMetricRegistryConfiguration);
        TaskManagerMetricGroup tm = new TaskManagerMetricGroup((MetricRegistry)registry, "host", "id");
        TaskManagerJobMetricGroup job = new TaskManagerJobMetricGroup((MetricRegistry)registry, tm, jid, "jobname");
        TaskMetricGroup task = new TaskMetricGroup((MetricRegistry)registry, job, vid, eid, "taskName", 4, 5);
        GenericMetricGroup userGroup1 = new GenericMetricGroup((MetricRegistry)registry, (AbstractMetricGroup)task, "hello");
        GenericMetricGroup userGroup2 = new GenericMetricGroup((MetricRegistry)registry, (AbstractMetricGroup)userGroup1, "world");
        QueryScopeInfo.TaskQueryScopeInfo info1 = (QueryScopeInfo.TaskQueryScopeInfo)userGroup1.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assert.assertEquals((Object)"hello", (Object)info1.scope);
        Assert.assertEquals((Object)jid.toString(), (Object)info1.jobID);
        Assert.assertEquals((Object)vid.toString(), (Object)info1.vertexID);
        Assert.assertEquals((long)4L, (long)info1.subtaskIndex);
        QueryScopeInfo.TaskQueryScopeInfo info2 = (QueryScopeInfo.TaskQueryScopeInfo)userGroup2.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assert.assertEquals((Object)"hello.world", (Object)info2.scope);
        Assert.assertEquals((Object)jid.toString(), (Object)info2.jobID);
        Assert.assertEquals((Object)vid.toString(), (Object)info2.vertexID);
        Assert.assertEquals((long)4L, (long)info2.subtaskIndex);
    }

    public static class DummyAbstractMetricGroup
    extends AbstractMetricGroup {
        public DummyAbstractMetricGroup(MetricRegistry registry) {
            super(registry, new String[0], null);
        }

        protected QueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
            return null;
        }

        protected String getGroupName(CharacterFilter filter) {
            return "";
        }

        protected void addMetric(String name, Metric metric) {
        }

        public MetricGroup addGroup(String name) {
            return new DummyAbstractMetricGroup(this.registry);
        }
    }

    private static class ExceptionOnRegisterRegistry
    extends MetricRegistryImpl {
        public ExceptionOnRegisterRegistry() {
            super(defaultMetricRegistryConfiguration);
        }

        public void register(Metric metric, String name, AbstractMetricGroup parent) {
            Assert.fail((String)"Metric should never be registered");
        }

        public void unregister(Metric metric, String name, AbstractMetricGroup parent) {
            Assert.fail((String)"Metric should never be un-registered");
        }
    }
}

