/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.JobMasterRegistrationSuccess;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.TestingLeaderElectionService;
import org.apache.flink.runtime.leaderelection.TestingLeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManager;
import org.apache.flink.runtime.resourcemanager.exceptions.ResourceManagerException;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.rpc.exceptions.FencingTokenException;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ResourceManagerJobMasterTest
extends TestLogger {
    private TestingRpcService rpcService;
    private final Time timeout = Time.seconds((long)10L);

    @Before
    public void setup() throws Exception {
        this.rpcService = new TestingRpcService();
    }

    @After
    public void teardown() throws Exception {
        this.rpcService.stopService();
    }

    @Test
    public void testRegisterJobMaster() throws Exception {
        String jobMasterAddress = "/jobMasterAddress1";
        JobID jobID = this.mockJobMaster(jobMasterAddress);
        JobMasterId jobMasterId = JobMasterId.generate();
        ResourceID jmResourceId = new ResourceID(jobMasterAddress);
        TestingLeaderRetrievalService jobMasterLeaderRetrievalService = new TestingLeaderRetrievalService(jobMasterAddress, jobMasterId.toUUID());
        TestingLeaderElectionService resourceManagerLeaderElectionService = new TestingLeaderElectionService();
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        ResourceManager resourceManager = this.createAndStartResourceManager(resourceManagerLeaderElectionService, jobID, jobMasterLeaderRetrievalService, testingFatalErrorHandler);
        ResourceManagerGateway rmGateway = (ResourceManagerGateway)resourceManager.getSelfGateway(ResourceManagerGateway.class);
        resourceManagerLeaderElectionService.isLeader(UUID.randomUUID()).get();
        CompletableFuture successfulFuture = rmGateway.registerJobManager(jobMasterId, jmResourceId, jobMasterAddress, jobID, this.timeout);
        RegistrationResponse response = (RegistrationResponse)successfulFuture.get(this.timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)(response instanceof JobMasterRegistrationSuccess));
        if (testingFatalErrorHandler.hasExceptionOccurred()) {
            testingFatalErrorHandler.rethrowError();
        }
    }

    @Test
    public void testRegisterJobMasterWithUnmatchedLeaderSessionId1() throws Exception {
        String jobMasterAddress = "/jobMasterAddress1";
        JobID jobID = this.mockJobMaster(jobMasterAddress);
        JobMasterId jobMasterId = JobMasterId.generate();
        ResourceID jmResourceId = new ResourceID(jobMasterAddress);
        TestingLeaderRetrievalService jobMasterLeaderRetrievalService = new TestingLeaderRetrievalService(jobMasterAddress, jobMasterId.toUUID());
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        ResourceManager resourceManager = this.createAndStartResourceManager((LeaderElectionService)Mockito.mock(LeaderElectionService.class), jobID, jobMasterLeaderRetrievalService, testingFatalErrorHandler);
        ResourceManagerGateway wronglyFencedGateway = this.rpcService.connect(resourceManager.getAddress(), ResourceManagerId.generate(), ResourceManagerGateway.class).get(this.timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
        CompletableFuture unMatchedLeaderFuture = wronglyFencedGateway.registerJobManager(jobMasterId, jmResourceId, jobMasterAddress, jobID, this.timeout);
        try {
            unMatchedLeaderFuture.get(5L, TimeUnit.SECONDS);
            Assert.fail((String)"Should fail because we are using the wrong fencing token.");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(ExceptionUtils.stripExecutionException((Throwable)e) instanceof FencingTokenException));
        }
        if (testingFatalErrorHandler.hasExceptionOccurred()) {
            testingFatalErrorHandler.rethrowError();
        }
    }

    @Test
    public void testRegisterJobMasterWithUnmatchedLeaderSessionId2() throws Exception {
        String jobMasterAddress = "/jobMasterAddress1";
        JobID jobID = this.mockJobMaster(jobMasterAddress);
        TestingLeaderElectionService resourceManagerLeaderElectionService = new TestingLeaderElectionService();
        TestingLeaderRetrievalService jobMasterLeaderRetrievalService = new TestingLeaderRetrievalService("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        ResourceManager resourceManager = this.createAndStartResourceManager(resourceManagerLeaderElectionService, jobID, jobMasterLeaderRetrievalService, testingFatalErrorHandler);
        ResourceManagerGateway rmGateway = (ResourceManagerGateway)resourceManager.getSelfGateway(ResourceManagerGateway.class);
        ResourceID jmResourceId = new ResourceID(jobMasterAddress);
        resourceManagerLeaderElectionService.isLeader(UUID.randomUUID()).get();
        JobMasterId differentJobMasterId = JobMasterId.generate();
        CompletableFuture unMatchedLeaderFuture = rmGateway.registerJobManager(differentJobMasterId, jmResourceId, jobMasterAddress, jobID, this.timeout);
        Assert.assertTrue((boolean)(unMatchedLeaderFuture.get(5L, TimeUnit.SECONDS) instanceof RegistrationResponse.Decline));
        if (testingFatalErrorHandler.hasExceptionOccurred()) {
            testingFatalErrorHandler.rethrowError();
        }
    }

    @Test
    public void testRegisterJobMasterFromInvalidAddress() throws Exception {
        String jobMasterAddress = "/jobMasterAddress1";
        JobID jobID = this.mockJobMaster(jobMasterAddress);
        TestingLeaderElectionService resourceManagerLeaderElectionService = new TestingLeaderElectionService();
        TestingLeaderRetrievalService jobMasterLeaderRetrievalService = new TestingLeaderRetrievalService("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        ResourceManager resourceManager = this.createAndStartResourceManager(resourceManagerLeaderElectionService, jobID, jobMasterLeaderRetrievalService, testingFatalErrorHandler);
        ResourceManagerGateway rmGateway = (ResourceManagerGateway)resourceManager.getSelfGateway(ResourceManagerGateway.class);
        ResourceID jmResourceId = new ResourceID(jobMasterAddress);
        resourceManagerLeaderElectionService.isLeader(UUID.randomUUID()).get();
        String invalidAddress = "/jobMasterAddress2";
        CompletableFuture invalidAddressFuture = rmGateway.registerJobManager(new JobMasterId(HighAvailabilityServices.DEFAULT_LEADER_ID), jmResourceId, invalidAddress, jobID, this.timeout);
        Assert.assertTrue((boolean)(invalidAddressFuture.get(5L, TimeUnit.SECONDS) instanceof RegistrationResponse.Decline));
        if (testingFatalErrorHandler.hasExceptionOccurred()) {
            testingFatalErrorHandler.rethrowError();
        }
    }

    @Test
    public void testRegisterJobMasterWithFailureLeaderListener() throws Exception {
        String jobMasterAddress = "/jobMasterAddress1";
        JobID jobID = this.mockJobMaster(jobMasterAddress);
        TestingLeaderElectionService resourceManagerLeaderElectionService = new TestingLeaderElectionService();
        TestingLeaderRetrievalService jobMasterLeaderRetrievalService = new TestingLeaderRetrievalService("localhost", HighAvailabilityServices.DEFAULT_LEADER_ID);
        TestingFatalErrorHandler testingFatalErrorHandler = new TestingFatalErrorHandler();
        ResourceManager resourceManager = this.createAndStartResourceManager(resourceManagerLeaderElectionService, jobID, jobMasterLeaderRetrievalService, testingFatalErrorHandler);
        ResourceManagerGateway rmGateway = (ResourceManagerGateway)resourceManager.getSelfGateway(ResourceManagerGateway.class);
        ResourceID jmResourceId = new ResourceID(jobMasterAddress);
        JobID unknownJobIDToHAServices = new JobID();
        resourceManagerLeaderElectionService.isLeader(UUID.randomUUID()).get();
        CompletableFuture registrationFuture = rmGateway.registerJobManager(new JobMasterId(HighAvailabilityServices.DEFAULT_LEADER_ID), jmResourceId, jobMasterAddress, unknownJobIDToHAServices, this.timeout);
        try {
            registrationFuture.get(this.timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(ExceptionUtils.stripExecutionException((Throwable)e) instanceof ResourceManagerException));
        }
    }

    private JobID mockJobMaster(String jobMasterAddress) {
        JobID jobID = new JobID();
        JobMasterGateway jobMasterGateway = (JobMasterGateway)Mockito.mock(JobMasterGateway.class);
        this.rpcService.registerGateway(jobMasterAddress, (RpcGateway)jobMasterGateway);
        return jobID;
    }

    private ResourceManager createAndStartResourceManager(LeaderElectionService resourceManagerLeaderElectionService, JobID jobID, LeaderRetrievalService jobMasterLeaderRetrievalService, FatalErrorHandler fatalErrorHandler) throws Exception {
        ResourceID rmResourceId = ResourceID.generate();
        TestingHighAvailabilityServices highAvailabilityServices = new TestingHighAvailabilityServices();
        highAvailabilityServices.setResourceManagerLeaderElectionService(resourceManagerLeaderElectionService);
        highAvailabilityServices.setJobMasterLeaderRetriever(jobID, jobMasterLeaderRetrievalService);
        HeartbeatServices heartbeatServices = new HeartbeatServices(5L, 5L);
        ResourceManagerConfiguration resourceManagerConfiguration = new ResourceManagerConfiguration(Time.seconds((long)5L), Time.seconds((long)5L));
        MetricRegistryImpl metricRegistry = (MetricRegistryImpl)Mockito.mock(MetricRegistryImpl.class);
        JobLeaderIdService jobLeaderIdService = new JobLeaderIdService((HighAvailabilityServices)highAvailabilityServices, this.rpcService.getScheduledExecutor(), Time.minutes((long)5L));
        SlotManager slotManager = new SlotManager(this.rpcService.getScheduledExecutor(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime(), TestingUtils.infiniteTime());
        StandaloneResourceManager resourceManager = new StandaloneResourceManager((RpcService)this.rpcService, "resourcemanager", rmResourceId, resourceManagerConfiguration, (HighAvailabilityServices)highAvailabilityServices, heartbeatServices, slotManager, (MetricRegistry)metricRegistry, jobLeaderIdService, fatalErrorHandler);
        resourceManager.start();
        return resourceManager;
    }
}

