/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.BlobServerPortHandler;
import org.apache.flink.runtime.rest.messages.BlobServerPortResponseBody;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class BlobServerPortHandlerTest
extends TestLogger {
    private static final int PORT = 64;

    @Test
    public void testPortRetrieval() throws Exception {
        DispatcherGateway mockGateway = (DispatcherGateway)Mockito.mock(DispatcherGateway.class);
        Mockito.when((Object)mockGateway.getBlobServerPort((Time)Matchers.any(Time.class))).thenReturn(CompletableFuture.completedFuture(64));
        GatewayRetriever mockGatewayRetriever = (GatewayRetriever)Mockito.mock(GatewayRetriever.class);
        BlobServerPortHandler handler = new BlobServerPortHandler(CompletableFuture.completedFuture("http://localhost:1234"), mockGatewayRetriever, RpcUtils.INF_TIMEOUT);
        BlobServerPortResponseBody portResponse = (BlobServerPortResponseBody)handler.handleRequest(new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)EmptyMessageParameters.getInstance()), mockGateway).get();
        Assert.assertEquals((long)64L, (long)portResponse.port);
    }

    @Test
    public void testPortRetrievalFailureHandling() throws Exception {
        DispatcherGateway mockGateway = (DispatcherGateway)Mockito.mock(DispatcherGateway.class);
        Mockito.when((Object)mockGateway.getBlobServerPort((Time)Matchers.any(Time.class))).thenReturn((Object)FutureUtils.completedExceptionally((Throwable)new TestException()));
        GatewayRetriever mockGatewayRetriever = (GatewayRetriever)Mockito.mock(GatewayRetriever.class);
        BlobServerPortHandler handler = new BlobServerPortHandler(CompletableFuture.completedFuture("http://localhost:1234"), mockGatewayRetriever, RpcUtils.INF_TIMEOUT);
        try {
            handler.handleRequest(new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)EmptyMessageParameters.getInstance()), mockGateway).get();
            Assert.fail();
        }
        catch (ExecutionException ee) {
            RestHandlerException rhe = (RestHandlerException)ee.getCause();
            Assert.assertEquals(TestException.class, rhe.getCause().getClass());
            Assert.assertEquals((Object)HttpResponseStatus.INTERNAL_SERVER_ERROR, (Object)rhe.getHttpResponseStatus());
        }
    }

    private static class TestException
    extends Exception {
        private TestException() {
        }
    }
}

