/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.rest.handler.legacy.CurrentJobsOverviewHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedJobGenerationUtils;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.junit.Assert;
import org.junit.Test;

public class CurrentJobsOverviewHandlerTest {
    @Test
    public void testArchiver() throws Exception {
        CurrentJobsOverviewHandler.CurrentJobsOverviewJsonArchivist archivist = new CurrentJobsOverviewHandler.CurrentJobsOverviewJsonArchivist();
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        JobDetails expectedDetails = WebMonitorUtils.createDetailsForJob((AccessExecutionGraph)originalJob);
        Collection archives = archivist.archiveJsonWithPath(originalJob);
        Assert.assertEquals((long)1L, (long)archives.size());
        ArchivedJson archive = (ArchivedJson)archives.iterator().next();
        Assert.assertEquals((Object)"/joboverview", (Object)archive.getPath());
        JsonNode result = ArchivedJobGenerationUtils.MAPPER.readTree(archive.getJson());
        ArrayNode running = (ArrayNode)result.get("running");
        Assert.assertEquals((long)0L, (long)running.size());
        ArrayNode finished = (ArrayNode)result.get("finished");
        Assert.assertEquals((long)1L, (long)finished.size());
        CurrentJobsOverviewHandlerTest.compareJobOverview(expectedDetails, finished.get(0).toString());
    }

    @Test
    public void testGetPaths() {
        CurrentJobsOverviewHandler handlerAll = new CurrentJobsOverviewHandler(Executors.directExecutor(), Time.seconds((long)0L), true, true);
        String[] pathsAll = handlerAll.getPaths();
        Assert.assertEquals((long)1L, (long)pathsAll.length);
        Assert.assertEquals((Object)"/joboverview", (Object)pathsAll[0]);
        CurrentJobsOverviewHandler handlerRunning = new CurrentJobsOverviewHandler(Executors.directExecutor(), Time.seconds((long)0L), true, false);
        String[] pathsRunning = handlerRunning.getPaths();
        Assert.assertEquals((long)1L, (long)pathsRunning.length);
        Assert.assertEquals((Object)"/joboverview/running", (Object)pathsRunning[0]);
        CurrentJobsOverviewHandler handlerCompleted = new CurrentJobsOverviewHandler(Executors.directExecutor(), Time.seconds((long)0L), false, true);
        String[] pathsCompleted = handlerCompleted.getPaths();
        Assert.assertEquals((long)1L, (long)pathsCompleted.length);
        Assert.assertEquals((Object)"/joboverview/completed", (Object)pathsCompleted[0]);
    }

    @Test
    public void testJsonGeneration() throws Exception {
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        JobDetails expectedDetails = WebMonitorUtils.createDetailsForJob((AccessExecutionGraph)originalJob);
        StringWriter writer = new StringWriter();
        try (JsonGenerator gen = ArchivedJobGenerationUtils.JACKSON_FACTORY.createGenerator((Writer)writer);){
            JobDetails.JobDetailsSerializer serializer = new JobDetails.JobDetailsSerializer();
            serializer.serialize(expectedDetails, gen, null);
        }
        CurrentJobsOverviewHandlerTest.compareJobOverview(expectedDetails, writer.toString());
    }

    private static void compareJobOverview(JobDetails expectedDetails, String answer) throws IOException {
        JsonNode result = ArchivedJobGenerationUtils.MAPPER.readTree(answer);
        Assert.assertEquals((Object)expectedDetails.getJobId().toString(), (Object)result.get("jid").asText());
        Assert.assertEquals((Object)expectedDetails.getJobName(), (Object)result.get("name").asText());
        Assert.assertEquals((Object)expectedDetails.getStatus().name(), (Object)result.get("state").asText());
        Assert.assertEquals((long)expectedDetails.getStartTime(), (long)result.get("start-time").asLong());
        Assert.assertEquals((long)expectedDetails.getEndTime(), (long)result.get("end-time").asLong());
        Assert.assertEquals((long)(expectedDetails.getEndTime() - expectedDetails.getStartTime()), (long)result.get("duration").asLong());
        Assert.assertEquals((long)expectedDetails.getLastUpdateTime(), (long)result.get("last-modification").asLong());
        JsonNode tasks = result.get("tasks");
        Assert.assertEquals((long)expectedDetails.getNumTasks(), (long)tasks.get("total").asInt());
        int[] tasksPerState = expectedDetails.getTasksPerState();
        for (ExecutionState executionState : ExecutionState.values()) {
            Assert.assertEquals((long)tasksPerState[executionState.ordinal()], (long)tasks.get(executionState.name().toLowerCase()).asInt());
        }
    }
}

