/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.time.ZonedDateTime;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.rest.handler.legacy.DashboardConfigHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedJobGenerationUtils;
import org.apache.flink.runtime.rest.messages.DashboardConfiguration;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class DashboardConfigHandlerTest
extends TestLogger {
    @Test
    public void testGetPaths() {
        DashboardConfigHandler handler = new DashboardConfigHandler(Executors.directExecutor(), 10000L);
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/config", (Object)paths[0]);
    }

    @Test
    public void testJsonGeneration() throws Exception {
        long refreshInterval = 12345L;
        ZonedDateTime zonedDateTime = ZonedDateTime.now();
        DashboardConfiguration dashboardConfiguration = DashboardConfiguration.from((long)refreshInterval, (ZonedDateTime)zonedDateTime);
        String json = DashboardConfigHandler.createConfigJson((DashboardConfiguration)dashboardConfiguration);
        JsonNode result = ArchivedJobGenerationUtils.MAPPER.readTree(json);
        Assert.assertEquals((long)refreshInterval, (long)result.get("refresh-interval").asLong());
        Assert.assertEquals((Object)dashboardConfiguration.getTimeZoneName(), (Object)result.get("timezone-name").asText());
        Assert.assertEquals((long)dashboardConfiguration.getTimeZoneOffset(), (long)result.get("timezone-offset").asInt());
        Assert.assertEquals((Object)dashboardConfiguration.getFlinkVersion(), (Object)result.get("flink-version").asText());
        Assert.assertEquals((Object)dashboardConfiguration.getFlinkRevision(), (Object)result.get("flink-revision").asText());
    }
}

