/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.jobgraph.tasks.ExternalizedCheckpointSettings;
import org.apache.flink.runtime.jobmaster.JobManagerGateway;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JobCancellationWithSavepointHandlers;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.FullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class JobCancellationWithSavepointHandlersTest
extends TestLogger {
    private static final Executor executor = Executors.directExecutor();

    @Test
    public void testGetPaths() {
        JobCancellationWithSavepointHandlers handler = new JobCancellationWithSavepointHandlers((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), executor);
        JobCancellationWithSavepointHandlers.TriggerHandler triggerHandler = handler.getTriggerHandler();
        String[] triggerPaths = triggerHandler.getPaths();
        Assert.assertEquals((long)2L, (long)triggerPaths.length);
        List<String> triggerPathsList = Arrays.asList(triggerPaths);
        Assert.assertTrue((boolean)triggerPathsList.contains("/jobs/:jobid/cancel-with-savepoint"));
        Assert.assertTrue((boolean)triggerPathsList.contains("/jobs/:jobid/cancel-with-savepoint/target-directory/:targetDirectory"));
        JobCancellationWithSavepointHandlers.InProgressHandler progressHandler = handler.getInProgressHandler();
        String[] progressPaths = progressHandler.getPaths();
        Assert.assertEquals((long)1L, (long)progressPaths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/cancel-with-savepoint/in-progress/:requestId", (Object)progressPaths[0]);
    }

    @Test
    public void testAskTimeoutEqualsCheckpointTimeout() throws Exception {
        long timeout = 128288238L;
        JobID jobId = new JobID();
        ExecutionGraphCache holder = (ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class);
        ExecutionGraph graph = (ExecutionGraph)Mockito.mock(ExecutionGraph.class);
        Mockito.when((Object)holder.getExecutionGraph((JobID)Matchers.eq((Object)jobId), (RestfulGateway)Matchers.any(JobManagerGateway.class))).thenReturn(CompletableFuture.completedFuture(graph));
        Mockito.when((Object)graph.getCheckpointCoordinatorConfiguration()).thenReturn((Object)new CheckpointCoordinatorConfiguration(1L, timeout, 1L, 1, ExternalizedCheckpointSettings.none(), true));
        JobCancellationWithSavepointHandlers handlers = new JobCancellationWithSavepointHandlers(holder, executor);
        JobCancellationWithSavepointHandlers.TriggerHandler handler = handlers.getTriggerHandler();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jobid", jobId.toString());
        params.put("targetDirectory", "placeholder");
        JobManagerGateway jobManager = (JobManagerGateway)Mockito.mock(JobManagerGateway.class);
        Mockito.when((Object)jobManager.cancelJobWithSavepoint((JobID)Matchers.eq((Object)jobId), Matchers.anyString(), (Time)Matchers.any(Time.class))).thenReturn(CompletableFuture.completedFuture("foobar"));
        handler.handleRequest(params, Collections.emptyMap(), jobManager);
        ((JobManagerGateway)Mockito.verify((Object)jobManager)).cancelJobWithSavepoint((JobID)Matchers.eq((Object)jobId), Matchers.anyString(), (Time)Matchers.any(Time.class));
    }

    @Test
    public void testSavepointDirectoryConfiguration() throws Exception {
        long timeout = 128288238L;
        JobID jobId = new JobID();
        ExecutionGraphCache holder = (ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class);
        ExecutionGraph graph = (ExecutionGraph)Mockito.mock(ExecutionGraph.class);
        Mockito.when((Object)holder.getExecutionGraph((JobID)Matchers.eq((Object)jobId), (RestfulGateway)Matchers.any(JobManagerGateway.class))).thenReturn(CompletableFuture.completedFuture(graph));
        Mockito.when((Object)graph.getCheckpointCoordinatorConfiguration()).thenReturn((Object)new CheckpointCoordinatorConfiguration(1L, timeout, 1L, 1, ExternalizedCheckpointSettings.none(), true));
        JobCancellationWithSavepointHandlers handlers = new JobCancellationWithSavepointHandlers(holder, executor, "the-default-directory");
        JobCancellationWithSavepointHandlers.TriggerHandler handler = handlers.getTriggerHandler();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jobid", jobId.toString());
        JobManagerGateway jobManager = (JobManagerGateway)Mockito.mock(JobManagerGateway.class);
        Mockito.when((Object)jobManager.cancelJobWithSavepoint((JobID)Matchers.eq((Object)jobId), Matchers.anyString(), (Time)Matchers.any(Time.class))).thenReturn(CompletableFuture.completedFuture("foobar"));
        params.put("targetDirectory", "custom-directory");
        handler.handleRequest(params, Collections.emptyMap(), jobManager);
        ((JobManagerGateway)Mockito.verify((Object)jobManager)).cancelJobWithSavepoint((JobID)Matchers.eq((Object)jobId), (String)Matchers.eq((Object)"custom-directory"), (Time)Matchers.any(Time.class));
        params.remove("targetDirectory");
        handler.handleRequest(params, Collections.emptyMap(), jobManager);
        ((JobManagerGateway)Mockito.verify((Object)jobManager)).cancelJobWithSavepoint((JobID)Matchers.eq((Object)jobId), (String)Matchers.eq((Object)"the-default-directory"), (Time)Matchers.any(Time.class));
        handlers = new JobCancellationWithSavepointHandlers(holder, executor, null);
        handler = handlers.getTriggerHandler();
        try {
            handler.handleRequest(params, Collections.emptyMap(), jobManager).get();
            Assert.fail((String)"Did not throw expected test Exception");
        }
        catch (Exception e) {
            IllegalStateException cause = (IllegalStateException)e.getCause();
            Assert.assertEquals((Object)true, (Object)cause.getMessage().contains(CoreOptions.SAVEPOINT_DIRECTORY.key()));
        }
    }

    @Test
    public void testTriggerNewRequest() throws Exception {
        JobID jobId = new JobID();
        ExecutionGraphCache holder = (ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class);
        ExecutionGraph graph = (ExecutionGraph)Mockito.mock(ExecutionGraph.class);
        Mockito.when((Object)holder.getExecutionGraph((JobID)Matchers.eq((Object)jobId), (RestfulGateway)Matchers.any(JobManagerGateway.class))).thenReturn(CompletableFuture.completedFuture(graph));
        Mockito.when((Object)graph.getCheckpointCoordinatorConfiguration()).thenReturn((Object)new CheckpointCoordinatorConfiguration(1L, 1L, 1L, 1, ExternalizedCheckpointSettings.none(), true));
        JobCancellationWithSavepointHandlers handlers = new JobCancellationWithSavepointHandlers(holder, executor);
        JobCancellationWithSavepointHandlers.TriggerHandler trigger = handlers.getTriggerHandler();
        JobCancellationWithSavepointHandlers.InProgressHandler progress = handlers.getInProgressHandler();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jobid", jobId.toString());
        params.put("targetDirectory", "custom-directory");
        JobManagerGateway jobManager = (JobManagerGateway)Mockito.mock(JobManagerGateway.class);
        CompletableFuture<String> successfulCancelWithSavepoint = new CompletableFuture<String>();
        Mockito.when((Object)jobManager.cancelJobWithSavepoint((JobID)Matchers.eq((Object)jobId), (String)Matchers.eq((Object)"custom-directory"), (Time)Matchers.any(Time.class))).thenReturn(successfulCancelWithSavepoint);
        FullHttpResponse response = (FullHttpResponse)trigger.handleRequest(params, Collections.emptyMap(), jobManager).get();
        ((JobManagerGateway)Mockito.verify((Object)jobManager)).cancelJobWithSavepoint((JobID)Matchers.eq((Object)jobId), (String)Matchers.eq((Object)"custom-directory"), (Time)Matchers.any(Time.class));
        String location = String.format("/jobs/%s/cancel-with-savepoint/in-progress/1", jobId);
        Assert.assertEquals((Object)HttpResponseStatus.ACCEPTED, (Object)response.getStatus());
        Assert.assertEquals((Object)"application/json; charset=UTF-8", (Object)response.headers().get("Content-Type"));
        Assert.assertEquals((Object)Integer.toString(response.content().readableBytes()), (Object)response.headers().get("Content-Length"));
        Assert.assertEquals((Object)location, (Object)response.headers().get("Location"));
        String json = response.content().toString(Charset.forName("UTF-8"));
        JsonNode root = new ObjectMapper().readTree(json);
        Assert.assertEquals((Object)"accepted", (Object)root.get("status").asText());
        Assert.assertEquals((Object)"1", (Object)root.get("request-id").asText());
        Assert.assertEquals((Object)location, (Object)root.get("location").asText());
        response = (FullHttpResponse)trigger.handleRequest(params, Collections.emptyMap(), jobManager).get();
        Assert.assertEquals((Object)HttpResponseStatus.ACCEPTED, (Object)response.getStatus());
        Assert.assertEquals((Object)"application/json; charset=UTF-8", (Object)response.headers().get("Content-Type"));
        Assert.assertEquals((Object)Integer.toString(response.content().readableBytes()), (Object)response.headers().get("Content-Length"));
        Assert.assertEquals((Object)location, (Object)response.headers().get("Location"));
        json = response.content().toString(Charset.forName("UTF-8"));
        root = new ObjectMapper().readTree(json);
        Assert.assertEquals((Object)"accepted", (Object)root.get("status").asText());
        Assert.assertEquals((Object)"1", (Object)root.get("request-id").asText());
        Assert.assertEquals((Object)location, (Object)root.get("location").asText());
        ((JobManagerGateway)Mockito.verify((Object)jobManager)).cancelJobWithSavepoint((JobID)Matchers.eq((Object)jobId), (String)Matchers.eq((Object)"custom-directory"), (Time)Matchers.any(Time.class));
        params.put("requestId", "1");
        response = (FullHttpResponse)progress.handleRequest(params, Collections.emptyMap(), jobManager).get();
        Assert.assertEquals((Object)HttpResponseStatus.ACCEPTED, (Object)response.getStatus());
        Assert.assertEquals((Object)"application/json; charset=UTF-8", (Object)response.headers().get("Content-Type"));
        Assert.assertEquals((Object)Integer.toString(response.content().readableBytes()), (Object)response.headers().get("Content-Length"));
        json = response.content().toString(Charset.forName("UTF-8"));
        root = new ObjectMapper().readTree(json);
        Assert.assertEquals((Object)"in-progress", (Object)root.get("status").asText());
        Assert.assertEquals((Object)"1", (Object)root.get("request-id").asText());
        successfulCancelWithSavepoint.complete("_path-savepoint_");
        response = (FullHttpResponse)progress.handleRequest(params, Collections.emptyMap(), jobManager).get();
        Assert.assertEquals((Object)HttpResponseStatus.CREATED, (Object)response.getStatus());
        Assert.assertEquals((Object)"application/json; charset=UTF-8", (Object)response.headers().get("Content-Type"));
        Assert.assertEquals((Object)Integer.toString(response.content().readableBytes()), (Object)response.headers().get("Content-Length"));
        json = response.content().toString(Charset.forName("UTF-8"));
        root = new ObjectMapper().readTree(json);
        Assert.assertEquals((Object)"success", (Object)root.get("status").asText());
        Assert.assertEquals((Object)"1", (Object)root.get("request-id").asText());
        Assert.assertEquals((Object)"_path-savepoint_", (Object)root.get("savepoint-path").asText());
        response = (FullHttpResponse)progress.handleRequest(params, Collections.emptyMap(), jobManager).get();
        Assert.assertEquals((Object)HttpResponseStatus.CREATED, (Object)response.getStatus());
        Assert.assertEquals((Object)"application/json; charset=UTF-8", (Object)response.headers().get("Content-Type"));
        Assert.assertEquals((Object)Integer.toString(response.content().readableBytes()), (Object)response.headers().get("Content-Length"));
        json = response.content().toString(Charset.forName("UTF-8"));
        root = new ObjectMapper().readTree(json);
        Assert.assertEquals((Object)"success", (Object)root.get("status").asText());
        Assert.assertEquals((Object)"1", (Object)root.get("request-id").asText());
        Assert.assertEquals((Object)"_path-savepoint_", (Object)root.get("savepoint-path").asText());
        params.put("requestId", "9929");
        response = (FullHttpResponse)progress.handleRequest(params, Collections.emptyMap(), jobManager).get();
        Assert.assertEquals((Object)HttpResponseStatus.BAD_REQUEST, (Object)response.getStatus());
        Assert.assertEquals((Object)"application/json; charset=UTF-8", (Object)response.headers().get("Content-Type"));
        Assert.assertEquals((Object)Integer.toString(response.content().readableBytes()), (Object)response.headers().get("Content-Length"));
        json = response.content().toString(Charset.forName("UTF-8"));
        root = new ObjectMapper().readTree(json);
        Assert.assertEquals((Object)"failed", (Object)root.get("status").asText());
        Assert.assertEquals((Object)"9929", (Object)root.get("request-id").asText());
        Assert.assertEquals((Object)"Unknown job/request ID", (Object)root.get("cause").asText());
    }

    @Test
    public void testFailedCancellation() throws Exception {
        JobID jobId = new JobID();
        ExecutionGraphCache holder = (ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class);
        ExecutionGraph graph = (ExecutionGraph)Mockito.mock(ExecutionGraph.class);
        Mockito.when((Object)holder.getExecutionGraph((JobID)Matchers.eq((Object)jobId), (RestfulGateway)Matchers.any(JobManagerGateway.class))).thenReturn(CompletableFuture.completedFuture(graph));
        Mockito.when((Object)graph.getCheckpointCoordinatorConfiguration()).thenReturn((Object)new CheckpointCoordinatorConfiguration(1L, 1L, 1L, 1, ExternalizedCheckpointSettings.none(), true));
        JobCancellationWithSavepointHandlers handlers = new JobCancellationWithSavepointHandlers(holder, executor);
        JobCancellationWithSavepointHandlers.TriggerHandler trigger = handlers.getTriggerHandler();
        JobCancellationWithSavepointHandlers.InProgressHandler progress = handlers.getInProgressHandler();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jobid", jobId.toString());
        params.put("targetDirectory", "custom-directory");
        JobManagerGateway jobManager = (JobManagerGateway)Mockito.mock(JobManagerGateway.class);
        CompletableFuture unsuccessfulCancelWithSavepoint = FutureUtils.completedExceptionally((Throwable)new Exception("Test Exception"));
        Mockito.when((Object)jobManager.cancelJobWithSavepoint((JobID)Matchers.eq((Object)jobId), (String)Matchers.eq((Object)"custom-directory"), (Time)Matchers.any(Time.class))).thenReturn((Object)unsuccessfulCancelWithSavepoint);
        trigger.handleRequest(params, Collections.emptyMap(), jobManager);
        ((JobManagerGateway)Mockito.verify((Object)jobManager)).cancelJobWithSavepoint((JobID)Matchers.eq((Object)jobId), (String)Matchers.eq((Object)"custom-directory"), (Time)Matchers.any(Time.class));
        params.put("requestId", "1");
        FullHttpResponse response = (FullHttpResponse)progress.handleRequest(params, Collections.emptyMap(), jobManager).get();
        Assert.assertEquals((Object)HttpResponseStatus.INTERNAL_SERVER_ERROR, (Object)response.getStatus());
        Assert.assertEquals((Object)"application/json; charset=UTF-8", (Object)response.headers().get("Content-Type"));
        Assert.assertEquals((Object)Integer.toString(response.content().readableBytes()), (Object)response.headers().get("Content-Length"));
        String json = response.content().toString(Charset.forName("UTF-8"));
        JsonNode root = new ObjectMapper().readTree(json);
        Assert.assertEquals((Object)"failed", (Object)root.get("status").asText());
        Assert.assertEquals((Object)"1", (Object)root.get("request-id").asText());
        Assert.assertEquals((Object)"Test Exception", (Object)root.get("cause").asText());
    }
}

