/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JobConfigHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedJobGenerationUtils;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class JobConfigHandlerTest {
    @Test
    public void testArchiver() throws Exception {
        JobConfigHandler.JobConfigJsonArchivist archivist = new JobConfigHandler.JobConfigJsonArchivist();
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        Collection archives = archivist.archiveJsonWithPath(originalJob);
        Assert.assertEquals((long)1L, (long)archives.size());
        ArchivedJson archive = (ArchivedJson)archives.iterator().next();
        Assert.assertEquals((Object)("/jobs/" + originalJob.getJobID() + "/config"), (Object)archive.getPath());
        JobConfigHandlerTest.compareJobConfig(originalJob, archive.getJson());
    }

    @Test
    public void testGetPaths() {
        JobConfigHandler handler = new JobConfigHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor());
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/config", (Object)paths[0]);
    }

    public void testJsonGeneration() throws Exception {
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        String answer = JobConfigHandler.createJobConfigJson((AccessExecutionGraph)originalJob);
        JobConfigHandlerTest.compareJobConfig(originalJob, answer);
    }

    private static void compareJobConfig(AccessExecutionGraph originalJob, String answer) throws IOException {
        JsonNode job = ArchivedJobGenerationUtils.MAPPER.readTree(answer);
        Assert.assertEquals((Object)originalJob.getJobID().toString(), (Object)job.get("jid").asText());
        Assert.assertEquals((Object)originalJob.getJobName(), (Object)job.get("name").asText());
        ArchivedExecutionConfig originalConfig = originalJob.getArchivedExecutionConfig();
        JsonNode config = job.get("execution-config");
        Assert.assertEquals((Object)originalConfig.getExecutionMode(), (Object)config.get("execution-mode").asText());
        Assert.assertEquals((Object)originalConfig.getRestartStrategyDescription(), (Object)config.get("restart-strategy").asText());
        Assert.assertEquals((long)originalConfig.getParallelism(), (long)config.get("job-parallelism").asInt());
        Assert.assertEquals((Object)originalConfig.getObjectReuseEnabled(), (Object)config.get("object-reuse-mode").asBoolean());
        Map originalUserConfig = originalConfig.getGlobalJobParameters();
        JsonNode userConfig = config.get("user-config");
        for (Map.Entry originalEntry : originalUserConfig.entrySet()) {
            Assert.assertEquals(originalEntry.getValue(), (Object)userConfig.get((String)originalEntry.getKey()).asText());
        }
    }
}

