/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JobDetailsHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedJobGenerationUtils;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class JobDetailsHandlerTest {
    @Test
    public void testArchiver() throws Exception {
        JobDetailsHandler.JobDetailsJsonArchivist archivist = new JobDetailsHandler.JobDetailsJsonArchivist();
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        Collection archives = archivist.archiveJsonWithPath(originalJob);
        Assert.assertEquals((long)2L, (long)archives.size());
        Iterator iterator = archives.iterator();
        ArchivedJson archive1 = (ArchivedJson)iterator.next();
        Assert.assertEquals((Object)("/jobs/" + originalJob.getJobID()), (Object)archive1.getPath());
        JobDetailsHandlerTest.compareJobDetails(originalJob, archive1.getJson());
        ArchivedJson archive2 = (ArchivedJson)iterator.next();
        Assert.assertEquals((Object)("/jobs/" + originalJob.getJobID() + "/vertices"), (Object)archive2.getPath());
        JobDetailsHandlerTest.compareJobDetails(originalJob, archive2.getJson());
    }

    @Test
    public void testGetPaths() {
        JobDetailsHandler handler = new JobDetailsHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), null);
        Object[] paths = handler.getPaths();
        Assert.assertEquals((long)2L, (long)paths.length);
        ArrayList pathsList = Lists.newArrayList((Object[])paths);
        Assert.assertTrue((boolean)pathsList.contains("/jobs/:jobid"));
        Assert.assertTrue((boolean)pathsList.contains("/jobs/:jobid/vertices"));
    }

    @Test
    public void testJsonGeneration() throws Exception {
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        String json = JobDetailsHandler.createJobDetailsJson((AccessExecutionGraph)originalJob, null);
        JobDetailsHandlerTest.compareJobDetails(originalJob, json);
    }

    private static void compareJobDetails(AccessExecutionGraph originalJob, String json) throws IOException {
        JsonNode result = ArchivedJobGenerationUtils.MAPPER.readTree(json);
        Assert.assertEquals((Object)originalJob.getJobID().toString(), (Object)result.get("jid").asText());
        Assert.assertEquals((Object)originalJob.getJobName(), (Object)result.get("name").asText());
        Assert.assertEquals((Object)originalJob.isStoppable(), (Object)result.get("isStoppable").asBoolean());
        Assert.assertEquals((Object)originalJob.getState().name(), (Object)result.get("state").asText());
        Assert.assertEquals((long)originalJob.getStatusTimestamp(JobStatus.CREATED), (long)result.get("start-time").asLong());
        Assert.assertEquals((long)originalJob.getStatusTimestamp(originalJob.getState()), (long)result.get("end-time").asLong());
        Assert.assertEquals((long)(originalJob.getStatusTimestamp(originalJob.getState()) - originalJob.getStatusTimestamp(JobStatus.CREATED)), (long)result.get("duration").asLong());
        JsonNode timestamps = result.get("timestamps");
        for (JobStatus status : JobStatus.values()) {
            Assert.assertEquals((long)originalJob.getStatusTimestamp(status), (long)timestamps.get(status.name()).asLong());
        }
        ArrayNode tasks = (ArrayNode)result.get("vertices");
        int x = 0;
        for (AccessExecutionJobVertex expectedTask : originalJob.getVerticesTopologically()) {
            JsonNode task = tasks.get(x);
            Assert.assertEquals((Object)expectedTask.getJobVertexId().toString(), (Object)task.get("id").asText());
            Assert.assertEquals((Object)expectedTask.getName(), (Object)task.get("name").asText());
            Assert.assertEquals((long)expectedTask.getParallelism(), (long)task.get("parallelism").asInt());
            Assert.assertEquals((Object)expectedTask.getAggregateState().name(), (Object)task.get("status").asText());
            Assert.assertEquals((long)3L, (long)task.get("start-time").asLong());
            Assert.assertEquals((long)5L, (long)task.get("end-time").asLong());
            Assert.assertEquals((long)2L, (long)task.get("duration").asLong());
            JsonNode subtasksPerState = task.get("tasks");
            Assert.assertEquals((long)0L, (long)subtasksPerState.get(ExecutionState.CREATED.name()).asInt());
            Assert.assertEquals((long)0L, (long)subtasksPerState.get(ExecutionState.SCHEDULED.name()).asInt());
            Assert.assertEquals((long)0L, (long)subtasksPerState.get(ExecutionState.DEPLOYING.name()).asInt());
            Assert.assertEquals((long)0L, (long)subtasksPerState.get(ExecutionState.RUNNING.name()).asInt());
            Assert.assertEquals((long)1L, (long)subtasksPerState.get(ExecutionState.FINISHED.name()).asInt());
            Assert.assertEquals((long)0L, (long)subtasksPerState.get(ExecutionState.CANCELING.name()).asInt());
            Assert.assertEquals((long)0L, (long)subtasksPerState.get(ExecutionState.CANCELED.name()).asInt());
            Assert.assertEquals((long)0L, (long)subtasksPerState.get(ExecutionState.FAILED.name()).asInt());
            long expectedNumBytesIn = 0L;
            long expectedNumBytesOut = 0L;
            long expectedNumRecordsIn = 0L;
            long expectedNumRecordsOut = 0L;
            for (AccessExecutionVertex vertex : expectedTask.getTaskVertices()) {
                IOMetrics ioMetrics = vertex.getCurrentExecutionAttempt().getIOMetrics();
                expectedNumBytesIn += ioMetrics.getNumBytesInLocal() + ioMetrics.getNumBytesInRemote();
                expectedNumBytesOut += ioMetrics.getNumBytesOut();
                expectedNumRecordsIn += ioMetrics.getNumRecordsIn();
                expectedNumRecordsOut += ioMetrics.getNumRecordsOut();
            }
            JsonNode metrics = task.get("metrics");
            Assert.assertEquals((long)expectedNumBytesIn, (long)metrics.get("read-bytes").asLong());
            Assert.assertEquals((long)expectedNumBytesOut, (long)metrics.get("write-bytes").asLong());
            Assert.assertEquals((long)expectedNumRecordsIn, (long)metrics.get("read-records").asLong());
            Assert.assertEquals((long)expectedNumRecordsOut, (long)metrics.get("write-records").asLong());
            ++x;
        }
        Assert.assertEquals((long)1L, (long)tasks.size());
        JsonNode statusCounts = result.get("status-counts");
        Assert.assertEquals((long)0L, (long)statusCounts.get(ExecutionState.CREATED.name()).asInt());
        Assert.assertEquals((long)0L, (long)statusCounts.get(ExecutionState.SCHEDULED.name()).asInt());
        Assert.assertEquals((long)0L, (long)statusCounts.get(ExecutionState.DEPLOYING.name()).asInt());
        Assert.assertEquals((long)1L, (long)statusCounts.get(ExecutionState.RUNNING.name()).asInt());
        Assert.assertEquals((long)0L, (long)statusCounts.get(ExecutionState.FINISHED.name()).asInt());
        Assert.assertEquals((long)0L, (long)statusCounts.get(ExecutionState.CANCELING.name()).asInt());
        Assert.assertEquals((long)0L, (long)statusCounts.get(ExecutionState.CANCELED.name()).asInt());
        Assert.assertEquals((long)0L, (long)statusCounts.get(ExecutionState.FAILED.name()).asInt());
        Assert.assertEquals((Object)ArchivedJobGenerationUtils.MAPPER.readTree(originalJob.getJsonPlan()), (Object)result.get("plan"));
    }
}

