/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JobExceptionsHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedJobGenerationUtils;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class JobExceptionsHandlerTest {
    @Test
    public void testArchiver() throws Exception {
        JobExceptionsHandler.JobExceptionsJsonArchivist archivist = new JobExceptionsHandler.JobExceptionsJsonArchivist();
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        Collection archives = archivist.archiveJsonWithPath(originalJob);
        Assert.assertEquals((long)1L, (long)archives.size());
        ArchivedJson archive = (ArchivedJson)archives.iterator().next();
        Assert.assertEquals((Object)("/jobs/" + originalJob.getJobID() + "/exceptions"), (Object)archive.getPath());
        JobExceptionsHandlerTest.compareExceptions(originalJob, archive.getJson());
    }

    @Test
    public void testGetPaths() {
        JobExceptionsHandler handler = new JobExceptionsHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor());
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/exceptions", (Object)paths[0]);
    }

    @Test
    public void testJsonGeneration() throws Exception {
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        String json = JobExceptionsHandler.createJobExceptionsJson((AccessExecutionGraph)originalJob);
        JobExceptionsHandlerTest.compareExceptions(originalJob, json);
    }

    private static void compareExceptions(AccessExecutionGraph originalJob, String json) throws IOException {
        JsonNode result = ArchivedJobGenerationUtils.MAPPER.readTree(json);
        Assert.assertEquals((Object)originalJob.getFailureInfo().getExceptionAsString(), (Object)result.get("root-exception").asText());
        Assert.assertEquals((long)originalJob.getFailureInfo().getTimestamp(), (long)result.get("timestamp").asLong());
        ArrayNode exceptions = (ArrayNode)result.get("all-exceptions");
        int x = 0;
        for (AccessExecutionVertex expectedSubtask : originalJob.getAllExecutionVertices()) {
            if (!expectedSubtask.getFailureCauseAsString().equals("(null)")) {
                JsonNode exception = exceptions.get(x);
                Assert.assertEquals((Object)expectedSubtask.getFailureCauseAsString(), (Object)exception.get("exception").asText());
                Assert.assertEquals((long)expectedSubtask.getStateTimestamp(ExecutionState.FAILED), (long)exception.get("timestamp").asLong());
                Assert.assertEquals((Object)expectedSubtask.getTaskNameWithSubtaskIndex(), (Object)exception.get("task").asText());
                TaskManagerLocation location = expectedSubtask.getCurrentAssignedResourceLocation();
                String expectedLocationString = location.getFQDNHostname() + ':' + location.dataPort();
                Assert.assertEquals((Object)expectedLocationString, (Object)exception.get("location").asText());
            }
            ++x;
        }
        Assert.assertEquals((Object)(x > 20 ? 1 : 0), (Object)result.get("truncated").asBoolean());
    }
}

