/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.util.Collection;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JobPlanHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedJobGenerationUtils;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class JobPlanHandlerTest {
    @Test
    public void testArchiver() throws Exception {
        JobPlanHandler.JobPlanJsonArchivist archivist = new JobPlanHandler.JobPlanJsonArchivist();
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        Collection archives = archivist.archiveJsonWithPath(originalJob);
        Assert.assertEquals((long)1L, (long)archives.size());
        ArchivedJson archive = (ArchivedJson)archives.iterator().next();
        Assert.assertEquals((Object)("/jobs/" + originalJob.getJobID() + "/plan"), (Object)archive.getPath());
        Assert.assertEquals((Object)originalJob.getJsonPlan(), (Object)archive.getJson());
    }

    @Test
    public void testGetPaths() {
        JobPlanHandler handler = new JobPlanHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor());
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/plan", (Object)paths[0]);
    }
}

