/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JobVertexAccumulatorsHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedJobGenerationUtils;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class JobVertexAccumulatorsHandlerTest {
    @Test
    public void testArchiver() throws Exception {
        JobVertexAccumulatorsHandler.JobVertexAccumulatorsJsonArchivist archivist = new JobVertexAccumulatorsHandler.JobVertexAccumulatorsJsonArchivist();
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        AccessExecutionJobVertex originalTask = ArchivedJobGenerationUtils.getTestTask();
        Collection archives = archivist.archiveJsonWithPath(originalJob);
        Assert.assertEquals((long)1L, (long)archives.size());
        ArchivedJson archive = (ArchivedJson)archives.iterator().next();
        Assert.assertEquals((Object)("/jobs/" + originalJob.getJobID() + "/vertices/" + originalTask.getJobVertexId() + "/accumulators"), (Object)archive.getPath());
        JobVertexAccumulatorsHandlerTest.compareAccumulators(originalTask, archive.getJson());
    }

    @Test
    public void testGetPaths() {
        JobVertexAccumulatorsHandler handler = new JobVertexAccumulatorsHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor());
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/vertices/:vertexid/accumulators", (Object)paths[0]);
    }

    @Test
    public void testJsonGeneration() throws Exception {
        AccessExecutionJobVertex originalTask = ArchivedJobGenerationUtils.getTestTask();
        String json = JobVertexAccumulatorsHandler.createVertexAccumulatorsJson((AccessExecutionJobVertex)originalTask);
        JobVertexAccumulatorsHandlerTest.compareAccumulators(originalTask, json);
    }

    private static void compareAccumulators(AccessExecutionJobVertex originalTask, String json) throws IOException {
        JsonNode result = ArchivedJobGenerationUtils.MAPPER.readTree(json);
        Assert.assertEquals((Object)originalTask.getJobVertexId().toString(), (Object)result.get("id").asText());
        ArrayNode accs = (ArrayNode)result.get("user-accumulators");
        StringifiedAccumulatorResult[] expectedAccs = originalTask.getAggregatedUserAccumulatorsStringified();
        ArchivedJobGenerationUtils.compareStringifiedAccumulators(expectedAccs, accs);
    }
}

