/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.util.Collections;
import java.util.Optional;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JobVertexBackPressureHandler;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.BackPressureStatsTracker;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.OperatorBackPressureStats;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class JobVertexBackPressureHandlerTest {
    @Test
    public void testGetPaths() {
        JobVertexBackPressureHandler handler = new JobVertexBackPressureHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), (BackPressureStatsTracker)Mockito.mock(BackPressureStatsTracker.class), 0);
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/vertices/:vertexid/backpressure", (Object)paths[0]);
    }

    @Test
    public void testResponseNoStatsAvailable() throws Exception {
        ExecutionJobVertex jobVertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        BackPressureStatsTracker statsTracker = (BackPressureStatsTracker)Mockito.mock(BackPressureStatsTracker.class);
        Mockito.when((Object)statsTracker.getOperatorBackPressureStats((ExecutionJobVertex)Matchers.any(ExecutionJobVertex.class))).thenReturn(Optional.empty());
        JobVertexBackPressureHandler handler = new JobVertexBackPressureHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), statsTracker, 9999);
        String response = (String)handler.handleRequest((AccessExecutionJobVertex)jobVertex, Collections.emptyMap()).get();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(response);
        Assert.assertEquals((long)1L, (long)rootNode.size());
        JsonNode status = rootNode.get("status");
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((Object)"deprecated", (Object)status.textValue());
        ((BackPressureStatsTracker)Mockito.verify((Object)statsTracker)).triggerStackTraceSample((ExecutionJobVertex)Matchers.any(ExecutionJobVertex.class));
    }

    @Test
    public void testResponseStatsAvailable() throws Exception {
        ExecutionJobVertex jobVertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        BackPressureStatsTracker statsTracker = (BackPressureStatsTracker)Mockito.mock(BackPressureStatsTracker.class);
        OperatorBackPressureStats stats = new OperatorBackPressureStats(0, System.currentTimeMillis(), new double[]{0.31, 0.48, 1.0, 0.0});
        Mockito.when((Object)statsTracker.getOperatorBackPressureStats((ExecutionJobVertex)Matchers.any(ExecutionJobVertex.class))).thenReturn(Optional.of(stats));
        JobVertexBackPressureHandler handler = new JobVertexBackPressureHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), statsTracker, 9999);
        String response = (String)handler.handleRequest((AccessExecutionJobVertex)jobVertex, Collections.emptyMap()).get();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(response);
        Assert.assertEquals((long)4L, (long)rootNode.size());
        JsonNode status = rootNode.get("status");
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((Object)"ok", (Object)status.textValue());
        JsonNode backPressureLevel = rootNode.get("backpressure-level");
        Assert.assertNotNull((Object)backPressureLevel);
        Assert.assertEquals((Object)"high", (Object)backPressureLevel.textValue());
        JsonNode endTimeStamp = rootNode.get("end-timestamp");
        Assert.assertNotNull((Object)endTimeStamp);
        Assert.assertEquals((long)stats.getEndTimestamp(), (long)endTimeStamp.longValue());
        JsonNode subTasks = rootNode.get("subtasks");
        Assert.assertEquals((long)stats.getNumberOfSubTasks(), (long)subTasks.size());
        for (int i = 0; i < subTasks.size(); ++i) {
            JsonNode subTask = subTasks.get(i);
            JsonNode index = subTask.get("subtask");
            Assert.assertEquals((long)i, (long)index.intValue());
            JsonNode level = subTask.get("backpressure-level");
            Assert.assertEquals((Object)JobVertexBackPressureHandler.getBackPressureLevel((double)stats.getBackPressureRatio(i)), (Object)level.textValue());
            JsonNode ratio = subTask.get("ratio");
            Assert.assertEquals((double)stats.getBackPressureRatio(i), (double)ratio.doubleValue(), (double)0.0);
        }
        ((BackPressureStatsTracker)Mockito.verify((Object)statsTracker, (VerificationMode)Mockito.never())).triggerStackTraceSample((ExecutionJobVertex)Matchers.any(ExecutionJobVertex.class));
    }

    @Test
    public void testResponsePassedRefreshInterval() throws Exception {
        ExecutionJobVertex jobVertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        BackPressureStatsTracker statsTracker = (BackPressureStatsTracker)Mockito.mock(BackPressureStatsTracker.class);
        OperatorBackPressureStats stats = new OperatorBackPressureStats(0, System.currentTimeMillis(), new double[]{0.31, 0.48, 1.0, 0.0});
        Mockito.when((Object)statsTracker.getOperatorBackPressureStats((ExecutionJobVertex)Matchers.any(ExecutionJobVertex.class))).thenReturn(Optional.of(stats));
        JobVertexBackPressureHandler handler = new JobVertexBackPressureHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), statsTracker, 0);
        String response = (String)handler.handleRequest((AccessExecutionJobVertex)jobVertex, Collections.emptyMap()).get();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(response);
        Assert.assertEquals((long)4L, (long)rootNode.size());
        JsonNode status = rootNode.get("status");
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((Object)"deprecated", (Object)status.textValue());
        JsonNode backPressureLevel = rootNode.get("backpressure-level");
        Assert.assertNotNull((Object)backPressureLevel);
        Assert.assertEquals((Object)"high", (Object)backPressureLevel.textValue());
        JsonNode endTimeStamp = rootNode.get("end-timestamp");
        Assert.assertNotNull((Object)endTimeStamp);
        Assert.assertEquals((long)stats.getEndTimestamp(), (long)endTimeStamp.longValue());
        JsonNode subTasks = rootNode.get("subtasks");
        Assert.assertEquals((long)stats.getNumberOfSubTasks(), (long)subTasks.size());
        for (int i = 0; i < subTasks.size(); ++i) {
            JsonNode subTask = subTasks.get(i);
            JsonNode index = subTask.get("subtask");
            Assert.assertEquals((long)i, (long)index.intValue());
            JsonNode level = subTask.get("backpressure-level");
            Assert.assertEquals((Object)JobVertexBackPressureHandler.getBackPressureLevel((double)stats.getBackPressureRatio(i)), (Object)level.textValue());
            JsonNode ratio = subTask.get("ratio");
            Assert.assertEquals((double)stats.getBackPressureRatio(i), (double)ratio.doubleValue(), (double)0.0);
        }
        ((BackPressureStatsTracker)Mockito.verify((Object)statsTracker)).triggerStackTraceSample((ExecutionJobVertex)Matchers.any(ExecutionJobVertex.class));
    }
}

