/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.JobVertexTaskManagersHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedJobGenerationUtils;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class JobVertexTaskManagersHandlerTest
extends TestLogger {
    @Test
    public void testArchiver() throws Exception {
        JobVertexTaskManagersHandler.JobVertexTaskManagersJsonArchivist archivist = new JobVertexTaskManagersHandler.JobVertexTaskManagersJsonArchivist();
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        AccessExecutionJobVertex originalTask = ArchivedJobGenerationUtils.getTestTask();
        AccessExecutionVertex originalSubtask = ArchivedJobGenerationUtils.getTestSubtask();
        Collection archives = archivist.archiveJsonWithPath(originalJob);
        Assert.assertEquals((long)1L, (long)archives.size());
        ArchivedJson archive = (ArchivedJson)archives.iterator().next();
        Assert.assertEquals((Object)("/jobs/" + originalJob.getJobID() + "/vertices/" + originalTask.getJobVertexId() + "/taskmanagers"), (Object)archive.getPath());
        JobVertexTaskManagersHandlerTest.compareVertexTaskManagers(originalTask, originalSubtask, archive.getJson());
    }

    @Test
    public void testGetPaths() {
        JobVertexTaskManagersHandler handler = new JobVertexTaskManagersHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor(), null);
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/vertices/:vertexid/taskmanagers", (Object)paths[0]);
    }

    @Test
    public void testJsonGeneration() throws Exception {
        AccessExecutionJobVertex originalTask = ArchivedJobGenerationUtils.getTestTask();
        AccessExecutionVertex originalSubtask = ArchivedJobGenerationUtils.getTestSubtask();
        String json = JobVertexTaskManagersHandler.createVertexDetailsByTaskManagerJson((AccessExecutionJobVertex)originalTask, (String)ArchivedJobGenerationUtils.getTestJob().getJobID().toString(), null);
        JobVertexTaskManagersHandlerTest.compareVertexTaskManagers(originalTask, originalSubtask, json);
    }

    private static void compareVertexTaskManagers(AccessExecutionJobVertex originalTask, AccessExecutionVertex originalSubtask, String json) throws IOException {
        JsonNode result = ArchivedJobGenerationUtils.MAPPER.readTree(json);
        Assert.assertEquals((Object)originalTask.getJobVertexId().toString(), (Object)result.get("id").asText());
        Assert.assertEquals((Object)originalTask.getName(), (Object)result.get("name").asText());
        Assert.assertTrue((result.get("now").asLong() > 0L ? 1 : 0) != 0);
        ArrayNode taskmanagers = (ArrayNode)result.get("taskmanagers");
        JsonNode taskManager = taskmanagers.get(0);
        TaskManagerLocation location = originalSubtask.getCurrentAssignedResourceLocation();
        String expectedLocationString = location.getHostname() + ':' + location.dataPort();
        Assert.assertEquals((Object)expectedLocationString, (Object)taskManager.get("host").asText());
        Assert.assertEquals((Object)ExecutionState.FINISHED.name(), (Object)taskManager.get("status").asText());
        Assert.assertEquals((long)3L, (long)taskManager.get("start-time").asLong());
        Assert.assertEquals((long)5L, (long)taskManager.get("end-time").asLong());
        Assert.assertEquals((long)2L, (long)taskManager.get("duration").asLong());
        JsonNode statusCounts = taskManager.get("status-counts");
        Assert.assertEquals((long)0L, (long)statusCounts.get(ExecutionState.CREATED.name()).asInt());
        Assert.assertEquals((long)0L, (long)statusCounts.get(ExecutionState.SCHEDULED.name()).asInt());
        Assert.assertEquals((long)0L, (long)statusCounts.get(ExecutionState.DEPLOYING.name()).asInt());
        Assert.assertEquals((long)0L, (long)statusCounts.get(ExecutionState.RUNNING.name()).asInt());
        Assert.assertEquals((long)1L, (long)statusCounts.get(ExecutionState.FINISHED.name()).asInt());
        Assert.assertEquals((long)0L, (long)statusCounts.get(ExecutionState.CANCELING.name()).asInt());
        Assert.assertEquals((long)0L, (long)statusCounts.get(ExecutionState.CANCELED.name()).asInt());
        Assert.assertEquals((long)0L, (long)statusCounts.get(ExecutionState.FAILED.name()).asInt());
        long expectedNumBytesIn = 0L;
        long expectedNumBytesOut = 0L;
        long expectedNumRecordsIn = 0L;
        long expectedNumRecordsOut = 0L;
        for (AccessExecutionVertex vertex : originalTask.getTaskVertices()) {
            IOMetrics ioMetrics = vertex.getCurrentExecutionAttempt().getIOMetrics();
            expectedNumBytesIn += ioMetrics.getNumBytesInLocal() + ioMetrics.getNumBytesInRemote();
            expectedNumBytesOut += ioMetrics.getNumBytesOut();
            expectedNumRecordsIn += ioMetrics.getNumRecordsIn();
            expectedNumRecordsOut += ioMetrics.getNumRecordsOut();
        }
        JsonNode metrics = taskManager.get("metrics");
        Assert.assertEquals((long)expectedNumBytesIn, (long)metrics.get("read-bytes").asLong());
        Assert.assertEquals((long)expectedNumBytesOut, (long)metrics.get("write-bytes").asLong());
        Assert.assertEquals((long)expectedNumRecordsIn, (long)metrics.get("read-records").asLong());
        Assert.assertEquals((long)expectedNumRecordsOut, (long)metrics.get("write-records").asLong());
    }
}

