/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.SubtaskExecutionAttemptAccumulatorsHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedJobGenerationUtils;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SubtaskExecutionAttemptAccumulatorsHandlerTest
extends TestLogger {
    @Test
    public void testArchiver() throws Exception {
        SubtaskExecutionAttemptAccumulatorsHandler.SubtaskExecutionAttemptAccumulatorsJsonArchivist archivist = new SubtaskExecutionAttemptAccumulatorsHandler.SubtaskExecutionAttemptAccumulatorsJsonArchivist();
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        AccessExecutionJobVertex originalTask = ArchivedJobGenerationUtils.getTestTask();
        AccessExecution originalAttempt = ArchivedJobGenerationUtils.getTestAttempt();
        Collection archives = archivist.archiveJsonWithPath(originalJob);
        Assert.assertEquals((long)1L, (long)archives.size());
        ArchivedJson archive = (ArchivedJson)archives.iterator().next();
        Assert.assertEquals((Object)("/jobs/" + originalJob.getJobID() + "/vertices/" + originalTask.getJobVertexId() + "/subtasks/" + originalAttempt.getParallelSubtaskIndex() + "/attempts/" + originalAttempt.getAttemptNumber() + "/accumulators"), (Object)archive.getPath());
        SubtaskExecutionAttemptAccumulatorsHandlerTest.compareAttemptAccumulators(originalAttempt, archive.getJson());
    }

    @Test
    public void testGetPaths() {
        SubtaskExecutionAttemptAccumulatorsHandler handler = new SubtaskExecutionAttemptAccumulatorsHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor());
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/vertices/:vertexid/subtasks/:subtasknum/attempts/:attempt/accumulators", (Object)paths[0]);
    }

    @Test
    public void testJsonGeneration() throws Exception {
        AccessExecution originalAttempt = ArchivedJobGenerationUtils.getTestAttempt();
        String json = SubtaskExecutionAttemptAccumulatorsHandler.createAttemptAccumulatorsJson((AccessExecution)originalAttempt);
        SubtaskExecutionAttemptAccumulatorsHandlerTest.compareAttemptAccumulators(originalAttempt, json);
    }

    private static void compareAttemptAccumulators(AccessExecution originalAttempt, String json) throws IOException {
        JsonNode result = ArchivedJobGenerationUtils.MAPPER.readTree(json);
        Assert.assertEquals((long)originalAttempt.getParallelSubtaskIndex(), (long)result.get("subtask").asInt());
        Assert.assertEquals((long)originalAttempt.getAttemptNumber(), (long)result.get("attempt").asInt());
        Assert.assertEquals((Object)originalAttempt.getAttemptId().toString(), (Object)result.get("id").asText());
        ArchivedJobGenerationUtils.compareStringifiedAccumulators(originalAttempt.getUserAccumulatorsStringified(), (ArrayNode)result.get("user-accumulators"));
    }
}

