/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.SubtasksAllAccumulatorsHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedJobGenerationUtils;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SubtasksAllAccumulatorsHandlerTest
extends TestLogger {
    @Test
    public void testArchiver() throws Exception {
        SubtasksAllAccumulatorsHandler.SubtasksAllAccumulatorsJsonArchivist archivist = new SubtasksAllAccumulatorsHandler.SubtasksAllAccumulatorsJsonArchivist();
        AccessExecutionGraph originalJob = ArchivedJobGenerationUtils.getTestJob();
        AccessExecutionJobVertex originalTask = ArchivedJobGenerationUtils.getTestTask();
        Collection archives = archivist.archiveJsonWithPath(originalJob);
        Assert.assertEquals((long)1L, (long)archives.size());
        ArchivedJson archive = (ArchivedJson)archives.iterator().next();
        Assert.assertEquals((Object)("/jobs/" + originalJob.getJobID() + "/vertices/" + originalTask.getJobVertexId() + "/subtasks/accumulators"), (Object)archive.getPath());
        SubtasksAllAccumulatorsHandlerTest.compareSubtaskAccumulators(originalTask, archive.getJson());
    }

    @Test
    public void testGetPaths() {
        SubtasksAllAccumulatorsHandler handler = new SubtasksAllAccumulatorsHandler((ExecutionGraphCache)Mockito.mock(ExecutionGraphCache.class), Executors.directExecutor());
        String[] paths = handler.getPaths();
        Assert.assertEquals((long)1L, (long)paths.length);
        Assert.assertEquals((Object)"/jobs/:jobid/vertices/:vertexid/subtasks/accumulators", (Object)paths[0]);
    }

    @Test
    public void testJsonGeneration() throws Exception {
        AccessExecutionJobVertex originalTask = ArchivedJobGenerationUtils.getTestTask();
        String json = SubtasksAllAccumulatorsHandler.createSubtasksAccumulatorsJson((AccessExecutionJobVertex)originalTask);
        SubtasksAllAccumulatorsHandlerTest.compareSubtaskAccumulators(originalTask, json);
    }

    private static void compareSubtaskAccumulators(AccessExecutionJobVertex originalTask, String json) throws IOException {
        JsonNode result = ArchivedJobGenerationUtils.MAPPER.readTree(json);
        Assert.assertEquals((Object)originalTask.getJobVertexId().toString(), (Object)result.get("id").asText());
        Assert.assertEquals((long)originalTask.getParallelism(), (long)result.get("parallelism").asInt());
        ArrayNode subtasks = (ArrayNode)result.get("subtasks");
        Assert.assertEquals((long)originalTask.getTaskVertices().length, (long)subtasks.size());
        for (int x = 0; x < originalTask.getTaskVertices().length; ++x) {
            JsonNode subtask = subtasks.get(x);
            AccessExecutionVertex expectedSubtask = originalTask.getTaskVertices()[x];
            Assert.assertEquals((long)x, (long)subtask.get("subtask").asInt());
            Assert.assertEquals((long)expectedSubtask.getCurrentExecutionAttempt().getAttemptNumber(), (long)subtask.get("attempt").asInt());
            Assert.assertEquals((Object)expectedSubtask.getCurrentAssignedResourceLocation().getHostname(), (Object)subtask.get("host").asText());
            ArchivedJobGenerationUtils.compareStringifiedAccumulators(expectedSubtask.getCurrentExecutionAttempt().getUserAccumulatorsStringified(), (ArrayNode)subtask.get("user-accumulators"));
        }
    }
}

